/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.swing.SelectAllUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;

public class LabeledTextField
extends JPanel {
    protected JTextField _textField;
    protected JLabel _label;
    protected AbstractButton _button;
    protected String _labelText;
    protected Icon _icon;

    public LabeledTextField() {
        this(null, null);
    }

    public LabeledTextField(Icon icon) {
        this(icon, null);
    }

    public LabeledTextField(Icon icon, String labelText) {
        super(new BorderLayout(3, 3));
        this._icon = icon;
        this._labelText = labelText;
        this.initComponent();
    }

    protected void initComponent() {
        this._label = this.createLabel();
        if (this._label != null) {
            this._label.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                }

                public void mousePressed(MouseEvent e) {
                    this.showMenu();
                }

                public void mouseReleased(MouseEvent e) {
                }

                protected void showMenu() {
                    JidePopupMenu menu;
                    if (LabeledTextField.this.isEnabled() && (menu = LabeledTextField.this.createContextMenu()) != null && menu.getComponentCount() > 0) {
                        Point location = LabeledTextField.this._label.getLocation();
                        menu.show(LabeledTextField.this, location.x + (LabeledTextField.this._label.getIcon() == null ? 1 : LabeledTextField.this._label.getIcon().getIconWidth() / 2), location.y + LabeledTextField.this._label.getHeight() + 1);
                    }
                }
            });
        }
        this._button = this.createButton();
        this._textField = this.createTextField();
        if (this._label != null) {
            this.add((Component)this._label, "Before");
        }
        this.add(this._textField);
        if (this._button != null) {
            this.add((Component)this._button, "After");
        }
        this.updateUI();
    }

    protected JTextField createTextField() {
        JTextField textField = new JTextField();
        SelectAllUtils.install(textField);
        textField.setOpaque(false);
        textField.setColumns(20);
        return textField;
    }

    protected JidePopupMenu createContextMenu() {
        return null;
    }

    public void updateUI() {
        super.updateUI();
        this.setBorder(BorderFactory.createCompoundBorder(UIDefaultsLookup.getBorder("TextField.border"), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        if (this.isEnabled()) {
            LookAndFeel.installColors(this, "TextField.background", "TextField.foreground");
        } else {
            LookAndFeel.installColors(this, "TextField.inactiveBackground", "TextField.foreground");
        }
        if (this._textField != null) {
            this._textField.setBorder(BorderFactory.createEmptyBorder());
        }
    }

    protected AbstractButton createButton() {
        return null;
    }

    protected JLabel createLabel() {
        JLabel label = new JLabel(this._icon);
        label.setText(this._labelText);
        return label;
    }

    public void setLabelText(String text) {
        this._labelText = text;
        if (this._label != null) {
            this._label.setText(text);
        }
    }

    public String getLabelText() {
        if (this._label != null) {
            return this._label.getText();
        }
        return this._labelText;
    }

    public void setIcon(Icon icon) {
        this._icon = icon;
        if (this._label != null) {
            this._label.setIcon(icon);
        }
    }

    public Icon getIcon() {
        if (this._label != null) {
            return this._label.getIcon();
        }
        return this._icon;
    }

    public JLabel getLabel() {
        return this._label;
    }

    public AbstractButton getButton() {
        return this._button;
    }

    public void setColumns(int columns) {
        if (this.getTextField() != null) {
            this.getTextField().setColumns(columns);
        }
    }

    public JTextField getTextField() {
        return this._textField;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            if (this.getTextField() != null) {
                this.getTextField().setEnabled(true);
            }
            if (this.getLabel() != null) {
                this.getLabel().setEnabled(true);
            }
            if (this.getButton() != null) {
                this.getButton().setEnabled(true);
            }
            this.setBackground(UIDefaultsLookup.getColor("TextField.background"));
        } else {
            if (this.getTextField() != null) {
                this.getTextField().setEnabled(false);
            }
            if (this.getLabel() != null) {
                this.getLabel().setEnabled(false);
            }
            if (this.getButton() != null) {
                this.getButton().setEnabled(false);
            }
            this.setBackground(UIDefaultsLookup.getColor("control"));
        }
    }

    public int getBaseline(int width, int height) {
        if (SystemInfo.isJdk6Above()) {
            try {
                Method method = Component.class.getMethod("getBaseline", Integer.TYPE, Integer.TYPE);
                Object value = method.invoke((Object)this._textField, width, height);
                if (value instanceof Integer) {
                    return (Integer)value;
                }
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return -1;
    }
}

