/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.PartialSide;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.border.EtchedBorder;

public class PartialEtchedBorder
extends EtchedBorder
implements PartialSide {
    private int _sides;

    public PartialEtchedBorder() {
        this(15);
    }

    public PartialEtchedBorder(int sides) {
        this._sides = sides;
    }

    public PartialEtchedBorder(int etchType, int sides) {
        super(etchType);
        this._sides = sides;
    }

    public PartialEtchedBorder(Color highlight, Color shadow, int sides) {
        super(highlight, shadow);
        this._sides = sides;
    }

    public PartialEtchedBorder(int etchType, Color highlight, Color shadow, int sides) {
        super(etchType, highlight, shadow);
        this._sides = sides;
    }

    public int getSides() {
        return this._sides;
    }

    public void setSides(int sides) {
        this._sides = sides;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int w = width;
        int h = height;
        g.translate(x, y);
        if (c.getBackground() == null) {
            c.setBackground(Color.GRAY);
        }
        Color shadowColor = this.getShadowColor(c);
        Color highlightColor = this.getHighlightColor(c);
        if (this._sides == 15) {
            g.setColor(this.etchType == 1 ? shadowColor : highlightColor);
            g.drawRect(0, 0, w - 2, h - 2);
            g.setColor(this.etchType == 1 ? highlightColor : shadowColor);
            g.drawLine(1, h - 3, 1, 1);
            g.drawLine(1, 1, w - 3, 1);
            g.drawLine(0, h - 1, w - 1, h - 1);
            g.drawLine(w - 1, h - 1, w - 1, 0);
        } else {
            if ((this._sides & 1) != 0) {
                g.setColor(this.etchType == 1 ? shadowColor : highlightColor);
                g.drawLine(0, 0, w - 2, 0);
                g.setColor(this.etchType == 1 ? highlightColor : shadowColor);
                g.drawLine(1, 1, w - 2, 1);
            }
            if ((this._sides & 2) != 0) {
                g.setColor(this.etchType == 1 ? shadowColor : highlightColor);
                g.drawLine(0, h - 2, w - 1, h - 2);
                g.setColor(this.etchType == 1 ? highlightColor : shadowColor);
                g.drawLine(0, h - 1, w - 1, h - 1);
            }
            if ((this._sides & 8) != 0) {
                g.setColor(this.etchType == 1 ? shadowColor : highlightColor);
                g.drawLine(0, h - 2, 0, 0);
                g.setColor(this.etchType == 1 ? highlightColor : shadowColor);
                g.drawLine(1, h - 3, 1, 1);
            }
            if ((this._sides & 4) != 0) {
                g.setColor(this.etchType == 1 ? shadowColor : highlightColor);
                g.drawLine(w - 2, h - 2, w - 2, 0);
                g.setColor(this.etchType == 1 ? highlightColor : shadowColor);
                g.drawLine(w - 1, h - 1, w - 1, 0);
            }
        }
        g.translate(-x, -y);
    }
}

