/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.PartialSide;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.border.LineBorder;

public class PartialLineBorder
extends LineBorder
implements PartialSide {
    private int _sides = 15;

    public PartialLineBorder(Color color) {
        super(color);
    }

    public PartialLineBorder(Color color, int thickness) {
        super(color, thickness);
    }

    public PartialLineBorder(Color color, int thickness, boolean roundedCorners) {
        super(color, thickness, roundedCorners);
    }

    public PartialLineBorder(Color color, int thickness, int side) {
        super(color, thickness);
        this._sides = side;
    }

    public int getSides() {
        return this._sides;
    }

    public void setSides(int sides) {
        this._sides = sides;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.setColor(this.lineColor);
        for (int i = 0; i < this.thickness; ++i) {
            if (this._sides == 15) {
                if (!this.roundedCorners) {
                    g.drawRect(x + i, y + i, width - i - i - 1, height - i - i - 1);
                    continue;
                }
                g.drawRoundRect(x + i, y + i, width - i - i - 1, height - i - i - 1, 5, 5);
                continue;
            }
            if ((this._sides & 1) != 0) {
                g.drawLine(x, y + i, x + width - 1, y + i);
            }
            if ((this._sides & 2) != 0) {
                g.drawLine(x, y + height - i - 1, x + width - 1, y + height - i - 1);
            }
            if ((this._sides & 8) != 0) {
                g.drawLine(x + i, y, x + i, y + height - 1);
            }
            if ((this._sides & 4) == 0) continue;
            g.drawLine(x + width - i - 1, y, x + width - i - 1, y + height - 1);
        }
        g.setColor(oldColor);
    }
}

