/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.Resizable;
import com.jidesoft.swing.ResizablePanel;
import com.jidesoft.swing.ResizableSupport;
import com.jidesoft.utils.SystemInfo;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.border.Border;

public class ResizableFrame
extends JFrame
implements ResizableSupport {
    private ResizablePanel _resizablePanel;

    public ResizableFrame() throws HeadlessException {
        this.initComponents();
    }

    public ResizableFrame(GraphicsConfiguration gc) {
        super(gc);
        this.initComponents();
    }

    public ResizableFrame(String title) throws HeadlessException {
        super(title);
        this.initComponents();
    }

    public ResizableFrame(String title, GraphicsConfiguration gc) {
        super(title, gc);
        this.initComponents();
    }

    protected void initComponents() {
        this.setUndecorated(true);
        this._resizablePanel = new ResizablePanel(){

            protected Resizable createResizable() {
                return new Resizable(this){

                    public void resizing(int resizeDir, int newX, int newY, int newW, int newH) {
                        Container container = ResizableFrame.this.getContentPane();
                        if (SystemInfo.isJdk15Above() || container instanceof JComponent) {
                            container.setPreferredSize(new Dimension(newW, newH));
                        }
                        if (!JFrame.isDefaultLookAndFeelDecorated()) {
                            ResizableFrame.this.setBounds(newX, newY, newW, newH);
                        }
                    }

                    public boolean isTopLevel() {
                        return true;
                    }
                };
            }
        };
        this.setContentPane(this._resizablePanel);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                ResizableFrame.this._resizablePanel.setSize(ResizableFrame.this.getSize());
            }
        });
    }

    public void setBorder(Border border) {
        this._resizablePanel.setBorder(border);
    }

    public Border getBorder() {
        return this._resizablePanel.getBorder();
    }

    public Resizable getResizable() {
        return this._resizablePanel.getResizable();
    }
}

