/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.Resource;
import com.jidesoft.swing.SearchableProvider;
import com.jidesoft.swing.event.SearchableEvent;
import com.jidesoft.swing.event.SearchableListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;

public abstract class Searchable {
    private final PropertyChangeSupport _propertyChangeSupport = new PropertyChangeSupport(this);
    protected final JComponent _component;
    private SearchPopup _popup;
    private JLayeredPane _layeredPane;
    private boolean _heavyweightComponentEnabled;
    private SearchableProvider _searchableProvider;
    private Pattern _pattern;
    private String _searchText;
    private String _previousSearchText;
    private boolean _caseSensitive = false;
    private boolean _repeats = false;
    private boolean _wildcardEnabled = true;
    private Color _mismatchForeground;
    private Color _foreground = null;
    private Color _background = null;
    protected ComponentAdapter _componentListener;
    public static final String PROPERTY_SEARCH_TEXT = "searchText";
    private KeyAdapter _keyListener;
    private FocusAdapter _focusListener;
    private int _cursor = -1;
    private String _searchLabel = this.getResourceString("Searchable.searchFor");
    private String _noMatchLabel = this.getResourceString("Searchable.noMatch");
    private int _popupLocation = 1;
    private int _searchingDelay = 0;
    private boolean _reverseOrder = false;
    protected EventListenerList listenerList = new EventListenerList();
    private Component _popupLocationRelativeTo;

    public Searchable(JComponent component) {
        this._previousSearchText = null;
        this._component = component;
        this.installListeners();
    }

    public Searchable(JComponent component, SearchableProvider searchableProvider) {
        this._searchableProvider = searchableProvider;
        this._previousSearchText = null;
        this._component = component;
        this.installListeners();
    }

    protected abstract int getSelectedIndex();

    protected abstract void setSelectedIndex(int var1, boolean var2);

    protected abstract int getElementCount();

    protected abstract Object getElementAt(int var1);

    protected abstract String convertElementToString(Object var1);

    public void hidePopup() {
        if (this._popup != null) {
            if (this.isHeavyweightComponentEnabled()) {
                this._popup.hidePopupImmediately();
            } else {
                this._layeredPane.remove(this._popup);
                this._layeredPane.validate();
                this._layeredPane.repaint();
                this._layeredPane = null;
            }
            this._popup = null;
            this._searchableProvider = null;
            this.fireSearchableEvent(new SearchableEvent(this, 3000));
        }
        this._cursor = -1;
    }

    public SearchableProvider getSearchableProvider() {
        return this._searchableProvider;
    }

    public void setSearchableProvider(SearchableProvider searchableProvider) {
        this._searchableProvider = searchableProvider;
    }

    public void installListeners() {
        if (this._componentListener == null) {
            this._componentListener = new ComponentAdapter(){

                public void componentHidden(ComponentEvent e) {
                    boolean passive;
                    super.componentHidden(e);
                    boolean bl = passive = Searchable.this._searchableProvider == null || Searchable.this._searchableProvider.isPassive();
                    if (passive) {
                        Searchable.this.hidePopup();
                    }
                }

                public void componentResized(ComponentEvent e) {
                    boolean passive;
                    super.componentResized(e);
                    boolean bl = passive = Searchable.this._searchableProvider == null || Searchable.this._searchableProvider.isPassive();
                    if (passive) {
                        Searchable.this.updateSizeAndLocation();
                    }
                }

                public void componentMoved(ComponentEvent e) {
                    boolean passive;
                    super.componentMoved(e);
                    boolean bl = passive = Searchable.this._searchableProvider == null || Searchable.this._searchableProvider.isPassive();
                    if (passive) {
                        Searchable.this.updateSizeAndLocation();
                    }
                }
            };
        }
        this._component.addComponentListener(this._componentListener);
        Component scrollPane = JideSwingUtilities.getScrollPane(this._component);
        if (scrollPane != null) {
            scrollPane.addComponentListener(this._componentListener);
        }
        this._keyListener = new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                boolean passive;
                boolean bl = passive = Searchable.this._searchableProvider == null || Searchable.this._searchableProvider.isPassive();
                if (passive) {
                    Searchable.this.keyTypedOrPressed(e);
                }
            }

            public void keyPressed(KeyEvent e) {
                boolean passive;
                boolean bl = passive = Searchable.this._searchableProvider == null || Searchable.this._searchableProvider.isPassive();
                if (passive) {
                    Searchable.this.keyTypedOrPressed(e);
                }
            }
        };
        JideSwingUtilities.insertKeyListener(this.getComponent(), this._keyListener, 0);
        this._focusListener = new FocusAdapter(){

            public void focusLost(FocusEvent focusevent) {
                boolean passive;
                boolean bl = passive = Searchable.this._searchableProvider == null || Searchable.this._searchableProvider.isPassive();
                if (passive) {
                    Searchable.this.hidePopup();
                }
            }
        };
        this.getComponent().addFocusListener(this._focusListener);
    }

    public void uninstallListeners() {
        if (this._componentListener != null) {
            this.getComponent().removeComponentListener(this._componentListener);
            Component scrollPane = JideSwingUtilities.getScrollPane(this.getComponent());
            if (scrollPane != null) {
                scrollPane.removeComponentListener(this._componentListener);
            }
            this._componentListener = null;
        }
        if (this._keyListener != null) {
            this.getComponent().removeKeyListener(this._keyListener);
            this._keyListener = null;
        }
        if (this._focusListener != null) {
            this.getComponent().removeFocusListener(this._focusListener);
            this._focusListener = null;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertychangelistener) {
        this._propertyChangeSupport.addPropertyChangeListener(propertychangelistener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertychangelistener) {
        this._propertyChangeSupport.removePropertyChangeListener(propertychangelistener);
    }

    public void firePropertyChangeEvent(String searchingText) {
        if (!searchingText.equals(this._previousSearchText)) {
            this._propertyChangeSupport.firePropertyChange(PROPERTY_SEARCH_TEXT, this._previousSearchText, searchingText);
            this.fireSearchableEvent(new SearchableEvent(this, 3004, searchingText, this._previousSearchText));
            this._previousSearchText = searchingText;
        }
    }

    protected boolean compare(Object element, String searchingText) {
        String text = this.convertElementToString(element);
        return text != null && this.compare(this.isCaseSensitive() ? text : text.toLowerCase(), searchingText);
    }

    protected boolean compare(String text, String searchingText) {
        if (!this.isWildcardEnabled()) {
            return searchingText != null && (searchingText.equals(text) || searchingText.length() > 0 && text.startsWith(searchingText));
        }
        int posAny = searchingText.indexOf(42);
        int posOne = searchingText.indexOf(63);
        if (posAny == -1 && posOne == -1) {
            return text.startsWith(searchingText);
        }
        if (this._searchText != null && this._searchText.equals(searchingText) && this._pattern != null) {
            return this._pattern.matcher(text).find();
        }
        this._searchText = searchingText;
        StringBuffer buffer = new StringBuffer();
        int length = searchingText.length();
        buffer.append('^');
        for (int i = 0; i < length; ++i) {
            char c = searchingText.charAt(i);
            if (c == '?') {
                buffer.append(".");
                continue;
            }
            if (c == '*') {
                buffer.append(".*");
                continue;
            }
            if ("(){}[].^$\\".indexOf(c) != -1) {
                buffer.append('\\');
                buffer.append(c);
                continue;
            }
            buffer.append(c);
        }
        try {
            this._pattern = Pattern.compile(buffer.toString(), this.isCaseSensitive() ? 0 : 2);
            return this._pattern.matcher(text).find();
        }
        catch (PatternSyntaxException e) {
            return false;
        }
    }

    public int getCursor() {
        return this._cursor;
    }

    public void setCursor(int cursor) {
        this._cursor = cursor;
    }

    public int findNext(String s) {
        Object element;
        int i;
        String str = this.isCaseSensitive() ? s : s.toLowerCase();
        int count = this.getElementCount();
        if (count == 0) {
            return s.length() > 0 ? -1 : 0;
        }
        int selectedIndex = this._cursor != -1 ? this._cursor : this.getSelectedIndex();
        for (i = selectedIndex + 1; i < count; ++i) {
            element = this.getElementAt(i);
            if (!this.compare(element, str)) continue;
            return i;
        }
        if (this.isRepeats()) {
            for (i = 0; i < selectedIndex; ++i) {
                element = this.getElementAt(i);
                if (!this.compare(element, str)) continue;
                return i;
            }
        }
        return selectedIndex == -1 ? -1 : (this.compare(this.getElementAt(selectedIndex), str) ? selectedIndex : -1);
    }

    public int findPrevious(String s) {
        Object element;
        int i;
        String str = this.isCaseSensitive() ? s : s.toLowerCase();
        int count = this.getElementCount();
        if (count == 0) {
            return s.length() > 0 ? -1 : 0;
        }
        int selectedIndex = this._cursor != -1 ? this._cursor : this.getSelectedIndex();
        for (i = selectedIndex - 1; i >= 0; --i) {
            element = this.getElementAt(i);
            if (!this.compare(element, str)) continue;
            return i;
        }
        if (this.isRepeats()) {
            for (i = count - 1; i >= selectedIndex; --i) {
                element = this.getElementAt(i);
                if (!this.compare(element, str)) continue;
                return i;
            }
        }
        return selectedIndex == -1 ? -1 : (this.compare(this.getElementAt(selectedIndex), str) ? selectedIndex : -1);
    }

    public int findFromCursor(String s) {
        Object element;
        int i;
        int count;
        int selectedIndex;
        if (this.isReverseOrder()) {
            return this.reverseFindFromCursor(s);
        }
        String str = this.isCaseSensitive() ? s : s.toLowerCase();
        int n = selectedIndex = this._cursor != -1 ? this._cursor : this.getSelectedIndex();
        if (selectedIndex < 0) {
            selectedIndex = 0;
        }
        if ((count = this.getElementCount()) == 0) {
            return -1;
        }
        for (i = selectedIndex; i < count; ++i) {
            element = this.getElementAt(i);
            if (!this.compare(element, str)) continue;
            return i;
        }
        for (i = 0; i < selectedIndex; ++i) {
            element = this.getElementAt(i);
            if (!this.compare(element, str)) continue;
            return i;
        }
        return -1;
    }

    public int reverseFindFromCursor(String s) {
        Object element;
        int i;
        int count;
        int selectedIndex;
        if (!this.isReverseOrder()) {
            return this.findFromCursor(s);
        }
        String str = this.isCaseSensitive() ? s : s.toLowerCase();
        int n = selectedIndex = this._cursor != -1 ? this._cursor : this.getSelectedIndex();
        if (selectedIndex < 0) {
            selectedIndex = 0;
        }
        if ((count = this.getElementCount()) == 0) {
            return -1;
        }
        for (i = selectedIndex; i >= 0; --i) {
            element = this.getElementAt(i);
            if (!this.compare(element, str)) continue;
            return i;
        }
        for (i = count - 1; i >= selectedIndex; --i) {
            element = this.getElementAt(i);
            if (!this.compare(element, str)) continue;
            return i;
        }
        return -1;
    }

    public int findFirst(String s) {
        String str = this.isCaseSensitive() ? s : s.toLowerCase();
        int count = this.getElementCount();
        if (count == 0) {
            return s.length() > 0 ? -1 : 0;
        }
        for (int i = 0; i < count; ++i) {
            int index = this.getIndex(count, i);
            Object element = this.getElementAt(index);
            if (!this.compare(element, str)) continue;
            return index;
        }
        return -1;
    }

    public int findLast(String s) {
        String str = this.isCaseSensitive() ? s : s.toLowerCase();
        int count = this.getElementCount();
        if (count == 0) {
            return s.length() > 0 ? -1 : 0;
        }
        for (int i = count - 1; i >= 0; --i) {
            Object element = this.getElementAt(i);
            if (!this.compare(element, str)) continue;
            return i;
        }
        return -1;
    }

    protected void keyTypedOrPressed(KeyEvent e) {
        if (this._searchableProvider != null && this._searchableProvider.isPassive()) {
            this._searchableProvider.processKeyEvent(e);
            return;
        }
        if (this.isActivateKey(e)) {
            String searchingText = "";
            if (e.getID() == 400) {
                if ((e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                    return;
                }
                if (e.isAltDown()) {
                    return;
                }
                searchingText = String.valueOf(e.getKeyChar());
            }
            this.showPopup(searchingText);
            if (e.getKeyCode() != 10) {
                e.consume();
            }
        }
    }

    private int getIndex(int count, int index) {
        return this.isReverseOrder() ? count - index - 1 : index;
    }

    public void showPopup(String searchingText) {
        if (this._searchableProvider == null) {
            this.fireSearchableEvent(new SearchableEvent(this, 2999, searchingText));
            this.showPopup(this.createSearchPopup(searchingText));
            this._searchableProvider = new SearchableProvider(){

                public String getSearchingText() {
                    return Searchable.this._popup != null ? Searchable.this._popup.getSearchingText() : "";
                }

                public boolean isPassive() {
                    return true;
                }

                public void processKeyEvent(KeyEvent e) {
                    if (Searchable.this._popup != null) {
                        Searchable.this._popup.processKeyEvent(e);
                    }
                }
            };
        }
    }

    protected SearchPopup createSearchPopup(String searchingText) {
        return new DefaultSearchPopup(searchingText);
    }

    public String getSearchingText() {
        return this._searchableProvider != null ? this._searchableProvider.getSearchingText() : "";
    }

    private void showPopup(SearchPopup searchpopup) {
        JRootPane rootPane = this._component.getRootPane();
        this._layeredPane = rootPane != null ? rootPane.getLayeredPane() : null;
        if (this._layeredPane == null || this.isHeavyweightComponentEnabled()) {
            this._popup = searchpopup;
            Point location = this.updateSizeAndLocation();
            if (location != null) {
                searchpopup.showPopup(location.x, location.y);
                this._popup.setVisible(true);
            } else {
                this._popup = null;
            }
        } else {
            if (this._popup != null && this._layeredPane != null) {
                this._layeredPane.remove(this._popup);
                this._layeredPane.validate();
                this._layeredPane.repaint();
                this._layeredPane = null;
            } else {
                this._popup = !this._component.isShowing() ? null : searchpopup;
            }
            if (this._popup == null || !this._component.isDisplayable()) {
                return;
            }
            if (this._layeredPane == null) {
                System.err.println("Failed to find layeredPane.");
                return;
            }
            this._layeredPane.add((Component)this._popup, JLayeredPane.POPUP_LAYER);
            this.updateSizeAndLocation();
            this._popup.setVisible(true);
            this._popup.validate();
        }
    }

    private Point updateSizeAndLocation() {
        Component component = this.getPopupLocationRelativeTo();
        if (component == null) {
            component = JideSwingUtilities.getScrollPane(this._component);
        }
        if (component == null) {
            component = this._component;
        }
        if (this._popup != null) {
            Point componentLocation;
            Dimension size = this._popup.getPreferredSize();
            switch (this._popupLocation) {
                case 3: {
                    try {
                        componentLocation = component.getLocationOnScreen();
                        componentLocation.y += component.getHeight();
                    }
                    catch (IllegalComponentStateException e) {
                        return null;
                    }
                    if (this.isHeavyweightComponentEnabled()) break;
                    SwingUtilities.convertPointFromScreen(componentLocation, this._layeredPane);
                    if (componentLocation.y + size.height <= this._layeredPane.getHeight()) break;
                    componentLocation.y = this._layeredPane.getHeight() - size.height;
                    break;
                }
                default: {
                    try {
                        componentLocation = component.getLocationOnScreen();
                    }
                    catch (IllegalComponentStateException e) {
                        return null;
                    }
                    if (!this.isHeavyweightComponentEnabled()) {
                        SwingUtilities.convertPointFromScreen(componentLocation, this._layeredPane);
                    }
                    componentLocation.y -= size.height;
                    if (componentLocation.y >= 0) break;
                    componentLocation.y = 0;
                }
            }
            if (!this.isHeavyweightComponentEnabled()) {
                this._popup.setLocation(componentLocation);
                this._popup.setSize(size);
            } else {
                this._popup.packPopup();
            }
            return componentLocation;
        }
        return null;
    }

    protected boolean isFindFirstKey(KeyEvent e) {
        return e.getKeyCode() == 36;
    }

    protected boolean isFindLastKey(KeyEvent e) {
        return e.getKeyCode() == 35;
    }

    protected boolean isFindPreviousKey(KeyEvent e) {
        return e.getKeyCode() == 38;
    }

    protected boolean isFindNextKey(KeyEvent e) {
        return e.getKeyCode() == 40;
    }

    protected boolean isNavigationKey(KeyEvent e) {
        return this.isFindFirstKey(e) || this.isFindLastKey(e) || this.isFindNextKey(e) || this.isFindPreviousKey(e);
    }

    protected boolean isActivateKey(KeyEvent e) {
        char keyChar = e.getKeyChar();
        return e.getID() == 400 && (Character.isLetterOrDigit(keyChar) || keyChar == '*' || keyChar == '?');
    }

    protected boolean isDeactivateKey(KeyEvent e) {
        int keyCode = e.getKeyCode();
        return keyCode == 10 || keyCode == 27 || keyCode == 33 || keyCode == 34 || keyCode == 36 || keyCode == 35 || keyCode == 37 || keyCode == 39 || keyCode == 38 || keyCode == 40;
    }

    protected boolean isSelectAllKey(KeyEvent e) {
        return (e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0 && e.getKeyCode() == 65;
    }

    protected boolean isIncrementalSelectKey(KeyEvent e) {
        return (e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0;
    }

    public Color getMismatchForeground() {
        if (this._mismatchForeground == null) {
            return Color.RED;
        }
        return this._mismatchForeground;
    }

    public void setMismatchForeground(Color mismatchForeground) {
        this._mismatchForeground = mismatchForeground;
    }

    public boolean isCaseSensitive() {
        return this._caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this._caseSensitive = caseSensitive;
    }

    public int getSearchingDelay() {
        return this._searchingDelay;
    }

    public void setSearchingDelay(int searchingDelay) {
        this._searchingDelay = searchingDelay;
    }

    public boolean isRepeats() {
        return this._repeats;
    }

    public void setRepeats(boolean repeats) {
        this._repeats = repeats;
    }

    public Color getForeground() {
        if (this._foreground == null) {
            return UIDefaultsLookup.getColor("ToolTip.foreground");
        }
        return this._foreground;
    }

    public void setForeground(Color foreground) {
        this._foreground = foreground;
    }

    public Color getBackground() {
        if (this._background == null) {
            return UIDefaultsLookup.getColor("ToolTip.background");
        }
        return this._background;
    }

    public void setBackground(Color background) {
        this._background = background;
    }

    public boolean isWildcardEnabled() {
        return this._wildcardEnabled;
    }

    public void setWildcardEnabled(boolean wildcardEnabled) {
        this._wildcardEnabled = wildcardEnabled;
    }

    public String getSearchLabel() {
        return this._searchLabel;
    }

    public void setSearchLabel(String searchLabel) {
        this._searchLabel = searchLabel;
    }

    public void addSearchableListener(SearchableListener l) {
        this.listenerList.add(SearchableListener.class, l);
    }

    public void removeSearchableListener(SearchableListener l) {
        this.listenerList.remove(SearchableListener.class, l);
    }

    public SearchableListener[] getSearchableListeners() {
        return (SearchableListener[])this.listenerList.getListeners(SearchableListener.class);
    }

    protected void fireSearchableEvent(SearchableEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SearchableListener.class) continue;
            ((SearchableListener)listeners[i + 1]).searchableEventFired(e);
        }
    }

    public Component getComponent() {
        return this._component;
    }

    public int getPopupLocation() {
        return this._popupLocation;
    }

    public void setPopupLocation(int popupLocation) {
        this._popupLocation = popupLocation;
    }

    public boolean isReverseOrder() {
        return this._reverseOrder;
    }

    public void setReverseOrder(boolean reverseOrder) {
        this._reverseOrder = reverseOrder;
    }

    protected String getResourceString(String key) {
        return Resource.getResourceBundle(Locale.getDefault()).getString(key);
    }

    public boolean isPopupVisible() {
        return this._popup != null;
    }

    public boolean isHeavyweightComponentEnabled() {
        return this._heavyweightComponentEnabled;
    }

    public void setHeavyweightComponentEnabled(boolean heavyweightComponentEnabled) {
        this._heavyweightComponentEnabled = heavyweightComponentEnabled;
    }

    public Component getPopupLocationRelativeTo() {
        return this._popupLocationRelativeTo;
    }

    public void setPopupLocationRelativeTo(Component popupLocationRelativeTo) {
        this._popupLocationRelativeTo = popupLocationRelativeTo;
    }

    public abstract class SearchPopup
    extends JidePopup {
        protected SearchField _textField;

        public void processKeyEvent(KeyEvent e) {
            this._textField.processKeyEvent(e);
            if (e.isConsumed()) {
                String text = this.getSearchingText();
                if (text.length() == 0) {
                    return;
                }
                if (Searchable.this.isSelectAllKey(e)) {
                    this.selectAll(e, text);
                    return;
                }
                if (Searchable.this.isFindPreviousKey(e)) {
                    int found = Searchable.this.findPrevious(text);
                    this.select(found, e, text);
                } else if (Searchable.this.isFindNextKey(e)) {
                    int found = Searchable.this.findNext(text);
                    this.select(found, e, text);
                } else if (Searchable.this.isFindFirstKey(e)) {
                    int found = Searchable.this.findFirst(text);
                    this.select(found, e, text);
                } else if (Searchable.this.isFindLastKey(e)) {
                    int found = Searchable.this.findLast(text);
                    this.select(found, e, text);
                }
            }
            if (e.getKeyCode() != 10) {
                e.consume();
            }
        }

        private void selectAll(KeyEvent e, String text) {
            int newIndex;
            boolean oldRepeats;
            int index;
            boolean oldReverseOrder = Searchable.this.isReverseOrder();
            if (oldReverseOrder) {
                Searchable.this.setReverseOrder(false);
            }
            if ((index = Searchable.this.findFirst(text)) != -1) {
                Searchable.this.setSelectedIndex(index, false);
                Searchable.this._cursor = index;
            }
            if (oldRepeats = Searchable.this.isRepeats()) {
                Searchable.this.setRepeats(false);
            }
            while (index != -1 && (index = index == (newIndex = Searchable.this.findNext(text)) ? -1 : newIndex) != -1) {
                this.select(index, e, text);
            }
            if (oldRepeats) {
                Searchable.this.setRepeats(oldRepeats);
            }
            if (oldReverseOrder) {
                Searchable.this.setReverseOrder(oldReverseOrder);
            }
        }

        public String getSearchingText() {
            return this._textField != null ? this._textField.getText() : "";
        }

        protected abstract void select(int var1, KeyEvent var2, String var3);
    }

    private class DefaultSearchPopup
    extends SearchPopup {
        private JLabel _label;
        private JLabel _noMatch;

        public DefaultSearchPopup(String text) {
            this.initComponents(text);
        }

        private void initComponents(String text) {
            final Color foreground = Searchable.this.getForeground();
            Color background = Searchable.this.getBackground();
            this._label = new JLabel(Searchable.this._searchLabel);
            this._label.setForeground(foreground);
            this._label.setVerticalAlignment(3);
            this._noMatch = new JLabel();
            this._noMatch.setForeground(Searchable.this.getMismatchForeground());
            this._noMatch.setVerticalAlignment(3);
            this._textField = new SearchField();
            this._textField.setFocusable(false);
            this._textField.setOpaque(false);
            this._textField.setBorder(BorderFactory.createEmptyBorder());
            this._textField.setForeground(foreground);
            this._textField.setCursor(this.getCursor());
            this._textField.getDocument().addDocumentListener(new DocumentListener(){
                private Timer timer = new Timer(200, new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        this.applyText();
                    }
                });

                public void insertUpdate(DocumentEvent e) {
                    this.startTimer();
                }

                public void removeUpdate(DocumentEvent e) {
                    this.startTimer();
                }

                public void changedUpdate(DocumentEvent e) {
                    this.startTimer();
                }

                protected void applyText() {
                    String text = DefaultSearchPopup.this._textField.getText().trim();
                    if (text.length() != 0) {
                        int found = Searchable.this.findFromCursor(text);
                        if (found == -1) {
                            DefaultSearchPopup.this._textField.setForeground(Searchable.this.getMismatchForeground());
                        } else {
                            DefaultSearchPopup.this._textField.setForeground(foreground);
                        }
                        DefaultSearchPopup.this.select(found, null, text);
                    } else {
                        DefaultSearchPopup.this.hidePopup();
                    }
                }

                void startTimer() {
                    DefaultSearchPopup.this.updatePopupBounds();
                    if (Searchable.this.getSearchingDelay() > 0) {
                        this.timer.setDelay(Searchable.this.getSearchingDelay());
                        if (this.timer.isRunning()) {
                            this.timer.restart();
                        } else {
                            this.timer.setRepeats(false);
                            this.timer.start();
                        }
                    } else {
                        this.applyText();
                    }
                }
            });
            this._textField.setText(text);
            this.setBackground(background);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIDefaultsLookup.getColor("controlShadow"), 1), BorderFactory.createEmptyBorder(0, 6, 1, 8)));
            this.setLayout(new BorderLayout(2, 0));
            Dimension size = this._label.getPreferredSize();
            size.height = this._textField.getPreferredSize().height;
            this._label.setPreferredSize(size);
            this.add((Component)this._label, "Before");
            this.add((Component)this._textField, "Center");
            this.add((Component)this._noMatch, "After");
            this.setPopupBorder(BorderFactory.createEmptyBorder());
        }

        protected void select(int index, KeyEvent e, String searchingText) {
            if (index != -1) {
                Searchable.this.setSelectedIndex(index, e != null && Searchable.this.isIncrementalSelectKey(e));
                Searchable.this._cursor = index;
                this._textField.setForeground(this.getForeground());
                this._noMatch.setText("");
            } else {
                this._textField.setForeground(Searchable.this.getMismatchForeground());
                this._noMatch.setText(Searchable.this._noMatchLabel);
            }
            this.updatePopupBounds();
            Searchable.this.firePropertyChangeEvent(searchingText);
            if (index != -1) {
                Object element = Searchable.this.getElementAt(index);
                Searchable.this.fireSearchableEvent(new SearchableEvent(Searchable.this, 3002, searchingText, element, Searchable.this.convertElementToString(element)));
            } else {
                Searchable.this.fireSearchableEvent(new SearchableEvent(Searchable.this, 3003, searchingText));
            }
        }

        private void updatePopupBounds() {
            if (Searchable.this._popup != null) {
                this._textField.invalidate();
                try {
                    if (!Searchable.this.isHeavyweightComponentEnabled()) {
                        Searchable.this._popup.setSize(Searchable.this._popup.getPreferredSize());
                        Searchable.this._popup.validate();
                    } else {
                        Searchable.this._popup.packPopup();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected class SearchField
    extends JTextField {
        SearchField() {
        }

        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.width = this.getFontMetrics(this.getFont()).stringWidth(this.getText()) + 4;
            return size;
        }

        public void processKeyEvent(KeyEvent e) {
            int keyCode = e.getKeyCode();
            if (keyCode == 8 && this.getDocument().getLength() == 0) {
                e.consume();
                return;
            }
            boolean isNavigationKey = Searchable.this.isNavigationKey(e);
            if (Searchable.this.isDeactivateKey(e) && !isNavigationKey) {
                Searchable.this.hidePopup();
                if (keyCode == 27) {
                    e.consume();
                }
                return;
            }
            super.processKeyEvent(e);
            if (keyCode == 8 || isNavigationKey) {
                e.consume();
            }
            if (Searchable.this.isSelectAllKey(e)) {
                e.consume();
            }
        }
    }
}

