/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.StyleRange;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class StyledLabel
extends JLabel {
    private static final String uiClassID = "StyledLabelUI";
    private List _styleRanges;
    private boolean _ignoreColorSettings;
    public static final String PROPERTY_STYLE_RANGE = "styleRange";
    public static final String PROPERTY_IGNORE_COLOR_SETTINGS = "ignoreColorSettings";

    public StyledLabel() {
    }

    public StyledLabel(Icon image) {
        super(image);
    }

    public StyledLabel(Icon image, int horizontalAlignment) {
        super(image, horizontalAlignment);
    }

    public StyledLabel(String text) {
        super(text);
    }

    public StyledLabel(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
    }

    public StyledLabel(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
    }

    public void updateUI() {
        if (UIDefaultsLookup.get(uiClassID) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.setUI(UIManager.getUI(this));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void addStyleRange(StyleRange styleRange) {
        if (styleRange == null) {
            throw new IllegalArgumentException("StyleRange cannot be null.");
        }
        List ranges = this.internalGetStyleRanges();
        for (int i = 0; i < ranges.size(); ++i) {
            StyleRange range = (StyleRange)ranges.get(i);
            if (range.getStart() != styleRange.getStart() || range.getStart() != styleRange.getStart()) continue;
            ranges.remove(i);
        }
        this.internalGetStyleRanges().add(styleRange);
        this.firePropertyChange(PROPERTY_STYLE_RANGE, null, styleRange);
    }

    public void setStyleRange(StyleRange styleRange) {
        this.addStyleRange(styleRange);
    }

    public void setStyleRanges(StyleRange[] styleRanges) {
        this.internalGetStyleRanges().clear();
        this.addStyleRanges(styleRanges);
    }

    public void addStyleRanges(StyleRange[] styleRanges) {
        if (styleRanges != null) {
            for (int i = 0; i < styleRanges.length; ++i) {
                this.internalGetStyleRanges().add(styleRanges[i]);
            }
            this.firePropertyChange(PROPERTY_STYLE_RANGE, null, styleRanges);
        } else {
            this.firePropertyChange(PROPERTY_STYLE_RANGE, null, null);
        }
    }

    public StyleRange[] getStyleRanges() {
        List list = this.internalGetStyleRanges();
        return list.toArray(new StyleRange[list.size()]);
    }

    private List internalGetStyleRanges() {
        if (this._styleRanges == null) {
            this._styleRanges = new Vector();
        }
        return this._styleRanges;
    }

    public void clearStyleRange(StyleRange styleRange) {
        if (this.internalGetStyleRanges().remove(styleRange)) {
            this.firePropertyChange(PROPERTY_STYLE_RANGE, styleRange, null);
        }
    }

    public void clearStyleRanges() {
        this.internalGetStyleRanges().clear();
        this.firePropertyChange(PROPERTY_STYLE_RANGE, null, null);
    }

    public boolean isIgnoreColorSettings() {
        return this._ignoreColorSettings;
    }

    public void setIgnoreColorSettings(boolean ignoreColorSettings) {
        boolean old = this._ignoreColorSettings;
        if (old != ignoreColorSettings) {
            this._ignoreColorSettings = ignoreColorSettings;
            this.firePropertyChange(PROPERTY_IGNORE_COLOR_SETTINGS, old, ignoreColorSettings);
        }
    }
}

