/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.event.SearchableEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class TableSearchable
extends Searchable
implements TableModelListener,
PropertyChangeListener {
    private int _mainIndex = 0;

    public TableSearchable(JTable table) {
        super(table);
        table.getModel().addTableModelListener(this);
        table.addPropertyChangeListener("model", this);
    }

    public void uninstallListeners() {
        super.uninstallListeners();
        if (this._component instanceof JTable) {
            ((JTable)this._component).getModel().removeTableModelListener(this);
        }
        this._component.removePropertyChangeListener("model", this);
    }

    protected void setSelectedIndex(int index, boolean incremental) {
        JTable table = (JTable)this._component;
        if (this.isColumnSelectionAllowed(table)) {
            int majorIndex = index;
            int minorIndex = this.getMainIndex();
            this.addTableSelection(table, majorIndex, minorIndex, incremental);
        } else if (this.isRowSelectionAllowed(table)) {
            int majorIndex = index;
            int minorIndex = this.getMainIndex();
            this.addTableSelection(table, majorIndex, minorIndex, incremental);
        } else {
            int majorIndex = index / table.getColumnModel().getColumnCount();
            int minorIndex = index % table.getColumnModel().getColumnCount();
            this.addTableSelection(table, majorIndex, minorIndex, incremental);
        }
    }

    protected void addTableSelection(JTable table, int rowIndex, int columnIndex, boolean incremental) {
        if (!incremental) {
            table.clearSelection();
        }
        if (rowIndex >= 0 && columnIndex >= 0 && rowIndex < table.getRowCount() && columnIndex < table.getColumnCount() && !table.isCellSelected(rowIndex, columnIndex)) {
            table.changeSelection(rowIndex, columnIndex, true, false);
        }
    }

    protected boolean isColumnSelectionAllowed(JTable table) {
        return this.getMainIndex() != -1 && table.getColumnSelectionAllowed() && !table.getRowSelectionAllowed();
    }

    protected boolean isRowSelectionAllowed(JTable table) {
        return this.getMainIndex() != -1 && !table.getColumnSelectionAllowed() && table.getRowSelectionAllowed();
    }

    protected int getSelectedIndex() {
        JTable table = (JTable)this._component;
        if (this.isColumnSelectionAllowed(table)) {
            return table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        }
        if (this.isRowSelectionAllowed(table)) {
            return table.getSelectionModel().getLeadSelectionIndex();
        }
        return table.getSelectionModel().getLeadSelectionIndex() * table.getColumnCount() + table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
    }

    protected Object getElementAt(int index) {
        TableModel model = ((JTable)this._component).getModel();
        JTable table = (JTable)this._component;
        if (this.isColumnSelectionAllowed(table)) {
            return this.getValueAt(model, this.getMainIndex(), table.convertColumnIndexToModel(index));
        }
        if (this.isRowSelectionAllowed(table)) {
            return this.getValueAt(model, index, table.convertColumnIndexToModel(this.getMainIndex()));
        }
        int columnIndex = index % table.getColumnModel().getColumnCount();
        int rowIndex = index / table.getColumnModel().getColumnCount();
        return this.getValueAt(model, rowIndex, table.convertColumnIndexToModel(columnIndex));
    }

    private Object getValueAt(TableModel model, int rowIndex, int columnIndex) {
        if (rowIndex >= 0 && rowIndex < model.getRowCount() && columnIndex >= 0 && columnIndex < model.getColumnCount()) {
            return model.getValueAt(rowIndex, columnIndex);
        }
        return null;
    }

    protected int getElementCount() {
        TableModel model = ((JTable)this._component).getModel();
        JTable table = (JTable)this._component;
        if (this.isColumnSelectionAllowed(table)) {
            return table.getColumnModel().getColumnCount();
        }
        if (this.isRowSelectionAllowed(table)) {
            return model.getRowCount();
        }
        return table.getColumnModel().getColumnCount() * model.getRowCount();
    }

    protected String convertElementToString(Object item) {
        if (item != null) {
            return item.toString();
        }
        return "";
    }

    public int getMainIndex() {
        return this._mainIndex;
    }

    public void setMainIndex(int mainIndex) {
        int old = this._mainIndex;
        if (old != mainIndex) {
            this._mainIndex = mainIndex;
            this.hidePopup();
        }
    }

    protected boolean isFindNextKey(KeyEvent e) {
        int keyCode = e.getKeyCode();
        JTable table = (JTable)this._component;
        if (this.isColumnSelectionAllowed(table)) {
            return keyCode == 39;
        }
        if (this.isRowSelectionAllowed(table)) {
            return keyCode == 40;
        }
        return keyCode == 40 || keyCode == 39;
    }

    protected boolean isFindPreviousKey(KeyEvent e) {
        int keyCode = e.getKeyCode();
        JTable table = (JTable)this._component;
        if (this.isColumnSelectionAllowed(table)) {
            return keyCode == 37;
        }
        if (this.isRowSelectionAllowed(table)) {
            return keyCode == 38;
        }
        return keyCode == 38 || keyCode == 37;
    }

    public void tableChanged(TableModelEvent e) {
        this.hidePopup();
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("model".equals(evt.getPropertyName())) {
            this.hidePopup();
            if (evt.getOldValue() instanceof TableModel) {
                ((TableModel)evt.getOldValue()).removeTableModelListener(this);
            }
            if (evt.getNewValue() instanceof TableModel) {
                ((TableModel)evt.getNewValue()).addTableModelListener(this);
            }
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    protected boolean isActivateKey(KeyEvent e) {
        boolean editable = this.isSelectedCellEditable();
        return !editable && super.isActivateKey(e);
    }

    protected boolean isSelectedCellEditable() {
        int selectedRow = ((JTable)this._component).getSelectionModel().getLeadSelectionIndex();
        int selectedColumn = ((JTable)this._component).getColumnModel().getSelectionModel().getLeadSelectionIndex();
        return ((JTable)this._component).isCellEditable(selectedRow, selectedColumn);
    }
}

