/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.Searchable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeSearchable
extends Searchable
implements TreeModelListener,
PropertyChangeListener {
    private boolean _recursive = false;
    private transient List<TreePath> _treePathes;

    public TreeSearchable(JTree tree) {
        super(tree);
        if (tree.getModel() != null) {
            tree.getModel().addTreeModelListener(this);
        }
        tree.addPropertyChangeListener("model", this);
    }

    public boolean isRecursive() {
        return this._recursive;
    }

    public void setRecursive(boolean recursive) {
        this._recursive = recursive;
        this.resetTreePathes();
    }

    @Override
    public void uninstallListeners() {
        super.uninstallListeners();
        if (this._component instanceof JTree && ((JTree)this._component).getModel() != null) {
            ((JTree)this._component).getModel().removeTreeModelListener(this);
        }
        this._component.removePropertyChangeListener("model", this);
    }

    @Override
    protected void setSelectedIndex(int index, boolean incremental) {
        if (!this.isRecursive()) {
            if (incremental) {
                ((JTree)this._component).addSelectionInterval(index, index);
            } else {
                ((JTree)this._component).setSelectionRow(index);
            }
            ((JTree)this._component).scrollRowToVisible(index);
        } else {
            Object elementAt = this.getElementAt(index);
            if (elementAt instanceof TreePath) {
                TreePath path = (TreePath)elementAt;
                if (incremental) {
                    ((JTree)this._component).addSelectionPath(path);
                } else {
                    ((JTree)this._component).setSelectionPath(path);
                }
                ((JTree)this._component).scrollPathToVisible(path);
            }
        }
    }

    @Override
    protected int getSelectedIndex() {
        if (!this.isRecursive()) {
            int[] ai = ((JTree)this._component).getSelectionRows();
            return ai != null && ai.length != 0 ? ai[0] : -1;
        }
        TreePath[] treePaths = ((JTree)this._component).getSelectionPaths();
        if (treePaths != null && treePaths.length > 0) {
            return this.getTreePathes().indexOf(treePaths[0]);
        }
        return -1;
    }

    @Override
    protected Object getElementAt(int index) {
        if (index == -1) {
            return null;
        }
        if (!this.isRecursive()) {
            return ((JTree)this._component).getPathForRow(index);
        }
        return this.getTreePathes().get(index);
    }

    @Override
    protected int getElementCount() {
        if (!this.isRecursive()) {
            return ((JTree)this._component).getRowCount();
        }
        return this.getTreePathes().size();
    }

    protected void populateTreePathes() {
        this.populateTreePaths();
    }

    protected void populateTreePaths() {
        this._treePathes = new ArrayList<TreePath>();
        Object root = ((JTree)this._component).getModel().getRoot();
        this.populateTreePaths0(root, new TreePath(root), ((JTree)this._component).getModel());
    }

    private void populateTreePaths0(Object node, TreePath path, TreeModel model) {
        if (((JTree)this._component).isRootVisible() || path.getLastPathComponent() != ((JTree)this._component).getModel().getRoot()) {
            this._treePathes.add(path);
        }
        for (int i = 0; i < model.getChildCount(node); ++i) {
            Object childNode = model.getChild(node, i);
            this.populateTreePaths0(childNode, path.pathByAddingChild(childNode), model);
        }
    }

    protected void resetTreePathes() {
        this._treePathes = null;
    }

    protected List<TreePath> getTreePathes() {
        if (this._treePathes == null) {
            this.populateTreePaths();
        }
        return this._treePathes;
    }

    @Override
    protected String convertElementToString(Object object) {
        if (object instanceof TreePath) {
            Object treeNode = ((TreePath)object).getLastPathComponent();
            return treeNode.toString();
        }
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        this.hidePopup();
        this.resetTreePathes();
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
        this.hidePopup();
        this.resetTreePathes();
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
        this.hidePopup();
        this.resetTreePathes();
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
        this.hidePopup();
        this.resetTreePathes();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("model".equals(evt.getPropertyName())) {
            this.hidePopup();
            if (evt.getOldValue() instanceof TreeModel) {
                ((TreeModel)evt.getOldValue()).removeTreeModelListener(this);
            }
            if (evt.getNewValue() instanceof TreeModel) {
                ((TreeModel)evt.getNewValue()).addTreeModelListener(this);
            }
            this.resetTreePathes();
        }
    }
}

