/*
 * Decompiled with CFR 0.152.
 */
package com.leth.util;

import java.io.IOException;
import java.util.Locale;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;

public class LoggingInterceptorOkHttp3
implements Interceptor {
    public static final Logger NO_LOG = new Logger(){

        @Override
        public void info(String log) {
        }
    };
    private Logger logger;
    private LogLevel logLevel;

    public LoggingInterceptorOkHttp3(Logger logger) {
        this(logger, LogLevel.FULL);
    }

    public LoggingInterceptorOkHttp3(Logger logger, LogLevel logLevel) {
        this.logger = logger;
        this.setLogLevel(logLevel);
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response;
        if (!this.logLevel.log()) {
            return chain.proceed(chain.request());
        }
        Request request = chain.request();
        long t1 = System.nanoTime();
        this.logger.info(String.format(Locale.ENGLISH, "---> HTTP %s %s on %s%n%s", request.method(), request.url(), chain.connection(), LoggingInterceptorOkHttp3.removeLastNewline(request.headers())));
        String requestContent = LoggingInterceptorOkHttp3.bodyToString(request);
        this.logger.info(String.format(Locale.ENGLISH, "%s", requestContent));
        this.logger.info(String.format(Locale.ENGLISH, "---> END HTTP (%d-byte body)", request.body() != null ? request.body().contentLength() : 0L));
        try {
            response = chain.proceed(request);
        }
        catch (IOException e) {
            this.logger.info(String.format(Locale.ENGLISH, "<--> HTTP connection error (%s) %s", e.getClass().getCanonicalName(), e.getMessage()));
            throw e;
        }
        long t2 = System.nanoTime();
        this.logger.info(String.format(Locale.ENGLISH, "<--- HTTP %d %s (%.1fms)%n%s", response.code(), response.request().url(), (double)(t2 - t1) / 1000000.0, LoggingInterceptorOkHttp3.removeLastNewline(response.headers())));
        MediaType contentType = null;
        String responseContent = null;
        if (response.body() != null) {
            contentType = response.body().contentType();
            responseContent = response.body().string();
        }
        this.logger.info(String.format(Locale.ENGLISH, "%s", LoggingInterceptorOkHttp3.bodyToString(responseContent)));
        this.logger.info(String.format(Locale.ENGLISH, "<--- END HTTP (%d-byte body)", response.body() != null ? response.body().contentLength() : 0L));
        if (response.body() != null) {
            ResponseBody wrappedBody = ResponseBody.create((MediaType)contentType, (String)responseContent);
            response = response.newBuilder().body(wrappedBody).build();
        }
        return response;
    }

    private static String removeLastNewline(Object object) {
        return object != null ? object.toString().replaceFirst("\\n$", "") : null;
    }

    private static String bodyToString(Request request) {
        try {
            if (request.body() == null) {
                return "(no body)";
            }
            Request copy = request.newBuilder().build();
            Buffer buffer = new Buffer();
            copy.body().writeTo((BufferedSink)buffer);
            String requestContent = buffer.readUtf8();
            if (requestContent.length() == 0) {
                requestContent = "(empty body)";
            }
            return requestContent;
        }
        catch (Throwable e) {
            return "(body not printable)";
        }
    }

    private static String bodyToString(String responseContent) {
        if (responseContent == null) {
            responseContent = "(no body)";
        } else if (responseContent.length() == 0) {
            responseContent = "(empty body)";
        }
        return responseContent;
    }

    public LoggingInterceptorOkHttp3 setLogLevel(LogLevel logLevel) {
        if (logLevel == null) {
            throw new NullPointerException("Log level may not be null.");
        }
        this.logLevel = logLevel;
        return this;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public static interface Logger {
        public void info(String var1);
    }

    public static enum LogLevel {
        NONE,
        FULL;


        public boolean log() {
            return this != NONE;
        }
    }
}

