/*
 * Decompiled with CFR 0.152.
 */
package com.jupiter.tools.spring.test.activemq.extension;

import com.jupiter.tools.spring.test.activemq.annotation.ExpectedMessage;
import javax.jms.Message;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.test.context.junit.jupiter.SpringExtension;

public class ActiveMqMessageExtension
implements BeforeAllCallback,
AfterEachCallback {
    private JmsTemplate jmsTemplate;

    public void afterEach(ExtensionContext context) throws Exception {
        ExpectedMessage expectedMessage = context.getRequiredTestMethod().getAnnotation(ExpectedMessage.class);
        if (expectedMessage == null) {
            return;
        }
        this.jmsTemplate.setReceiveTimeout((long)expectedMessage.timeout());
        Message message = this.jmsTemplate.receive(expectedMessage.queue());
        if (message == null) {
            throw new Error(String.format("Expected but not received: %s", expectedMessage.message()));
        }
        Assertions.assertEquals((Object)((ActiveMQTextMessage)message).getText(), (Object)expectedMessage.message());
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        this.jmsTemplate = (JmsTemplate)SpringExtension.getApplicationContext((ExtensionContext)context).getBean(JmsTemplate.class);
        if (this.jmsTemplate == null) {
            throw new RuntimeException("Not found the JmsTemplate bean in the current spring context.");
        }
    }
}

