/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.java;

import java.io.IOException;
import java.io.InputStream;
import kong.unirest.ProgressMonitor;

class MonitoringInputStream
extends InputStream {
    private final InputStream in;
    private volatile long totalNumBytesRead = 0L;
    private ProgressMonitor monitor;

    public MonitoringInputStream(InputStream value, ProgressMonitor monitor) {
        this.in = value;
        this.monitor = monitor;
    }

    @Override
    public int read() throws IOException {
        return (int)this.updateProgress(this.in.read());
    }

    @Override
    public int read(byte[] b) throws IOException {
        return (int)this.updateProgress(this.in.read(b));
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return (int)this.updateProgress(this.in.read(b, off, len));
    }

    @Override
    public long skip(long n) throws IOException {
        return this.updateProgress(this.in.skip(n));
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    private long updateProgress(long numBytesRead) {
        if (numBytesRead > 0L) {
            this.totalNumBytesRead += numBytesRead;
            this.monitor.accept("body", null, numBytesRead, this.totalNumBytesRead);
        }
        return numBytesRead;
    }
}

