/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.config.microprofile.cdi;

import com.kumuluz.ee.config.microprofile.ConfigImpl;
import com.kumuluz.ee.config.microprofile.cdi.ConfigPropertyProducer;
import com.kumuluz.ee.config.microprofile.cdi.TypesBeanAttributes;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.DeploymentException;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class CDIExtension
implements Extension {
    public void validateInjectionPoint(@Observes ProcessInjectionPoint<?, ?> pip) {
        ConfigProperty configPropertyAnnotation = (ConfigProperty)pip.getInjectionPoint().getAnnotated().getAnnotation(ConfigProperty.class);
        if (configPropertyAnnotation != null) {
            try {
                if (Class.class.isInstance(pip.getInjectionPoint().getType())) {
                    ConfigPropertyProducer.getGenericProperty(pip.getInjectionPoint());
                }
            }
            catch (Throwable t) {
                Bean bean = pip.getInjectionPoint().getBean();
                Class failingClass = bean == null ? pip.getInjectionPoint().getMember().getDeclaringClass() : pip.getInjectionPoint().getBean().getBeanClass();
                pip.addDefinitionError((Throwable)new DeploymentException("Deploment Failure for ConfigProperty " + configPropertyAnnotation.name() + " in class " + failingClass.getCanonicalName() + " Reason " + t.getMessage(), t));
            }
        }
    }

    public void addDynamicProducers(@Observes AfterBeanDiscovery event, BeanManager bm) {
        Config config = ConfigProvider.getConfig();
        if (config instanceof ConfigImpl) {
            AnnotatedType annotatedType = bm.createAnnotatedType(ConfigPropertyProducer.class);
            BeanAttributes beanAttributes = null;
            AnnotatedMethod annotatedMethod = null;
            for (AnnotatedMethod m : annotatedType.getMethods()) {
                if (!m.getJavaMember().getName().equals("getGenericProperty")) continue;
                beanAttributes = bm.createBeanAttributes((AnnotatedMember)m);
                annotatedMethod = m;
                break;
            }
            if (beanAttributes != null) {
                HashSet<Object> types = new HashSet<Object>();
                types.addAll(((ConfigImpl)config).getConverterTypes());
                types.add(String.class);
                for (final Type type : types) {
                    Bean bean = bm.createBean((BeanAttributes)new TypesBeanAttributes<Object>(beanAttributes){

                        public Set<Type> getTypes() {
                            HashSet<Type> result = new HashSet<Type>();
                            result.add(type);
                            return result;
                        }
                    }, ConfigPropertyProducer.class, bm.getProducerFactory(annotatedMethod, null));
                    event.addBean(bean);
                }
            }
        }
    }
}

