/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.config.microprofile.cdi;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class ConfigInjectionProducer {
    private Config config;

    @PostConstruct
    void init() {
        this.config = ConfigProvider.getConfig();
    }

    @Produces
    @ApplicationScoped
    public Config createConfig() {
        return this.config;
    }

    @Produces
    @ConfigProperty
    public <T> Optional<T> getOptionalProperty(InjectionPoint injectionPoint) {
        ConfigProperty annotation = (ConfigProperty)injectionPoint.getAnnotated().getAnnotation(ConfigProperty.class);
        Type type = injectionPoint.getType();
        if (type instanceof ParameterizedType) {
            Class typeClass = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
            return ConfigProvider.getConfig().getOptionalValue(annotation.name(), typeClass);
        }
        return Optional.empty();
    }
}

