/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.config.microprofile.cdi;

import com.kumuluz.ee.config.microprofile.ConfigImpl;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.DeploymentException;
import javax.enterprise.inject.spi.InjectionPoint;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class ConfigPropertyProducer {
    @Dependent
    @ConfigProperty
    public static Object getGenericProperty(InjectionPoint ip) {
        Object configurationPropertyValue;
        Optional resultOpt;
        ConfigProperty configPropertyAnnotation = (ConfigProperty)ip.getAnnotated().getAnnotation(ConfigProperty.class);
        String configurationPropertyKey = configPropertyAnnotation.name();
        Class configurationPropertyType = (Class)ip.getType();
        ConfigImpl config = (ConfigImpl)ConfigProvider.getConfig();
        if (configurationPropertyKey.isEmpty()) {
            Bean bean = ip.getBean();
            Class<?> beanClass = bean == null ? ip.getMember().getDeclaringClass() : bean.getBeanClass();
            configurationPropertyKey = beanClass.getPackage().getName() + '.' + beanClass.getSimpleName() + '.' + ip.getMember().getName();
        }
        if ((resultOpt = config.getOptionalValue(configurationPropertyKey, configurationPropertyType)).isPresent()) {
            configurationPropertyValue = resultOpt.get();
        } else {
            configurationPropertyValue = config.convert(configPropertyAnnotation.defaultValue(), configurationPropertyType);
            if (configPropertyAnnotation.defaultValue().equals("org.eclipse.microprofile.config.configproperty.unconfigureddvalue") || configurationPropertyValue == null) {
                throw new DeploymentException("Microprofile Config Property " + configPropertyAnnotation.name() + " can not be found.");
            }
        }
        return configurationPropertyValue;
    }
}

