/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.config.microprofile;

import com.kumuluz.ee.config.microprofile.converters.BooleanConverter;
import com.kumuluz.ee.config.microprofile.converters.ClassConverter;
import com.kumuluz.ee.config.microprofile.converters.DoubleConverter;
import com.kumuluz.ee.config.microprofile.converters.DurationConverter;
import com.kumuluz.ee.config.microprofile.converters.FloatConverter;
import com.kumuluz.ee.config.microprofile.converters.ImplicitConverter;
import com.kumuluz.ee.config.microprofile.converters.InstantConverter;
import com.kumuluz.ee.config.microprofile.converters.IntegerConverter;
import com.kumuluz.ee.config.microprofile.converters.LocalDateConverter;
import com.kumuluz.ee.config.microprofile.converters.LocalDateTimeConverter;
import com.kumuluz.ee.config.microprofile.converters.LocalTimeConverter;
import com.kumuluz.ee.config.microprofile.converters.LongConverter;
import com.kumuluz.ee.config.microprofile.converters.OffsetDateTimeConverter;
import com.kumuluz.ee.config.microprofile.converters.OffsetTimeConverter;
import com.kumuluz.ee.config.microprofile.converters.StringConverter;
import com.kumuluz.ee.config.microprofile.converters.URLConverter;
import com.kumuluz.ee.configuration.utils.ConfigurationUtil;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.regex.Pattern;
import javax.annotation.Priority;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;

public class ConfigImpl
implements Config,
Serializable {
    private Map<Type, Converter> converters = new HashMap<Type, Converter>();
    private ConfigurationUtil configurationUtil = ConfigurationUtil.getInstance();
    private static final String ARRAY_SEPARATOR_REGEX = "(?<!\\\\)" + Pattern.quote(",");

    public ConfigImpl() {
        this.registerDefaultConverters();
        this.registerDiscoveredConverters();
    }

    private void registerDefaultConverters() {
        this.converters.put((Type)((Object)Boolean.class), BooleanConverter.INSTANCE);
        this.converters.put((Type)((Object)Integer.class), IntegerConverter.INSTANCE);
        this.converters.put((Type)((Object)Long.class), LongConverter.INSTANCE);
        this.converters.put((Type)((Object)Float.class), FloatConverter.INSTANCE);
        this.converters.put((Type)((Object)Double.class), DoubleConverter.INSTANCE);
        this.converters.put((Type)((Object)Duration.class), DurationConverter.INSTANCE);
        this.converters.put((Type)((Object)LocalTime.class), LocalTimeConverter.INSTANCE);
        this.converters.put((Type)((Object)LocalDate.class), LocalDateConverter.INSTANCE);
        this.converters.put((Type)((Object)LocalDateTime.class), LocalDateTimeConverter.INSTANCE);
        this.converters.put((Type)((Object)OffsetDateTime.class), OffsetDateTimeConverter.INSTANCE);
        this.converters.put((Type)((Object)OffsetTime.class), OffsetTimeConverter.INSTANCE);
        this.converters.put((Type)((Object)Instant.class), InstantConverter.INSTANCE);
        this.converters.put((Type)((Object)Class.class), ClassConverter.INSTANCE);
        this.converters.put((Type)((Object)String.class), StringConverter.INSTANCE);
        this.converters.put((Type)((Object)URL.class), URLConverter.INSTANCE);
    }

    private void registerDiscoveredConverters() {
        ServiceLoader<Converter> serviceLoader = ServiceLoader.load(Converter.class);
        for (Converter converter : serviceLoader) {
            Type[] types;
            for (Type type : types = converter.getClass().getGenericInterfaces()) {
                Type[] args;
                if (!(type instanceof ParameterizedType) || (args = ((ParameterizedType)type).getActualTypeArguments()).length != 1) continue;
                Type cType = args[0];
                Converter old = this.converters.get(cType);
                if (old != null) {
                    if (this.getPriority(converter) <= this.getPriority(old)) continue;
                    this.converters.put(cType, converter);
                    continue;
                }
                this.converters.put(cType, converter);
            }
        }
    }

    private int getPriority(Converter converter) {
        int result = 100;
        Priority annotation = converter.getClass().getAnnotation(Priority.class);
        if (annotation != null) {
            result = annotation.value();
        }
        return result;
    }

    public <T> Optional<T> getOptionalValue(String propertyName, Class<T> asType) {
        String value = this.configurationUtil.get(propertyName).orElse(null);
        return Optional.ofNullable(this.convert(value, asType));
    }

    public <T> T getValue(String propertyName, Class<T> propertyType) {
        Optional<T> valueOpt = this.getOptionalValue(propertyName, propertyType);
        if (!valueOpt.isPresent()) {
            throw new NoSuchElementException("No configured value found for config key " + propertyName);
        }
        return valueOpt.get();
    }

    public <T> T convert(String value, Class<T> asType) {
        if (value == null) {
            return null;
        }
        if (asType.isArray()) {
            Class<?> arrayType = asType.getComponentType();
            List<?> a = this.convertList(value, arrayType);
            Object arr = Array.newInstance(arrayType, a.size());
            for (int i = 0; i < a.size(); ++i) {
                Array.set(arr, i, a.get(i));
            }
            return (T)arr;
        }
        Converter<T> converter = this.getConverter(asType);
        return (T)converter.convert(value);
    }

    public <T> List<T> convertList(String value, Class<T> listType) {
        String[] tokens = value.split(ARRAY_SEPARATOR_REGEX);
        Converter<T> converter = this.getConverter(listType);
        ArrayList<Object> convertedList = new ArrayList<Object>(tokens.length);
        for (String token : tokens) {
            token = token.replace("\\,", ",");
            convertedList.add(converter.convert(token));
        }
        return convertedList;
    }

    private <T> Converter<T> getConverter(Class asType) {
        if (asType.equals(Boolean.TYPE)) {
            asType = Boolean.class;
        } else if (asType.equals(Double.TYPE)) {
            asType = Double.class;
        } else if (asType.equals(Float.TYPE)) {
            asType = Float.class;
        } else if (asType.equals(Integer.TYPE)) {
            asType = Integer.class;
        } else if (asType.equals(Long.TYPE)) {
            asType = Long.class;
        }
        Converter converter = this.converters.get(asType);
        if (converter == null) {
            converter = ImplicitConverter.getImplicitConverter(asType);
        }
        if (converter == null) {
            throw new IllegalArgumentException("No Converter registered for class " + asType);
        }
        return converter;
    }

    public Iterable<String> getPropertyNames() {
        return null;
    }

    public Iterable<ConfigSource> getConfigSources() {
        return null;
    }
}

