/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.config.microprofile;

import com.kumuluz.ee.configuration.ConfigurationSource;
import com.kumuluz.ee.configuration.utils.ConfigurationDispatcher;
import java.util.List;
import java.util.Optional;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class ConfigurationSourceAdapter
implements ConfigurationSource {
    private ConfigSource configSource;

    public ConfigurationSourceAdapter(ConfigSource configSource) {
        this.configSource = configSource;
    }

    public void init(ConfigurationDispatcher configurationDispatcher) {
    }

    public Optional<String> get(String key) {
        return Optional.ofNullable(this.configSource.getValue(key));
    }

    public Optional<Boolean> getBoolean(String key) {
        Optional<String> value = this.get(key);
        return value.map(Boolean::valueOf);
    }

    public Optional<Integer> getInteger(String key) {
        Optional<String> value = this.get(key);
        if (value.isPresent()) {
            try {
                return Optional.of(Integer.valueOf(value.get()));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public Optional<Long> getLong(String key) {
        Optional<String> value = this.get(key);
        if (value.isPresent()) {
            try {
                return Optional.of(Long.valueOf(value.get()));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public Optional<Double> getDouble(String key) {
        Optional<String> value = this.get(key);
        if (value.isPresent()) {
            try {
                return Optional.of(Double.valueOf(value.get()));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public Optional<Float> getFloat(String key) {
        Optional<String> value = this.get(key);
        if (value.isPresent()) {
            try {
                return Optional.of(Float.valueOf(value.get()));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public Optional<Integer> getListSize(String key) {
        return Optional.empty();
    }

    public Optional<List<String>> getMapKeys(String key) {
        return Optional.empty();
    }

    public void watch(String key) {
    }

    public void set(String key, String value) {
    }

    public void set(String key, Boolean value) {
    }

    public void set(String key, Integer value) {
    }

    public void set(String key, Double value) {
    }

    public void set(String key, Float value) {
    }

    public Integer getOrdinal() {
        return this.configSource.getOrdinal();
    }
}

