/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.config.microprofile;

import com.kumuluz.ee.common.ConfigExtension;
import com.kumuluz.ee.common.config.EeConfig;
import com.kumuluz.ee.common.dependencies.EeExtensionDef;
import com.kumuluz.ee.common.wrapper.KumuluzServerWrapper;
import com.kumuluz.ee.config.microprofile.ConfigurationSourceAdapter;
import com.kumuluz.ee.configuration.ConfigurationSource;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;

@EeExtensionDef(name="MicroProfile", group="config")
public class MicroprofileConfigExtension
implements ConfigExtension {
    private static final Logger log = Logger.getLogger(MicroprofileConfigExtension.class.getName());
    private List<ConfigurationSource> configurationSources;

    public void init(KumuluzServerWrapper kumuluzServerWrapper, EeConfig eeConfig) {
        log.info("Initialising MicroProfile configuration sources.");
        this.configurationSources = new LinkedList<ConfigurationSource>();
        ServiceLoader<ConfigSource> configSourceSL = ServiceLoader.load(ConfigSource.class);
        for (ConfigSource configSource : configSourceSL) {
            this.configurationSources.add(new ConfigurationSourceAdapter(configSource));
        }
        ServiceLoader<ConfigSourceProvider> configSourceProviderSL = ServiceLoader.load(ConfigSourceProvider.class);
        for (ConfigSourceProvider configSourceProvider : configSourceProviderSL) {
            for (ConfigSource configSource : configSourceProvider.getConfigSources(MicroprofileConfigExtension.class.getClassLoader())) {
                this.configurationSources.add(new ConfigurationSourceAdapter(configSource));
            }
        }
    }

    public List<ConfigurationSource> getConfigurationSources() {
        return this.configurationSources;
    }

    public ConfigurationSource getConfigurationSource() {
        return null;
    }

    public void load() {
    }
}

