/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.config.microprofile.cdi;

import com.kumuluz.ee.config.microprofile.ConfigImpl;
import com.kumuluz.ee.config.microprofile.cdi.ConfigPropertyProducer;
import com.kumuluz.ee.config.microprofile.cdi.TypesBeanAttributes;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.DeploymentException;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class CDIExtension
implements Extension {
    private static final Set<Type> IGNORED_TYPES = new HashSet<Type>();
    private Set<InjectionPoint> injectionPoints = new HashSet<InjectionPoint>();

    public void collectConfigProducer(@Observes ProcessInjectionPoint<?, ?> pip) {
        ConfigProperty configProperty = (ConfigProperty)pip.getInjectionPoint().getAnnotated().getAnnotation(ConfigProperty.class);
        if (configProperty != null) {
            this.injectionPoints.add(pip.getInjectionPoint());
        }
    }

    public void validateInjectionPoint(@Observes ProcessInjectionPoint<?, ?> pip) {
        InjectionPoint ip = pip.getInjectionPoint();
        ConfigProperty configPropertyAnnotation = (ConfigProperty)ip.getAnnotated().getAnnotation(ConfigProperty.class);
        if (configPropertyAnnotation != null) {
            try {
                if (Class.class.isInstance(ip.getType())) {
                    ConfigPropertyProducer.getGenericProperty(ip);
                }
            }
            catch (Throwable t) {
                Bean bean = ip.getBean();
                Class failingClass = bean == null ? ip.getMember().getDeclaringClass() : ip.getBean().getBeanClass();
                pip.addDefinitionError((Throwable)new DeploymentException("Deploment Failure for ConfigProperty " + configPropertyAnnotation.name() + " in class " + failingClass.getCanonicalName() + " Reason " + t.getMessage(), t));
            }
        }
    }

    public void addDynamicProducers(@Observes AfterBeanDiscovery event, BeanManager bm) {
        Config config = ConfigProvider.getConfig();
        if (config instanceof ConfigImpl) {
            AnnotatedType annotatedType = bm.createAnnotatedType(ConfigPropertyProducer.class);
            BeanAttributes beanAttributes = null;
            AnnotatedMethod annotatedMethod = null;
            for (AnnotatedMethod m : annotatedType.getMethods()) {
                if (!m.getJavaMember().getName().equals("getGenericProperty")) continue;
                beanAttributes = bm.createBeanAttributes((AnnotatedMember)m);
                annotatedMethod = m;
                break;
            }
            if (beanAttributes != null) {
                HashSet<Type> types = new HashSet<Type>();
                for (InjectionPoint ip : this.injectionPoints) {
                    Type t = ip.getType();
                    if (t instanceof ParameterizedType) {
                        t = ((ParameterizedType)t).getActualTypeArguments()[0];
                    }
                    if (IGNORED_TYPES.contains(t)) continue;
                    types.add(t);
                }
                for (final Type converterType : types) {
                    Bean bean = bm.createBean((BeanAttributes)new TypesBeanAttributes<Object>(beanAttributes){

                        public Set<Type> getTypes() {
                            HashSet<Type> result = new HashSet<Type>();
                            result.add(converterType);
                            return result;
                        }
                    }, ConfigPropertyProducer.class, bm.getProducerFactory(annotatedMethod, null));
                    event.addBean(bean);
                }
            }
        }
    }

    static {
        IGNORED_TYPES.add((Type)((Object)Optional.class));
        IGNORED_TYPES.add((Type)((Object)List.class));
        IGNORED_TYPES.add((Type)((Object)Set.class));
        IGNORED_TYPES.add(Boolean.TYPE);
        IGNORED_TYPES.add(Integer.TYPE);
        IGNORED_TYPES.add(Long.TYPE);
        IGNORED_TYPES.add(Float.TYPE);
        IGNORED_TYPES.add(Double.TYPE);
    }
}

