/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.config.microprofile.cdi;

import com.kumuluz.ee.config.microprofile.ConfigImpl;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class ConfigInjectionProducer {
    private Config config;

    private static <T> Class<T> getClassFromParameterizedType(ParameterizedType type) {
        return (Class)type.getActualTypeArguments()[0];
    }

    @PostConstruct
    void init() {
        this.config = ConfigProvider.getConfig();
    }

    @Produces
    @ApplicationScoped
    public Config createConfig() {
        return this.config;
    }

    @Produces
    @ConfigProperty
    public <T> Optional<T> getOptionalProperty(InjectionPoint injectionPoint) {
        ConfigProperty annotation = (ConfigProperty)injectionPoint.getAnnotated().getAnnotation(ConfigProperty.class);
        Type type = injectionPoint.getType();
        if (type instanceof ParameterizedType) {
            Class<T> typeClass = ConfigInjectionProducer.getClassFromParameterizedType((ParameterizedType)type);
            return ConfigProvider.getConfig().getOptionalValue(annotation.name(), typeClass);
        }
        return Optional.empty();
    }

    @Produces
    @ConfigProperty
    public <T> List<T> getListProperty(InjectionPoint injectionPoint) {
        ConfigProperty annotation = (ConfigProperty)injectionPoint.getAnnotated().getAnnotation(ConfigProperty.class);
        Type type = injectionPoint.getType();
        if (type instanceof ParameterizedType) {
            Class<T> typeClass = ConfigInjectionProducer.getClassFromParameterizedType((ParameterizedType)type);
            Config config = ConfigProvider.getConfig();
            String value = (String)config.getValue(annotation.name(), String.class);
            if (config instanceof ConfigImpl) {
                return ((ConfigImpl)config).convertList(value, typeClass);
            }
        }
        return null;
    }

    @Produces
    @ConfigProperty
    public <T> Set<T> getSetProperty(InjectionPoint injectionPoint) {
        List<T> values = this.getListProperty(injectionPoint);
        return new HashSet<T>(values);
    }
}

