/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.config.microprofile.cdi;

import com.kumuluz.ee.config.microprofile.ConfigImpl;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.DeploymentException;
import javax.enterprise.inject.spi.InjectionPoint;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class ConfigPropertyProducer {
    @Dependent
    @ConfigProperty
    public static Object getGenericProperty(InjectionPoint ip) {
        Object configurationPropertyValue;
        Class configurationPropertyType;
        ConfigImpl config;
        Optional resultOpt;
        AnnotatedMember member;
        ConfigProperty configPropertyAnnotation = (ConfigProperty)ip.getAnnotated().getAnnotation(ConfigProperty.class);
        String configurationPropertyKey = configPropertyAnnotation.name();
        if (configurationPropertyKey.isEmpty() && ip.getAnnotated() instanceof AnnotatedMember && (member = (AnnotatedMember)ip.getAnnotated()).getDeclaringType() != null) {
            configurationPropertyKey = member.getDeclaringType().getJavaClass().getCanonicalName() + "." + member.getJavaMember().getName();
        }
        if ((resultOpt = (config = (ConfigImpl)ConfigProvider.getConfig()).getOptionalValue(configurationPropertyKey, configurationPropertyType = (Class)ip.getType())).isPresent()) {
            configurationPropertyValue = resultOpt.get();
        } else {
            configurationPropertyValue = config.convert(configPropertyAnnotation.defaultValue(), configurationPropertyType);
            if (configPropertyAnnotation.defaultValue().equals("org.eclipse.microprofile.config.configproperty.unconfigureddvalue") || configurationPropertyValue == null) {
                throw new DeploymentException("Microprofile Config Property " + configPropertyAnnotation.name() + " can not be found.");
            }
        }
        return configurationPropertyValue;
    }
}

