/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.config.microprofile.converters;

import com.kumuluz.ee.config.microprofile.converters.ImplicitConverter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ImplicitMethodConverter<T>
extends ImplicitConverter<T> {
    private Method method = null;

    private Method getConverterMethod(Class<T> tClass, String methodName, Class paramType) throws NoSuchMethodException {
        Method method = tClass.getMethod(methodName, paramType);
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        if (Modifier.isStatic(method.getModifiers())) {
            return method;
        }
        throw new NoSuchMethodException();
    }

    public ImplicitMethodConverter(Class<T> tClass) throws NoSuchMethodException {
        try {
            this.method = this.getConverterMethod(tClass, "valueOf", String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (this.method == null) {
            try {
                this.method = this.getConverterMethod(tClass, "parse", CharSequence.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (this.method == null) {
            throw new NoSuchMethodException("Could not find appropriate converter method");
        }
    }

    public T convert(String value) {
        try {
            return (T)this.method.invoke(null, value);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

