/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.fault.tolerance.smallrye;

import com.kumuluz.ee.common.Extension;
import com.kumuluz.ee.common.config.EeConfig;
import com.kumuluz.ee.common.dependencies.EeComponentDependencies;
import com.kumuluz.ee.common.dependencies.EeComponentDependency;
import com.kumuluz.ee.common.dependencies.EeComponentType;
import com.kumuluz.ee.common.dependencies.EeExtensionDef;
import com.kumuluz.ee.common.runtime.EeRuntime;
import com.kumuluz.ee.common.wrapper.KumuluzServerWrapper;
import com.kumuluz.ee.configuration.utils.ConfigurationUtil;
import java.util.logging.Logger;

@EeExtensionDef(name="SmallRye", group="fault.tolerance")
@EeComponentDependencies(value={@EeComponentDependency(value=EeComponentType.CDI)})
public class SmallRyeFtExtension
implements Extension {
    private static final Logger LOG = Logger.getLogger(SmallRyeFtExtension.class.getName());
    private static boolean metricsEnabled = true;

    public void init(KumuluzServerWrapper kumuluzServerWrapper, EeConfig eeConfig) {
        if (!SmallRyeFtExtension.isExtensionPresent("config", "MicroProfile")) {
            throw new IllegalStateException("KumuluzEE Config MP extension is required for SmallRye Fault Tolerance extension to function properly. Please make sure it is added to dependencies.");
        }
        if (!SmallRyeFtExtension.isExtensionPresent("metrics", "MetricsCommons") && ConfigurationUtil.getInstance().getBoolean("MP_Fault_Tolerance_Metrics_Enabled").orElse(true).booleanValue()) {
            LOG.info("KumuluzEE Metrics extension not found. Disabling metrics collection in KumuluzEE Fault Tolerance.");
            metricsEnabled = false;
        }
    }

    public void load() {
    }

    public boolean isEnabled() {
        return true;
    }

    static boolean isExtensionPresent(String group, String implementationName) {
        return EeRuntime.getInstance().getEeExtensions().stream().anyMatch(ext -> ext.getGroup().equals(group) && ext.getImplementationName().equals(implementationName));
    }

    public static boolean isMetricsEnabled() {
        return metricsEnabled;
    }
}

