/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.fault.tolerance.smallrye.config;

import com.kumuluz.ee.common.utils.StringUtils;
import com.kumuluz.ee.fault.tolerance.smallrye.config.FaultToleranceConfigMapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AnnotationOverrideRule {
    private static final Set<String> VALID_ANNOTATIONS = new HashSet<String>(FaultToleranceConfigMapper.FT_ANNOTATION_NAME_TO_HYPHEN_CASE.values());
    private String klass;
    private String method;
    private String annotation;
    private Map<String, String> parameters;

    public AnnotationOverrideRule(String klass, String method, String annotation) {
        this.klass = klass;
        this.method = method;
        this.annotation = annotation;
        this.parameters = new HashMap<String, String>();
    }

    public List<String> validationErrors() {
        LinkedList<String> errors = new LinkedList<String>();
        if (StringUtils.isNullOrEmpty((String)this.klass)) {
            errors.add("The 'class' key must be present and non-empty");
        }
        if (!VALID_ANNOTATIONS.contains(this.annotation)) {
            errors.add("Annotation " + this.annotation + " is not a valid Fault Tolerance annotation");
        }
        return errors;
    }

    public void addParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    public String getMethod() {
        return this.method;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public String getParameter(String parameterName) {
        return this.parameters.get(parameterName);
    }

    public String toString() {
        return "[Class: " + this.klass + ", Method: " + this.method + ", Annotation: " + this.annotation + "]";
    }
}

