/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.fault.tolerance.smallrye.config;

import com.kumuluz.ee.configuration.utils.ConfigurationUtil;
import com.kumuluz.ee.fault.tolerance.smallrye.config.AnnotationOverrideRule;
import com.kumuluz.ee.fault.tolerance.smallrye.config.FaultToleranceConfigMapper;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;

public class AnnotationOverrides {
    private static final Logger LOG = Logger.getLogger(AnnotationOverrides.class.getName());
    private ConfigurationUtil configUtil = ConfigurationUtil.getInstance();
    private Map<String, Map<String, String>> globalAnnotationOverrides;
    private Map<String, List<AnnotationOverrideRule>> annotationRules;

    public AnnotationOverrides() {
        this.initGlobalAnnotationOverrides();
        this.initAnnotationRules();
    }

    private void initGlobalAnnotationOverrides() {
        this.globalAnnotationOverrides = new HashMap<String, Map<String, String>>();
        for (String annotationName : FaultToleranceConfigMapper.FT_ANNOTATION_NAME_TO_HYPHEN_CASE.values()) {
            this.globalAnnotationOverrides.put(annotationName, new HashMap());
            this.configUtil.getMapKeys("kumuluzee.fault-tolerance." + annotationName).ifPresent(l -> l.forEach(paramName -> this.configUtil.get("kumuluzee.fault-tolerance." + annotationName + "." + paramName).ifPresent(paramValue -> this.globalAnnotationOverrides.get(annotationName).put((String)paramName, (String)paramValue))));
        }
    }

    private void initAnnotationRules() {
        this.annotationRules = new HashMap<String, List<AnnotationOverrideRule>>();
        int rulesListLen = this.configUtil.getListSize("kumuluzee.fault-tolerance.annotation-overrides").orElse(-1);
        if (rulesListLen <= 0) {
            return;
        }
        for (int i = 0; i < rulesListLen; ++i) {
            String annotation;
            String method;
            String prefix = "kumuluzee.fault-tolerance.annotation-overrides[" + i + "].";
            String klass = this.configUtil.get(prefix + "class").orElse(null);
            AnnotationOverrideRule rule = new AnnotationOverrideRule(klass, method = (String)this.configUtil.get(prefix + "method").orElse(null), annotation = (String)this.configUtil.get(prefix + "annotation").orElse(null));
            List<String> validationErrors = rule.validationErrors();
            if (validationErrors.size() > 0) {
                LOG.warning("Rule " + rule.toString() + " is invalid. Reason: " + String.join((CharSequence)"; ", validationErrors));
                continue;
            }
            this.configUtil.getMapKeys(prefix + "parameters").ifPresent(keys -> keys.forEach(key -> this.configUtil.get(prefix + "parameters." + key).ifPresent(value -> rule.addParameter((String)key, (String)value))));
            if (!this.annotationRules.containsKey(klass)) {
                this.annotationRules.put(klass, new LinkedList());
            }
            this.annotationRules.get(klass).add(rule);
        }
    }

    public Optional<String> getGlobalParameter(String annotation, String parameterName) {
        if (!this.globalAnnotationOverrides.containsKey(annotation)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.globalAnnotationOverrides.get(annotation).get(parameterName));
    }

    public Optional<String> getAnnotationOverrideParameter(String klass, String method, String annotation, String parameterName) {
        if (!this.annotationRules.containsKey(klass)) {
            return Optional.empty();
        }
        for (AnnotationOverrideRule rule : this.annotationRules.get(klass)) {
            if (!rule.getAnnotation().equals(annotation) || (method != null || rule.getMethod() != null) && (method == null || !method.equals(rule.getMethod()))) continue;
            return Optional.ofNullable(rule.getParameter(parameterName));
        }
        return Optional.empty();
    }
}

