/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.fault.tolerance.smallrye.config;

import com.kumuluz.ee.common.utils.StringUtils;
import com.kumuluz.ee.configuration.ConfigurationSource;
import com.kumuluz.ee.configuration.utils.ConfigurationDispatcher;
import com.kumuluz.ee.configuration.utils.ConfigurationUtil;
import com.kumuluz.ee.fault.tolerance.smallrye.config.AnnotationOverrides;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;

public class FaultToleranceConfigMapper
implements ConfigurationSource {
    private ConfigurationUtil configurationUtil;
    private AnnotationOverrides annotationOverrides;
    private static final String MP_NON_FALLBACK_ENABLED_KEY = "MP_Fault_Tolerance_NonFallback_Enabled";
    private static final String KUMULUZ_NON_FALLBACK_ENABLED_KEY = "kumuluzee.fault-tolerance.non-fallback-enabled";
    static final String MP_METRICS_ENABLED_KEY = "MP_Fault_Tolerance_Metrics_Enabled";
    private static final String KUMULUZ_METRICS_ENABLED_KEY = "kumuluzee.fault-tolerance.metrics-enabled";
    private static final Class[] FAULT_TOLERANCE_ANNOTATIONS = new Class[]{Asynchronous.class, Timeout.class, Retry.class, Fallback.class, CircuitBreaker.class, Bulkhead.class};
    static final Map<String, String> FT_ANNOTATION_NAME_TO_HYPHEN_CASE = new HashMap<String, String>();
    private static final Pattern KEY_TRANSLATION_PATTERN;

    public void init(ConfigurationDispatcher configurationDispatcher) {
        this.configurationUtil = ConfigurationUtil.getInstance();
        this.annotationOverrides = new AnnotationOverrides();
    }

    public Optional<String> get(String key) {
        if (MP_NON_FALLBACK_ENABLED_KEY.equals(key)) {
            return this.configurationUtil.get(KUMULUZ_NON_FALLBACK_ENABLED_KEY);
        }
        if (MP_METRICS_ENABLED_KEY.equals(key)) {
            return this.configurationUtil.get(KUMULUZ_METRICS_ENABLED_KEY);
        }
        Matcher matcher = KEY_TRANSLATION_PATTERN.matcher(key);
        if (matcher.find()) {
            String method;
            String klass = matcher.group(1);
            if (klass != null) {
                klass = klass.substring(0, klass.length() - 1);
            }
            if ((method = matcher.group(2)) != null) {
                method = method.substring(0, method.length() - 1);
            }
            String annotation = matcher.group(3);
            annotation = FT_ANNOTATION_NAME_TO_HYPHEN_CASE.get(annotation);
            String parameterName = matcher.group(4);
            if (parameterName != null) {
                parameterName = StringUtils.camelCaseToHyphenCase((String)parameterName);
            }
            if (klass == null) {
                return this.annotationOverrides.getGlobalParameter(annotation, parameterName);
            }
            return this.annotationOverrides.getAnnotationOverrideParameter(klass, method, annotation, parameterName);
        }
        return Optional.empty();
    }

    public Integer getOrdinal() {
        return 10;
    }

    public Optional<Boolean> getBoolean(String key) {
        Optional<String> value = this.get(key);
        return value.map(Boolean::valueOf);
    }

    public Optional<Integer> getInteger(String key) {
        Optional<String> value = this.get(key);
        if (value.isPresent()) {
            try {
                return Optional.of(Integer.valueOf(value.get()));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public Optional<Long> getLong(String key) {
        Optional<String> value = this.get(key);
        if (value.isPresent()) {
            try {
                return Optional.of(Long.valueOf(value.get()));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public Optional<Double> getDouble(String key) {
        Optional<String> value = this.get(key);
        if (value.isPresent()) {
            try {
                return Optional.of(Double.valueOf(value.get()));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public Optional<Float> getFloat(String key) {
        Optional<String> value = this.get(key);
        if (value.isPresent()) {
            try {
                return Optional.of(Float.valueOf(value.get()));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public Optional<Integer> getListSize(String s) {
        return Optional.empty();
    }

    public Optional<List<String>> getMapKeys(String s) {
        return Optional.empty();
    }

    public void watch(String s) {
    }

    public void set(String s, String s1) {
    }

    public void set(String s, Boolean aBoolean) {
    }

    public void set(String s, Integer integer) {
    }

    public void set(String s, Double aDouble) {
    }

    public void set(String s, Float aFloat) {
    }

    static {
        Arrays.stream(FAULT_TOLERANCE_ANNOTATIONS).map(Class::getSimpleName).forEach(an -> FT_ANNOTATION_NAME_TO_HYPHEN_CASE.put((String)an, StringUtils.camelCaseToHyphenCase((String)an)));
        KEY_TRANSLATION_PATTERN = Pattern.compile("^([^/]+/)?([^/]+/)?(" + Arrays.stream(FAULT_TOLERANCE_ANNOTATIONS).map(Class::getSimpleName).collect(Collectors.joining("|")) + ")/([^/]+)$");
    }
}

