/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.jpa.common;

import com.kumuluz.ee.jpa.common.PersistenceSettings;
import com.kumuluz.ee.jpa.common.PersistenceWrapper;
import com.kumuluz.ee.jpa.common.TransactionType;
import com.kumuluz.ee.jpa.common.utils.PersistenceUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

public class PersistenceUnitHolder {
    private PersistenceSettings providerProperties;
    private String defaultUnitName;
    private Map<String, PersistenceWrapper> factories = new HashMap<String, PersistenceWrapper>();
    private static final PersistenceUnitHolder instance = new PersistenceUnitHolder();

    private PersistenceUnitHolder() {
        this.defaultUnitName = PersistenceUtils.getDefaultUnitName().orElse("");
    }

    public static PersistenceUnitHolder getInstance() {
        return instance;
    }

    public synchronized PersistenceWrapper getEntityManagerFactory(String unitName) {
        PersistenceWrapper wrapper = this.factories.get(unitName);
        if (wrapper == null) {
            Properties properties = new Properties();
            if (this.providerProperties != null && this.providerProperties.getPersistenceUnitProperties() != null) {
                properties.putAll(this.providerProperties.getPersistenceUnitProperties());
            }
            EntityManagerFactory factory = Persistence.createEntityManagerFactory((String)unitName, (Map)properties);
            TransactionType transactionType = PersistenceUtils.getEntityManagerFactoryTransactionType(factory);
            wrapper = new PersistenceWrapper(factory, transactionType);
            this.factories.put(unitName, wrapper);
        }
        return wrapper;
    }

    public String getDefaultUnitName() {
        return this.defaultUnitName;
    }

    public void setProviderProperties(PersistenceSettings providerProperties) {
        this.providerProperties = providerProperties;
    }
}

