/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.jpa.common.injection;

import com.kumuluz.ee.configuration.utils.ConfigurationUtil;
import com.kumuluz.ee.jpa.common.PersistenceUnitHolder;
import com.kumuluz.ee.jpa.common.PersistenceWrapper;
import com.kumuluz.ee.jpa.common.exceptions.NoDefaultPersistenceUnit;
import com.kumuluz.ee.jpa.common.injection.PersistenceContextResourceFactory;
import com.kumuluz.ee.jpa.common.injection.PersistenceUnitResourceFactory;
import java.util.Optional;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import org.jboss.weld.injection.spi.JpaInjectionServices;
import org.jboss.weld.injection.spi.ResourceReferenceFactory;

@Priority(value=1)
public class JpaService
implements JpaInjectionServices {
    private static final Logger LOG = Logger.getLogger(JpaService.class.getSimpleName());

    public ResourceReferenceFactory<EntityManager> registerPersistenceContextInjectionPoint(InjectionPoint injectionPoint) {
        PersistenceUnitHolder holder = PersistenceUnitHolder.getInstance();
        PersistenceContext pc = (PersistenceContext)injectionPoint.getAnnotated().getAnnotation(PersistenceContext.class);
        String unitName = pc.unitName();
        if (unitName.isEmpty() && (unitName = holder.getDefaultUnitName()).isEmpty()) {
            throw new NoDefaultPersistenceUnit();
        }
        boolean continueOnError = false;
        ConfigurationUtil cfg = ConfigurationUtil.getInstance();
        Optional puSizeOpt = cfg.getListSize("kumuluzee.persistence-units");
        if (puSizeOpt.isPresent()) {
            for (int i = 0; i < (Integer)puSizeOpt.get(); ++i) {
                Optional puName = cfg.get("kumuluzee.persistence-units[" + i + "].name");
                if (!puName.isPresent() || !((String)puName.get()).equals(unitName)) continue;
                Optional continueOnErrorCfg = cfg.getBoolean("kumuluzee.persistence-units[" + i + "].continue-on-error");
                if (!continueOnErrorCfg.isPresent() || continueOnErrorCfg.get() == null) break;
                continueOnError = (Boolean)continueOnErrorCfg.get();
                break;
            }
        }
        try {
            PersistenceWrapper wrapper = holder.getEntityManagerFactory(unitName);
            return new PersistenceContextResourceFactory(unitName, wrapper.getEntityManagerFactory(), wrapper.getTransactionType(), pc.synchronization());
        }
        catch (Exception e) {
            if (!continueOnError) {
                LOG.severe("EntityManager for pu " + unitName + " failed to initialize. KumuluzEE initialization failed.");
                throw e;
            }
            LOG.warning("EntityManager for pu " + unitName + " failed to initialize. KumuluzEE will continue the startup regardless due to config override.");
            return null;
        }
    }

    public ResourceReferenceFactory<EntityManagerFactory> registerPersistenceUnitInjectionPoint(InjectionPoint injectionPoint) {
        PersistenceUnitHolder holder = PersistenceUnitHolder.getInstance();
        PersistenceUnit pu = (PersistenceUnit)injectionPoint.getAnnotated().getAnnotation(PersistenceUnit.class);
        String unitName = pu.unitName();
        if (unitName.isEmpty() && (unitName = holder.getDefaultUnitName()).isEmpty()) {
            throw new NoDefaultPersistenceUnit();
        }
        PersistenceWrapper wrapper = holder.getEntityManagerFactory(unitName);
        return new PersistenceUnitResourceFactory(wrapper.getEntityManagerFactory());
    }

    public void cleanup() {
    }
}

