/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.jpa.common.jta;

import com.kumuluz.ee.jpa.common.jta.NonTxEntityManagerHolder;
import com.kumuluz.ee.jpa.common.jta.NonTxQueryWrapper;
import com.kumuluz.ee.jpa.common.jta.NonTxStoredProcedureQueryWrapper;
import com.kumuluz.ee.jpa.common.jta.NonTxTypedQueryWrapper;
import com.kumuluz.ee.jpa.common.jta.SyncEntityManagerWrapper;
import com.kumuluz.ee.jpa.common.jta.TxSynchronization;
import com.kumuluz.ee.jta.common.utils.TxUtils;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.StoredProcedureQuery;
import javax.persistence.SynchronizationType;
import javax.persistence.TransactionRequiredException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.metamodel.Metamodel;
import javax.transaction.Synchronization;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;

public class TxScopedEntityManager
implements EntityManager {
    private String unitName;
    private EntityManagerFactory emf;
    private SynchronizationType sync;
    private TransactionManager transactionManager;
    private TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    private NonTxEntityManagerHolder nonTxEmHolder;

    public TxScopedEntityManager(String unitName, EntityManagerFactory emf, SynchronizationType sync, TransactionManager transactionManager, TransactionSynchronizationRegistry transactionSynchronizationRegistry, NonTxEntityManagerHolder nonTxEmHolder) {
        this.unitName = unitName;
        this.emf = emf;
        this.sync = sync;
        this.transactionManager = transactionManager;
        this.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
        this.nonTxEmHolder = nonTxEmHolder;
    }

    public void persist(Object entity) {
        this.validateActiveTransaction();
        this.getEntityManager().persist(entity);
    }

    public <T> T merge(T entity) {
        this.validateActiveTransaction();
        return (T)this.getEntityManager().merge(entity);
    }

    public void remove(Object entity) {
        this.validateActiveTransaction();
        this.getEntityManager().remove(entity);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        EntityManager em = this.getEntityManager();
        Object result = em.find(entityClass, primaryKey);
        this.detachLoadedNonTxEntities(em);
        return (T)result;
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        EntityManager em = this.getEntityManager();
        Object result = em.find(entityClass, primaryKey, properties);
        this.detachLoadedNonTxEntities(em);
        return (T)result;
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode) {
        EntityManager em = this.getEntityManager();
        Object result = em.find(entityClass, primaryKey, lockMode);
        this.detachLoadedNonTxEntities(em);
        return (T)result;
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        EntityManager em = this.getEntityManager();
        Object result = em.find(entityClass, primaryKey, lockMode, properties);
        this.detachLoadedNonTxEntities(em);
        return (T)result;
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        EntityManager em = this.getEntityManager();
        Object result = em.getReference(entityClass, primaryKey);
        this.detachLoadedNonTxEntities(em);
        return (T)result;
    }

    public void flush() {
        this.getEntityManager().flush();
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.getEntityManager().setFlushMode(flushMode);
    }

    public FlushModeType getFlushMode() {
        return this.getEntityManager().getFlushMode();
    }

    public void lock(Object entity, LockModeType lockMode) {
        this.getEntityManager().lock(entity, lockMode);
    }

    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.getEntityManager().lock(entity, lockMode, properties);
    }

    public void refresh(Object entity) {
        this.validateActiveTransaction();
        this.getEntityManager().refresh(entity);
    }

    public void refresh(Object entity, Map<String, Object> properties) {
        this.validateActiveTransaction();
        this.getEntityManager().refresh(entity, properties);
    }

    public void refresh(Object entity, LockModeType lockMode) {
        this.validateActiveTransaction();
        this.getEntityManager().refresh(entity, lockMode);
    }

    public void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.validateActiveTransaction();
        this.getEntityManager().refresh(entity, lockMode, properties);
    }

    public void clear() {
        this.getEntityManager().clear();
    }

    public void detach(Object entity) {
        this.getEntityManager().detach(entity);
    }

    public boolean contains(Object entity) {
        return this.getEntityManager().contains(entity);
    }

    public LockModeType getLockMode(Object entity) {
        return this.getEntityManager().getLockMode(entity);
    }

    public void setProperty(String propertyName, Object value) {
        this.getEntityManager().setProperty(propertyName, value);
    }

    public Map<String, Object> getProperties() {
        return this.getEntityManager().getProperties();
    }

    public Query createQuery(String qlString) {
        EntityManager em = this.getEntityManager();
        Query query = em.createQuery(qlString);
        return this.detachLoadedNonTxQueryEntities(query, em);
    }

    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        EntityManager em = this.getEntityManager();
        TypedQuery typedQuery = em.createQuery(criteriaQuery);
        return this.detachLoadedNonTxTypedQueryEntities(typedQuery, em);
    }

    public Query createQuery(CriteriaUpdate updateQuery) {
        return this.getEntityManager().createQuery(updateQuery);
    }

    public Query createQuery(CriteriaDelete deleteQuery) {
        return this.getEntityManager().createQuery(deleteQuery);
    }

    public <T> TypedQuery<T> createQuery(String qlString, Class<T> resultClass) {
        EntityManager em = this.getEntityManager();
        TypedQuery typedQuery = em.createQuery(qlString, resultClass);
        return this.detachLoadedNonTxTypedQueryEntities(typedQuery, em);
    }

    public Query createNamedQuery(String name) {
        EntityManager em = this.getEntityManager();
        Query query = em.createNamedQuery(name);
        return this.detachLoadedNonTxQueryEntities(query, em);
    }

    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        EntityManager em = this.getEntityManager();
        TypedQuery typedQuery = em.createNamedQuery(name, resultClass);
        return this.detachLoadedNonTxTypedQueryEntities(typedQuery, em);
    }

    public Query createNativeQuery(String sqlString) {
        EntityManager em = this.getEntityManager();
        Query query = em.createNativeQuery(sqlString);
        return this.detachLoadedNonTxQueryEntities(query, em);
    }

    public Query createNativeQuery(String sqlString, Class resultClass) {
        EntityManager em = this.getEntityManager();
        Query query = em.createNativeQuery(sqlString, resultClass);
        return this.detachLoadedNonTxQueryEntities(query, em);
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        EntityManager em = this.getEntityManager();
        Query query = em.createNativeQuery(sqlString, resultSetMapping);
        return this.detachLoadedNonTxQueryEntities(query, em);
    }

    public StoredProcedureQuery createNamedStoredProcedureQuery(String name) {
        EntityManager em = this.getEntityManager();
        StoredProcedureQuery storedProcedureQuery = em.createNamedStoredProcedureQuery(name);
        return this.detachLoadedNonTxStoredProcedureQueryEntities(storedProcedureQuery, em);
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName) {
        EntityManager em = this.getEntityManager();
        StoredProcedureQuery storedProcedureQuery = em.createStoredProcedureQuery(procedureName);
        return this.detachLoadedNonTxStoredProcedureQueryEntities(storedProcedureQuery, em);
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, Class ... resultClasses) {
        EntityManager em = this.getEntityManager();
        StoredProcedureQuery storedProcedureQuery = em.createStoredProcedureQuery(procedureName, resultClasses);
        return this.detachLoadedNonTxStoredProcedureQueryEntities(storedProcedureQuery, em);
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, String ... resultSetMappings) {
        EntityManager em = this.getEntityManager();
        StoredProcedureQuery storedProcedureQuery = em.createStoredProcedureQuery(procedureName, resultSetMappings);
        return this.detachLoadedNonTxStoredProcedureQueryEntities(storedProcedureQuery, em);
    }

    public void joinTransaction() {
        this.getEntityManager().joinTransaction();
    }

    public boolean isJoinedToTransaction() {
        return this.getEntityManager().isJoinedToTransaction();
    }

    public <T> T unwrap(Class<T> cls) {
        return (T)this.getEntityManager().unwrap(cls);
    }

    public Object getDelegate() {
        return this.getEntityManager().getDelegate();
    }

    public void close() {
        throw new IllegalStateException("Cannot closed a transaction managed entity manager.");
    }

    public boolean isOpen() {
        return this.getEntityManager().isOpen();
    }

    public EntityTransaction getTransaction() {
        return this.getEntityManager().getTransaction();
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.getEntityManager().getEntityManagerFactory();
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.getEntityManager().getCriteriaBuilder();
    }

    public Metamodel getMetamodel() {
        return this.getEntityManager().getMetamodel();
    }

    public <T> EntityGraph<T> createEntityGraph(Class<T> rootType) {
        return this.getEntityManager().createEntityGraph(rootType);
    }

    public EntityGraph<?> createEntityGraph(String graphName) {
        return this.getEntityManager().createEntityGraph(graphName);
    }

    public EntityGraph<?> getEntityGraph(String graphName) {
        return this.getEntityManager().getEntityGraph(graphName);
    }

    public <T> List<EntityGraph<? super T>> getEntityGraphs(Class<T> entityClass) {
        return this.getEntityManager().getEntityGraphs(entityClass);
    }

    private EntityManager getEntityManager() {
        EntityManager em;
        if (TxUtils.isActive((TransactionManager)this.transactionManager).booleanValue()) {
            em = (EntityManager)this.transactionSynchronizationRegistry.getResource((Object)this.unitName);
            if (em == null) {
                em = this.createEntityManager();
                this.transactionSynchronizationRegistry.registerInterposedSynchronization((Synchronization)new TxSynchronization(em));
                this.transactionSynchronizationRegistry.putResource((Object)this.unitName, (Object)em);
            } else {
                this.validateCompatibleSyncTypes(em);
            }
        } else {
            em = this.nonTxEmHolder.getEntityManager();
            if (em == null) {
                em = this.createEntityManager();
                this.nonTxEmHolder.setEntityManager(em);
            }
        }
        return em;
    }

    private EntityManager createEntityManager() {
        if (this.sync.equals((Object)SynchronizationType.UNSYNCHRONIZED)) {
            return new SyncEntityManagerWrapper(this.emf.createEntityManager(this.sync), this.sync);
        }
        return this.emf.createEntityManager();
    }

    private void detachLoadedNonTxEntities(EntityManager em) {
        if (!TxUtils.isActive((TransactionManager)this.transactionManager).booleanValue()) {
            em.clear();
        }
    }

    private Query detachLoadedNonTxQueryEntities(Query query, EntityManager em) {
        if (!TxUtils.isActive((TransactionManager)this.transactionManager).booleanValue()) {
            return new NonTxQueryWrapper(query, em);
        }
        return query;
    }

    private <T> TypedQuery<T> detachLoadedNonTxTypedQueryEntities(TypedQuery<T> query, EntityManager em) {
        if (!TxUtils.isActive((TransactionManager)this.transactionManager).booleanValue()) {
            return new NonTxTypedQueryWrapper<T>(query, em);
        }
        return query;
    }

    private StoredProcedureQuery detachLoadedNonTxStoredProcedureQueryEntities(StoredProcedureQuery procedureQuery, EntityManager em) {
        if (!TxUtils.isActive((TransactionManager)this.transactionManager).booleanValue()) {
            return new NonTxStoredProcedureQueryWrapper(procedureQuery, em);
        }
        return procedureQuery;
    }

    private void validateActiveTransaction() {
        if (!TxUtils.isActive((TransactionManager)this.transactionManager).booleanValue()) {
            throw new TransactionRequiredException("An active transaction is required in order to perform this function.");
        }
    }

    private void validateCompatibleSyncTypes(EntityManager existingEm) {
        if (existingEm instanceof SyncEntityManagerWrapper && ((SyncEntityManagerWrapper)existingEm).getSynchronizationType().equals((Object)this.sync)) {
            throw new IllegalStateException("Incompatible SynchronizationType for the same PersistenceContext across multiple injection points. The SynchronizationType can not be SYNCHRONIZED if a previous one that is UNSYCHRONIZED already exists.");
        }
    }
}

