/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk;

import com.launchdarkly.sdk.LDValue;
import java.util.HashMap;
import java.util.Map;

final class AttributeMap {
    private final AttributeMap parent;
    private final Map<String, LDValue> map;

    AttributeMap() {
        this(null);
    }

    AttributeMap(AttributeMap parent) {
        this.parent = parent;
        this.map = new HashMap<String, LDValue>();
    }

    LDValue get(String key) {
        AttributeMap current = this;
        while (current != null) {
            LDValue value = current.map.get(key);
            if (value != null) {
                if (value.isNull()) break;
                return value;
            }
            current = current.parent;
        }
        return null;
    }

    void put(String key, LDValue value) {
        this.map.put(key, value);
    }

    public int hashCode() {
        return this.flatten().hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AttributeMap)) {
            return false;
        }
        AttributeMap o = (AttributeMap)other;
        return this.flatten().equals(o.flatten());
    }

    Map<String, LDValue> flatten() {
        if (this.parent == null) {
            return this.map;
        }
        HashMap<String, LDValue> out = new HashMap<String, LDValue>();
        this.flattenRecursive(out);
        return out;
    }

    private void flattenRecursive(Map<String, LDValue> out) {
        if (this.parent != null) {
            this.parent.flattenRecursive(out);
        }
        for (Map.Entry<String, LDValue> entry : this.map.entrySet()) {
            String key = entry.getKey();
            LDValue value = entry.getValue();
            if (value.isNull()) {
                out.remove(key);
                continue;
            }
            out.put(key, value);
        }
    }

    void remove(String key) {
        if (this.parent == null) {
            this.map.remove(key);
            return;
        }
        this.map.put(key, LDValue.ofNull());
    }
}

