/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk;

import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.LDValueObject;
import java.util.HashMap;
import java.util.Map;

public final class ObjectBuilder {
    private volatile Map<String, LDValue> builder = new HashMap<String, LDValue>();
    private volatile boolean copyOnWrite = false;

    public ObjectBuilder put(String key, LDValue value) {
        if (this.copyOnWrite) {
            this.builder = new HashMap<String, LDValue>(this.builder);
            this.copyOnWrite = false;
        }
        this.builder.put(key, value == null ? LDValue.ofNull() : value);
        return this;
    }

    public ObjectBuilder put(String key, boolean value) {
        return this.put(key, LDValue.of(value));
    }

    public ObjectBuilder put(String key, int value) {
        return this.put(key, LDValue.of(value));
    }

    public ObjectBuilder put(String key, long value) {
        return this.put(key, LDValue.of(value));
    }

    public ObjectBuilder put(String key, float value) {
        return this.put(key, LDValue.of(value));
    }

    public ObjectBuilder put(String key, double value) {
        return this.put(key, LDValue.of(value));
    }

    public ObjectBuilder put(String key, String value) {
        return this.put(key, LDValue.of(value));
    }

    public LDValue build() {
        this.copyOnWrite = true;
        return LDValueObject.fromMap(this.builder);
    }
}

