/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.analyzer.statistics;

import com.lazerycode.jmeter.analyzer.statistics.Quantile;
import com.lazerycode.jmeter.analyzer.statistics.ValueCount;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Samples {
    private static final float SECOND = 1000.0f;
    private long errors = 0L;
    private long success = 0L;
    private List<Long> samples = new ArrayList<Long>();
    private List<Long> timestamps = new ArrayList<Long>();
    private long minTimestamp = Long.MAX_VALUE;
    private long maxTimestamp = Long.MIN_VALUE;
    private long min = Long.MAX_VALUE;
    private long max = Long.MIN_VALUE;
    private volatile boolean finished = false;
    private int compression = 1;
    private final int maxSamplesCount;
    private List<Long> samplesBuffer = new ArrayList<Long>();
    private List<Long> timestampsBuffer = new ArrayList<Long>();
    private double total = 0.0;
    private double totalPowered2 = 0.0;
    private long standardDeviation;
    private Map<Long, ValueCount> histogram;

    public Samples(int maxSamples, boolean histogram) {
        this.maxSamplesCount = maxSamples;
        if (histogram) {
            this.histogram = new HashMap<Long, ValueCount>();
        }
    }

    public void addError(long timestamp) {
        this.assertNotFinished();
        ++this.errors;
        this.setTimestamp(timestamp);
    }

    public void addSample(long timestamp, long value) {
        this.assertNotFinished();
        ++this.success;
        this.total += (double)value;
        this.totalPowered2 += Math.pow(value, 2.0);
        if (value > this.max) {
            this.max = value;
        }
        if (value < this.min) {
            this.min = value;
        }
        this.setTimestamp(timestamp);
        if (this.histogram != null) {
            ValueCount count = this.histogram.get(value);
            if (count == null) {
                count = new ValueCount(value);
                this.histogram.put(value, count);
            }
            count.increment();
        }
        this.add(timestamp, value);
    }

    public void finish() {
        this.finished = true;
        if (this.samplesBuffer.size() > 0) {
            this.addAggregated(this.samplesBuffer, this.timestampsBuffer);
            this.samplesBuffer.clear();
            this.timestampsBuffer.clear();
        }
        double totalPowered0 = this.success;
        double totalPowered1 = this.total;
        this.standardDeviation = (long)(Math.sqrt(totalPowered0 * this.totalPowered2 - Math.pow(totalPowered1, 2.0)) / totalPowered0);
        this.samples = Collections.unmodifiableList(this.samples);
        this.timestamps = Collections.unmodifiableList(this.timestamps);
    }

    public boolean hasSamples() {
        return this.getSuccessCount() > 0L;
    }

    public List<Long> getSamples() {
        this.assertFinished();
        return this.samples;
    }

    public List<Long> getTimestamps() {
        this.assertFinished();
        return this.timestamps;
    }

    public long getStoredSamplesCount() {
        this.assertFinished();
        return this.samples.size();
    }

    public long getSuccessCount() {
        this.assertFinished();
        return this.success;
    }

    public long getErrorsCount() {
        this.assertFinished();
        return this.errors;
    }

    public long getMin() {
        this.assertFinished();
        if (!this.hasSamples()) {
            throw new IllegalStateException("No samples");
        }
        return this.min;
    }

    public long getMax() {
        this.assertFinished();
        if (!this.hasSamples()) {
            throw new IllegalStateException("No samples");
        }
        return this.max;
    }

    public long getAverage() {
        this.assertFinished();
        long count = this.getSuccessCount();
        if (count == 0L) {
            throw new IllegalStateException("No samples");
        }
        return (long)this.total / count;
    }

    public long getTotal() {
        this.assertFinished();
        return (long)this.total;
    }

    public long getStandardDeviation() {
        return this.standardDeviation;
    }

    public long getMaxTimestamp() {
        this.assertFinished();
        return this.maxTimestamp;
    }

    public long getMinTimestamp() {
        this.assertFinished();
        return this.minTimestamp;
    }

    public long getSuccessPerSecond() {
        this.assertFinished();
        long duration = this.getDuration();
        if (duration == 0L) {
            return 0L;
        }
        return this.getSuccessCount() / duration;
    }

    public long getDuration() {
        this.assertFinished();
        return Math.round((float)(this.getMaxTimestamp() - this.getMinTimestamp()) / 1000.0f);
    }

    public Quantile getQuantiles(int q) {
        this.assertFinished();
        if (this.histogram == null) {
            throw new IllegalStateException("No histogram available");
        }
        return new Quantile(q, this.histogram.values());
    }

    private void assertNotFinished() {
        if (this.finished) {
            throw new IllegalStateException("Already finished");
        }
    }

    private void assertFinished() {
        if (!this.finished) {
            throw new IllegalStateException("Not finished");
        }
    }

    private void setTimestamp(long timestamp) {
        if (timestamp < this.minTimestamp) {
            this.minTimestamp = timestamp;
        }
        if (timestamp > this.maxTimestamp) {
            this.maxTimestamp = timestamp;
        }
    }

    private void add(long timestamp, long value) {
        if (this.maxSamplesCount == 0) {
            return;
        }
        if (this.maxSamplesCount > 0 && this.samples.size() >= this.maxSamplesCount) {
            this.halve();
            this.compression *= 2;
        }
        if (this.compression == 1) {
            this.samples.add(value);
            this.timestamps.add(timestamp);
        } else {
            this.samplesBuffer.add(value);
            this.timestampsBuffer.add(timestamp);
            if (this.samplesBuffer.size() >= this.compression) {
                this.addAggregated(this.samplesBuffer, this.timestampsBuffer);
                this.samplesBuffer.clear();
                this.timestampsBuffer.clear();
            }
        }
    }

    private void addAggregated(List<Long> samplesBuffer, List<Long> timestampsBuffer) {
        long firstTimestamp = timestampsBuffer.get(0);
        long lastTimestamp = timestampsBuffer.get(timestampsBuffer.size() - 1);
        long aggregatedTimestamp = firstTimestamp + (lastTimestamp - firstTimestamp) / 2L;
        long aggregatedSample = 0L;
        for (long sample : samplesBuffer) {
            aggregatedSample += sample;
        }
        this.samples.add(aggregatedSample /= (long)samplesBuffer.size());
        this.timestamps.add(aggregatedTimestamp);
    }

    private void halve() {
        ArrayList<Long> newSamples = new ArrayList<Long>();
        ArrayList<Long> newTimestamps = new ArrayList<Long>();
        Iterator<Long> si = this.samples.iterator();
        Iterator<Long> ti = this.timestamps.iterator();
        while (si.hasNext()) {
            long sample = si.next();
            long timestamp = ti.next();
            if (!si.hasNext()) {
                newSamples.add(sample);
                newTimestamps.add(timestamp);
                continue;
            }
            long secondTimestamp = ti.next();
            long secondSample = si.next();
            long aggregatedSample = (sample + secondSample) / 2L;
            long aggregatedTimestamp = timestamp + (secondTimestamp - timestamp) / 2L;
            newSamples.add(aggregatedSample);
            newTimestamps.add(aggregatedTimestamp);
        }
        this.samples = newSamples;
        this.timestamps = newTimestamps;
    }
}

