/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.checker;

import com.lazerycode.jmeter.analyzer.Check;
import com.lazerycode.jmeter.analyzer.CheckResult;
import com.lazerycode.jmeter.analyzer.RequestGroup;
import com.lazerycode.jmeter.analyzer.config.Environment;
import com.lazerycode.jmeter.analyzer.parser.AggregatedResponses;
import java.util.Map;
import org.apache.maven.plugin.MojoFailureException;

public class ResultChecker {
    public void check(Map<String, AggregatedResponses> jmeterResults) throws MojoFailureException {
        boolean check = true;
        for (String key : jmeterResults.keySet()) {
            AggregatedResponses aggregatedResponses = jmeterResults.get(key);
            CheckResult checkResult = this.getCheckResult(key);
            check &= this.checkValue(checkResult.getThroughput(), aggregatedResponses.getDuration().getSuccessPerSecond(), key, "throughput");
            double percentErrors = (double)aggregatedResponses.getDuration().getErrorsCount() / (double)(aggregatedResponses.getDuration().getErrorsCount() + aggregatedResponses.getDuration().getSuccessCount()) * 100.0;
            check &= this.checkValue(checkResult.getErrors(), percentErrors, key, "errors");
        }
        if (!check) {
            throw new MojoFailureException("Check is incorrect.");
        }
    }

    private CheckResult getCheckResult(String key) {
        CheckResult result = null;
        if (null != Environment.ENVIRONMENT.getRequestGroups()) {
            for (RequestGroup requestGroup : Environment.ENVIRONMENT.getRequestGroups()) {
                if (!key.equals(requestGroup.getName())) continue;
                result = requestGroup.getCheckResult();
                break;
            }
        }
        if (null == result) {
            result = Environment.ENVIRONMENT.getCheckResult();
        }
        return result;
    }

    private boolean checkValue(Check check, double value, String key, String valueDescription) {
        Boolean valid = check.valid(value);
        if (null == valid) {
            valid = true;
            Environment.ENVIRONMENT.getLog().info((CharSequence)(key + " : Check " + valueDescription + " disabling : " + value));
        } else if (!valid.booleanValue()) {
            Environment.ENVIRONMENT.getLog().error((CharSequence)(key + " : Check " + valueDescription + " is incorrect : " + value + " (minValue : " + check.getMinValue() + ", maxValue : " + check.getMaxValue() + ")"));
        } else {
            Environment.ENVIRONMENT.getLog().info((CharSequence)(key + " : Check " + valueDescription + " is correct : " + value + " (minValue : " + check.getMinValue() + ", maxValue : " + check.getMaxValue() + ")"));
        }
        return valid;
    }
}

