/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.configuration;

import com.lazerycode.jmeter.configuration.JMeterCommandLineArguments;
import com.lazerycode.jmeter.properties.ConfigurationFiles;
import com.lazerycode.jmeter.properties.PropertiesMapping;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class RemoteArgumentsArrayBuilder {
    RemoteArgumentsArrayBuilder() throws InstantiationError {
        throw new InstantiationError("This class is non-instantiable.");
    }

    public static List<String> buildRemoteArgumentsArray(Map<ConfigurationFiles, PropertiesMapping> propertiesMap) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<ConfigurationFiles, PropertiesMapping> entry : propertiesMap.entrySet()) {
            Properties properties = entry.getValue().getPropertiesFile().getProperties();
            switch (entry.getKey()) {
                case SYSTEM_PROPERTIES: {
                    result.addAll(RemoteArgumentsArrayBuilder.buildTypedPropertiesForContainer(JMeterCommandLineArguments.SYSTEM_PROPERTY, properties));
                    break;
                }
                case GLOBAL_PROPERTIES: {
                    result.addAll(RemoteArgumentsArrayBuilder.buildTypedPropertiesForContainer(JMeterCommandLineArguments.JMETER_GLOBAL_PROP, properties));
                    break;
                }
            }
        }
        return result;
    }

    private static List<String> buildTypedPropertiesForContainer(JMeterCommandLineArguments cmdLineArg, Properties props) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            if (cmdLineArg == JMeterCommandLineArguments.SYSTEM_PROPERTY) {
                result.add(cmdLineArg.getCommandLineArgument() + e.getKey());
                result.add(e.getValue().toString());
                continue;
            }
            result.add(cmdLineArg.getCommandLineArgument() + e.getKey() + "=" + e.getValue());
        }
        return result;
    }
}

