/*
 * Decompiled with CFR 0.152.
 */
package com.lesfurets.jenkins.unit.global.lib;

import com.lesfurets.jenkins.unit.global.lib.LibraryConfiguration;
import com.lesfurets.jenkins.unit.global.lib.LibraryRecord;
import groovy.io.FileType;
import groovy.lang.Closure;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class LibraryLoader
implements GroovyObject {
    private final GroovyClassLoader groovyClassLoader;
    private final Map<String, LibraryConfiguration> libraryDescriptions;
    private Boolean preloadLibraryClasses;
    private final Map<String, LibraryRecord> libRecords;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    /*
     * WARNING - void declaration
     */
    public LibraryLoader(GroovyClassLoader groovyClassLoader, Map<String, LibraryConfiguration> map) {
        void libraryDescriptions;
        void groovyClassLoader2;
        MetaClass metaClass;
        boolean bl = true;
        this.preloadLibraryClasses = bl;
        HashMap<String, LibraryRecord> hashMap = new HashMap<String, LibraryRecord>();
        this.libRecords = hashMap;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        void var6_6 = groovyClassLoader2;
        this.groovyClassLoader = var6_6;
        void var7_7 = libraryDescriptions;
        this.libraryDescriptions = var7_7;
    }

    public static String getLibraryId(LibraryConfiguration lib, String version) {
        String string;
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{lib.getName(), DefaultTypeTransformation.booleanUnbox((Object)(string = version)) ? string : lib.getDefaultVersion()}, new String[]{"", "@", ""}));
    }

    public GroovyClassLoader getGroovyClassLoader() {
        return this.groovyClassLoader;
    }

    public void loadImplicitLibraries() {
        public class _loadImplicitLibraries_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _loadImplicitLibraries_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ((LibraryConfiguration)it).getImplicit();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _loadImplicitLibraries_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        public class _loadImplicitLibraries_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _loadImplicitLibraries_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return !((LibraryLoader)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), LibraryLoader.class)).getLibRecords().containsKey(LibraryLoader.getLibraryId((LibraryConfiguration)ScriptBytecodeAdapter.castToType((Object)it, LibraryConfiguration.class)));
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _loadImplicitLibraries_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        public class _loadImplicitLibraries_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _loadImplicitLibraries_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return InvokerHelper.invokeMethodSafe((Object)((LibraryLoader)this.getThisObject()), (String)"doLoadLibrary", (Object)new Object[]{it});
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _loadImplicitLibraries_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        this.libraryDescriptions.values().stream().filter((Predicate)ScriptBytecodeAdapter.castToType((Object)((Object)new _loadImplicitLibraries_closure1(this, this)), Predicate.class)).filter((Predicate)ScriptBytecodeAdapter.castToType((Object)((Object)new _loadImplicitLibraries_closure2(this, this)), Predicate.class)).forEach((Consumer)ScriptBytecodeAdapter.castToType((Object)((Object)new _loadImplicitLibraries_closure3(this, this)), Consumer.class));
    }

    public void loadLibrary(String expression) throws Exception {
        Object[] lib = LibraryLoader.parse(expression);
        String libName = ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])lib, (int)0));
        String version = ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])lib, (int)1));
        LibraryConfiguration library = (LibraryConfiguration)ScriptBytecodeAdapter.castToType((Object)this.libraryDescriptions.get(libName), LibraryConfiguration.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)library)) {
            throw (Throwable)new Exception(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{libName}, new String[]{"Library description '", "' not found"})));
        }
        if (!LibraryLoader.matches(libName, version, library)) {
            throw (Throwable)new Exception(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{expression, library}, new String[]{"Library '", "' does not match description ", ""})));
        }
        if (!this.libRecords.containsKey(LibraryLoader.getLibraryId(library, version))) {
            this.doLoadLibrary(library, version);
        }
    }

    private void doLoadLibrary(LibraryConfiguration library, String version) throws Exception {
        String string;
        DefaultGroovyMethods.println((Object)this, (Object)new GStringImpl(new Object[]{library.getName(), DefaultTypeTransformation.booleanUnbox((Object)(string = version)) ? string : library.getDefaultVersion()}, new String[]{"Loading shared library ", " with version ", ""}));
        try {
            String string2 = version;
            List<URL> urls = library.getRetriever().retrieve(library.getName(), DefaultTypeTransformation.booleanUnbox((Object)string2) ? string2 : library.getDefaultVersion(), library.getTargetPath());
            String string3 = version;
            LibraryRecord record = new LibraryRecord(library, DefaultTypeTransformation.booleanUnbox((Object)string3) ? string3 : library.getDefaultVersion(), (List)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.getPropertySpreadSafe(LibraryLoader.class, urls, (String)"path"), List.class));
            this.libRecords.put(record.getIdentifier(), record);
            Reference globalVars = new Reference((Object)((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class)));
            public class _doLoadLibrary_closure4
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference globalVars;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _doLoadLibrary_closure4(Object _outerInstance, Object _thisObject, Reference globalVars) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.globalVars = reference = globalVars;
                }

                public Object doCall(URL url) {
                    File file = new File(url.toURI());
                    Path srcPath = file.toPath().resolve("src");
                    Path varsPath = file.toPath().resolve("vars");
                    Path resourcesPath = file.toPath().resolve("resources");
                    ((LibraryLoader)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), LibraryLoader.class)).getGroovyClassLoader().addURL(srcPath.toUri().toURL());
                    ((LibraryLoader)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), LibraryLoader.class)).getGroovyClassLoader().addURL(varsPath.toUri().toURL());
                    ((LibraryLoader)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), LibraryLoader.class)).getGroovyClassLoader().addURL(resourcesPath.toUri().toURL());
                    if (varsPath.toFile().exists()) {
                        Stream<Path> ds = Files.list(varsPath);
                        public class _closure5
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure5(Object _outerInstance, Object _thisObject) {
                                super(_outerInstance, _thisObject);
                            }

                            public Object doCall(Object it) {
                                return ((Path)it).toFile();
                            }

                            public Object call(Object args) {
                                return this.doCall(args);
                            }

                            public Object call() {
                                return this.doCall(null);
                            }

                            public Object doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure5.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        public class _closure6
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure6(Object _outerInstance, Object _thisObject) {
                                super(_outerInstance, _thisObject);
                            }

                            public Object doCall(File it) {
                                return it.getName().endsWith(".groovy");
                            }

                            public Object call(File it) {
                                return this.doCall(it);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure6.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        public class _closure7
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure7(Object _outerInstance, Object _thisObject) {
                                super(_outerInstance, _thisObject);
                            }

                            public Object doCall(Object it) {
                                return FilenameUtils.getBaseName((String)((File)it).getName());
                            }

                            public Object call(Object args) {
                                return this.doCall(args);
                            }

                            public Object call() {
                                return this.doCall(null);
                            }

                            public Object doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure7.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        public class _closure8
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference globalVars;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure8(Object _outerInstance, Object _thisObject, Reference globalVars) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                this.globalVars = reference = globalVars;
                            }

                            public Object doCall(String it) {
                                return !((LinkedHashMap)this.globalVars.get()).containsValue(it);
                            }

                            public Object call(String it) {
                                return this.doCall(it);
                            }

                            public Object getGlobalVars() {
                                return this.globalVars.get();
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure8.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        public class _closure9
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference globalVars;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure9(Object _outerInstance, Object _thisObject, Reference globalVars) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                this.globalVars = reference = globalVars;
                            }

                            public Object doCall(String it) {
                                Class clazz = ((LibraryLoader)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), LibraryLoader.class)).getGroovyClassLoader().loadClass(it);
                                Object var = DefaultGroovyMethods.newInstance((Class)clazz);
                                return ((LinkedHashMap)this.globalVars.get()).put(it, var);
                            }

                            public Object call(String it) {
                                return this.doCall(it);
                            }

                            public Object getGlobalVars() {
                                return this.globalVars.get();
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure9.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        ds.map((Function)ScriptBytecodeAdapter.castToType((Object)((Object)new _closure5((Object)this, this.getThisObject())), Function.class)).filter((Predicate)ScriptBytecodeAdapter.asType((Object)((Object)new _closure6((Object)this, this.getThisObject())), Predicate.class)).map((Function)ScriptBytecodeAdapter.castToType((Object)((Object)new _closure7((Object)this, this.getThisObject())), Function.class)).filter((Predicate)ScriptBytecodeAdapter.asType((Object)((Object)new _closure8((Object)this, this.getThisObject(), this.globalVars)), Predicate.class)).forEach((Consumer)ScriptBytecodeAdapter.asType((Object)((Object)new _closure9((Object)this, this.getThisObject(), this.globalVars)), Consumer.class));
                        ds.close();
                    }
                    if (DefaultTypeTransformation.booleanUnbox((Object)((LibraryLoader)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), LibraryLoader.class)).getPreloadLibraryClasses()) && srcPath.toFile().exists()) {
                        public class _closure10
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure10(Object _outerInstance, Object _thisObject) {
                                super(_outerInstance, _thisObject);
                            }

                            public Object doCall(File srcFile) {
                                if (srcFile.getName().endsWith(".groovy")) {
                                    Class clazz = ((LibraryLoader)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), LibraryLoader.class)).getGroovyClassLoader().parseClass(srcFile);
                                    return ((LibraryLoader)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), LibraryLoader.class)).getGroovyClassLoader().loadClass(clazz.getName());
                                }
                                return null;
                            }

                            public Object call(File srcFile) {
                                return this.doCall(srcFile);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure10.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        ResourceGroovyMethods.eachFileRecurse((File)srcPath.toFile(), (FileType)FileType.FILES, (Closure)new _closure10((Object)this, this.getThisObject()));
                        return null;
                    }
                    return null;
                }

                public Object call(URL url) {
                    return this.doCall(url);
                }

                public Object getGlobalVars() {
                    return this.globalVars.get();
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _doLoadLibrary_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            urls.forEach((Consumer)ScriptBytecodeAdapter.castToType((Object)((Object)new _doLoadLibrary_closure4(this, this, globalVars)), Consumer.class));
            LinkedHashMap linkedHashMap = (LinkedHashMap)globalVars.get();
            record.setDefinedGlobalVars(linkedHashMap);
        }
        catch (Exception e) {
            throw (Throwable)new LibraryLoadingException(e, library, version);
        }
    }

    private static String[] parse(String identifier) {
        identifier.split("@");
        int at = identifier.indexOf("@");
        if (ScriptBytecodeAdapter.compareEqual((Object)at, (Object)-1)) {
            return new String[]{identifier, ShortTypeHandling.castToString(null)};
        }
        return new String[]{identifier.substring(0, at), identifier.substring(at + 1)};
    }

    private static boolean matches(String libName, String version, LibraryConfiguration libraryDescription) {
        if (ScriptBytecodeAdapter.compareEqual((Object)libraryDescription.getName(), (Object)libName)) {
            if (version == null) {
                return true;
            }
            if (libraryDescription.getAllowOverride() || ScriptBytecodeAdapter.compareEqual((Object)libraryDescription.getDefaultVersion(), (Object)version)) {
                return true;
            }
        }
        return false;
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(LibraryLoader.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, LibraryLoader.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(LibraryLoader.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public static /* synthetic */ GroovyClassLoader pfaccess$0(LibraryLoader $that) {
        return $that.getGroovyClassLoader();
    }

    public static /* synthetic */ Boolean pfaccess$1(LibraryLoader $that) {
        return $that.getPreloadLibraryClasses();
    }

    public static /* synthetic */ Map<String, LibraryRecord> pfaccess$2(LibraryLoader $that) {
        return $that.getLibRecords();
    }

    public static String getLibraryId(LibraryConfiguration lib) {
        return LibraryLoader.getLibraryId(lib, null);
    }

    private void doLoadLibrary(LibraryConfiguration library) throws Exception {
        this.doLoadLibrary(library, null);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != LibraryLoader.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public Boolean getPreloadLibraryClasses() {
        return this.preloadLibraryClasses;
    }

    public void setPreloadLibraryClasses(Boolean bl) {
        this.preloadLibraryClasses = bl;
    }

    public final Map<String, LibraryRecord> getLibRecords() {
        return this.libRecords;
    }

    public static class LibraryLoadingException
    extends Exception
    implements GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        public LibraryLoadingException(Throwable cause, LibraryConfiguration configuration, String version) {
            super(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{LibraryLoader.getLibraryId(configuration, version), cause.getMessage()}, new String[]{"Error on loading library ", " : ", ""})), cause);
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(LibraryLoadingException.class, LibraryLoader.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, LibraryLoader.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(LibraryLoadingException.class, LibraryLoader.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != LibraryLoadingException.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }
}

