/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.extensions;

import com.liferay.gradle.plugins.extensions.AppServer;
import com.liferay.gradle.plugins.internal.extensions.AppServerFactory;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import groovy.lang.Closure;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;

public class LiferayExtension {
    protected final Project project;
    private Object _appServerParentDir;
    private final NamedDomainObjectContainer<AppServer> _appServers;
    private Object _appServerType;
    private final Map<String, Object> _defaultVersions = new HashMap<String, Object>();
    private Object _deployDir;
    private Closure<String> _deployedFileNameClosure;
    private Object _jmxRemotePort;
    private Object _liferayHome;

    public LiferayExtension(final Project project) {
        this.project = project;
        this._appServerParentDir = new Callable<File>(){

            @Override
            public File call() throws Exception {
                File dir = GradleUtil.getProperty((Project)project, (String)"app.server.parent.dir", (File)null);
                if (dir == null) {
                    Project rootProject = project.getRootProject();
                    dir = rootProject.file((Object)"../bundles");
                }
                return dir;
            }
        };
        this._appServerType = new Callable<String>(){

            @Override
            public String call() throws Exception {
                return GradleUtil.getProperty((ExtensionAware)project, (String)"app.server.type", (String)"tomcat");
            }
        };
        this._appServers = project.container(AppServer.class, (NamedDomainObjectFactory)new AppServerFactory(project));
        this._deployDir = new Callable<File>(){

            @Override
            public File call() throws Exception {
                File dir = GradleUtil.getProperty((Project)project, (String)"auto.deploy.dir", (File)null);
                if (dir == null) {
                    dir = new File(LiferayExtension.this.getAppServerParentDir(), "deploy");
                }
                return dir;
            }
        };
        this._deployedFileNameClosure = new Closure<String>((Object)project){

            public String doCall(AbstractArchiveTask abstractArchiveTask) {
                String fileName = abstractArchiveTask.getBaseName();
                String appendix = abstractArchiveTask.getAppendix();
                if (Validator.isNotNull((String)appendix)) {
                    fileName = fileName + "-" + appendix;
                }
                fileName = fileName + "." + abstractArchiveTask.getExtension();
                return fileName;
            }
        };
        this._jmxRemotePort = new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return GradleUtil.getProperty((ExtensionAware)project, "jmx.remote.port", 8099);
            }
        };
        this._liferayHome = new Callable<File>(){

            @Override
            public File call() throws Exception {
                return GradleUtil.getProperty((Project)project, (String)"liferay.home", (File)LiferayExtension.this.getAppServerParentDir());
            }
        };
    }

    public void appServers(Closure<?> closure) {
        this._appServers.configure(closure);
    }

    public void defaultDependencyNotation(String group, String name, Object version) {
        this._defaultVersions.put(this._getDependencyNotation(group, name), version);
    }

    public AppServer getAppServer() {
        return this.getAppServer(this.getAppServerType());
    }

    public AppServer getAppServer(String type) {
        return (AppServer)this._appServers.getAt(type);
    }

    public File getAppServerDeployDir() {
        AppServer appServer = this.getAppServer();
        return appServer.getDeployDir();
    }

    public File getAppServerDir() {
        AppServer appServer = this.getAppServer();
        return appServer.getDir();
    }

    public File getAppServerLibGlobalDir() {
        AppServer appServer = this.getAppServer();
        return appServer.getLibGlobalDir();
    }

    public File getAppServerParentDir() {
        return this.project.file(this._appServerParentDir);
    }

    public File getAppServerPortalDir() {
        AppServer appServer = this.getAppServer();
        return appServer.getPortalDir();
    }

    public NamedDomainObjectContainer<AppServer> getAppServers() {
        return this._appServers;
    }

    public String getAppServerType() {
        return GradleUtil.toString((Object)this._appServerType);
    }

    public String getDefaultVersion(ModuleVersionSelector moduleVersionSelector) {
        return this.getDefaultVersion(moduleVersionSelector.getGroup(), moduleVersionSelector.getName());
    }

    public String getDefaultVersion(String group, String name) {
        return this.getDefaultVersion(group, name, "latest.release");
    }

    public String getDefaultVersion(String group, String name, String defaultVersion) {
        String dependencyNotation = this._getDependencyNotation(group, name);
        String version = GradleUtil.toString((Object)this._defaultVersions.get(dependencyNotation));
        if (Validator.isNull((String)version)) {
            version = GradleUtil.getProperty((ExtensionAware)this.project, (String)(group + "." + name + ".version"), (String)null);
            if (Validator.isNull((String)version)) {
                version = GradleUtil.getProperty((ExtensionAware)this.project, (String)(name + ".version"), (String)defaultVersion);
            }
            this._defaultVersions.put(dependencyNotation, version);
        }
        return version;
    }

    public File getDeployDir() {
        return this.project.file(this._deployDir);
    }

    public Closure<String> getDeployedFileNameClosure() {
        return this._deployedFileNameClosure;
    }

    public int getJmxRemotePort() {
        Integer jmxRemotePort = GradleUtil.toInteger((Object)this._jmxRemotePort);
        if (jmxRemotePort != null) {
            return jmxRemotePort;
        }
        return 0;
    }

    public File getLiferayHome() {
        return this.project.file(this._liferayHome);
    }

    public void setAppServerParentDir(Object appServerParentDir) {
        this._appServerParentDir = appServerParentDir;
    }

    public void setAppServerType(String appServerType) {
        this._appServerType = appServerType;
    }

    public void setDeployDir(Object deployDir) {
        this._deployDir = deployDir;
    }

    public void setDeployedFileNameClosure(Closure<String> deployedFileNameClosure) {
        this._deployedFileNameClosure = deployedFileNameClosure;
    }

    public void setJmxRemotePort(Object jmxRemotePort) {
        this._jmxRemotePort = jmxRemotePort;
    }

    public void setLiferayHome(Object liferayHome) {
        this._liferayHome = liferayHome;
    }

    private String _getDependencyNotation(String group, String name) {
        return group + ":" + name;
    }
}

