/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.internal;

import com.liferay.gradle.plugins.BaseDefaultsPlugin;
import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.plugins.extensions.TomcatAppServer;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.plugins.test.integration.TestIntegrationPlugin;
import com.liferay.gradle.plugins.test.integration.TestIntegrationTomcatExtension;
import com.liferay.gradle.plugins.test.integration.tasks.SetUpTestableTomcatTask;
import com.liferay.gradle.plugins.test.integration.tasks.StartTestableTomcatTask;
import com.liferay.gradle.plugins.test.integration.tasks.StopAppServerTask;
import com.liferay.gradle.plugins.util.PortalTools;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.tasks.TaskProvider;

public class TestIntegrationDefaultsPlugin
extends BaseDefaultsPlugin<TestIntegrationPlugin> {
    public static final Plugin<Project> INSTANCE = new TestIntegrationDefaultsPlugin();

    @Override
    protected void applyPluginDefaults(Project project, TestIntegrationPlugin testIntegrationPlugin) {
        ExtensionContainer extensionContainer = project.getExtensions();
        LiferayExtension liferayExtension = (LiferayExtension)extensionContainer.getByType(LiferayExtension.class);
        TestIntegrationTomcatExtension testIntegrationTomcatExtension = (TestIntegrationTomcatExtension)extensionContainer.getByType(TestIntegrationTomcatExtension.class);
        TomcatAppServer tomcatAppServer = (TomcatAppServer)liferayExtension.getAppServer("tomcat");
        this._configureExtensionTestIntegrationTomcat(liferayExtension, testIntegrationTomcatExtension, tomcatAppServer);
        ConfigurationContainer configurationContainer = project.getConfigurations();
        Configuration testModulesConfiguration = configurationContainer.getByName("testModules");
        this._configureConfigurationTestModules(project, testModulesConfiguration);
        TaskProvider copyTestModulesTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"copyTestModules");
        TaskProvider setUpTestableTomcatTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"setUpTestableTomcat", SetUpTestableTomcatTask.class);
        TaskProvider startTestableTomcatTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"startTestableTomcat", StartTestableTomcatTask.class);
        TaskProvider stopTestableTomcatTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"stopTestableTomcat", StopAppServerTask.class);
        this._configureTaskCopyTestModulesProvider((TaskProvider<Task>)copyTestModulesTaskProvider);
        this._configureTaskSetUpTestableTomcatProvider(project, (TaskProvider<SetUpTestableTomcatTask>)setUpTestableTomcatTaskProvider, tomcatAppServer);
        this._configureTaskStartTestableTomcatProvider(project, (TaskProvider<StartTestableTomcatTask>)startTestableTomcatTaskProvider, tomcatAppServer);
        this._configureTaskStopTestableTomcatProvider((TaskProvider<StopAppServerTask>)stopTestableTomcatTaskProvider, tomcatAppServer);
    }

    @Override
    protected Class<TestIntegrationPlugin> getPluginClass() {
        return TestIntegrationPlugin.class;
    }

    private TestIntegrationDefaultsPlugin() {
    }

    private void _configureConfigurationTestModules(final Project project, Configuration testModulesConfiguration) {
        testModulesConfiguration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                String version = PortalTools.getPortalVersion(project);
                if ("7.0.x".equals(version) || "7.1.x".equals(version) || "7.2.x".equals(version)) {
                    GradleUtil.addDependency((Project)project, (String)"testModules", (String)"com.liferay.portal", (String)"com.liferay.portal.test.integration", (String)"3.0.0");
                }
            }
        });
    }

    private void _configureExtensionTestIntegrationTomcat(final LiferayExtension liferayExtension, TestIntegrationTomcatExtension testIntegrationTomcatExtension, final TomcatAppServer tomcatAppServer) {
        testIntegrationTomcatExtension.setCheckPath((Object)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return tomcatAppServer.getCheckPath();
            }
        });
        testIntegrationTomcatExtension.setPortNumber((Object)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return tomcatAppServer.getPortNumber();
            }
        });
        testIntegrationTomcatExtension.setDir((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return tomcatAppServer.getDir();
            }
        });
        testIntegrationTomcatExtension.setJmxRemotePort((Object)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return liferayExtension.getJmxRemotePort();
            }
        });
        testIntegrationTomcatExtension.setLiferayHome((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return liferayExtension.getLiferayHome();
            }
        });
        testIntegrationTomcatExtension.setManagerPassword((Object)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return tomcatAppServer.getManagerPassword();
            }
        });
        testIntegrationTomcatExtension.setManagerUserName((Object)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return tomcatAppServer.getManagerUserName();
            }
        });
    }

    private void _configureTaskCopyTestModulesProvider(TaskProvider<Task> copyTestModulesTaskProvider) {
        copyTestModulesTaskProvider.configure((Action)new Action<Task>(){

            public void execute(Task copyTestModulesTask) {
                GradleUtil.setProperty((ExtensionAware)copyTestModulesTask, (String)"autoClean", (Object)false);
            }
        });
    }

    private void _configureTaskSetUpTestableTomcatProvider(final Project project, TaskProvider<SetUpTestableTomcatTask> setUpTestableTomcatTaskProvider, final TomcatAppServer tomcatAppServer) {
        setUpTestableTomcatTaskProvider.configure((Action)new Action<SetUpTestableTomcatTask>(){

            public void execute(SetUpTestableTomcatTask setUpTestableTomcatTask) {
                setUpTestableTomcatTask.setJaCoCoAgentConfiguration((Object)GradleUtil.getProperty((ExtensionAware)project, (String)"jacoco.agent.configuration", (String)null));
                setUpTestableTomcatTask.setJaCoCoAgentFile((Object)GradleUtil.getProperty((ExtensionAware)project, (String)"jacoco.agent.jar", (String)null));
                setUpTestableTomcatTask.setAspectJAgent((Object)GradleUtil.getProperty((ExtensionAware)project, (String)"aspectj.agent", (String)null));
                setUpTestableTomcatTask.setAspectJConfiguration((Object)GradleUtil.getProperty((ExtensionAware)project, (String)"aspectj.configuration", (String)null));
                setUpTestableTomcatTask.setZipUrl((Object)new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return tomcatAppServer.getZipUrl();
                    }
                });
            }
        });
    }

    private void _configureTaskStartTestableTomcatProvider(final Project project, TaskProvider<StartTestableTomcatTask> startTestableTomcatTaskProvider, final TomcatAppServer tomcatAppServer) {
        startTestableTomcatTaskProvider.configure((Action)new Action<StartTestableTomcatTask>(){

            public void execute(StartTestableTomcatTask startTestableTomcatTask) {
                Object checkTimeout = GradleUtil.getProperty((ExtensionAware)project, (String)"timeout.app.server.wait");
                if (checkTimeout != null) {
                    startTestableTomcatTask.setCheckTimeout((long)(GradleUtil.toInteger((Object)checkTimeout) * 1000));
                }
                startTestableTomcatTask.setExecutable((Object)new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return tomcatAppServer.getStartExecutable();
                    }
                });
                startTestableTomcatTask.setExecutableArgs(new Object[]{new Callable<List<String>>(){

                    @Override
                    public List<String> call() throws Exception {
                        String argLine = System.getProperty("app.server.start.executable.arg.line");
                        if (Validator.isNotNull((String)argLine)) {
                            return Arrays.asList(argLine.split(" "));
                        }
                        return tomcatAppServer.getStartExecutableArgs();
                    }
                }});
            }
        });
    }

    private void _configureTaskStopTestableTomcatProvider(TaskProvider<StopAppServerTask> stopTestableTomcatTaskProvider, final TomcatAppServer tomcatAppServer) {
        stopTestableTomcatTaskProvider.configure((Action)new Action<StopAppServerTask>(){

            public void execute(StopAppServerTask stopAppServerTask) {
                stopAppServerTask.setExecutable((Object)new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return tomcatAppServer.getStopExecutable();
                    }
                });
                stopAppServerTask.setExecutableArgs(new Object[]{new Callable<List<String>>(){

                    @Override
                    public List<String> call() throws Exception {
                        return tomcatAppServer.getStopExecutableArgs();
                    }
                }});
            }
        });
    }
}

