Liferay.Loader.define("layout-admin-web@4.0.79/js/friendly_url_history/FriendlyURLHistoryModal", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/list', '@frontend-taglib-clay$clayui/loading-indicator', '@frontend-taglib-clay$clayui/modal', 'frontend-js-react-web', 'frontend-js-web', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', './LanguageSelector'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _list = _interopRequireDefault(require("@frontend-taglib-clay$clayui/list"));

    var _loadingIndicator = _interopRequireDefault(require("@frontend-taglib-clay$clayui/loading-indicator"));

    var _modal = _interopRequireDefault(require("@frontend-taglib-clay$clayui/modal"));

    var _frontendJsReactWeb = require("frontend-js-react-web");

    var _frontendJsWeb = require("frontend-js-web");

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _LanguageSelector = _interopRequireDefault(require("./LanguageSelector"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function logError(error) {}

    var showToastError = function showToastError() {
      (0, _frontendJsWeb.openToast)({
        message: Liferay.Language.get('an-unexpected-error-occurred'),
        type: 'danger'
      });
    };

    var FriendlyURLHistoryModal = function FriendlyURLHistoryModal(_ref) {
      var defaultLanguageId = _ref.defaultLanguageId,
          deleteFriendlyURLEntryLocalizationURL = _ref.deleteFriendlyURLEntryLocalizationURL,
          friendlyURLEntryLocalizationsURL = _ref.friendlyURLEntryLocalizationsURL,
          initialLanguageId = _ref.initialLanguageId,
          observer = _ref.observer,
          portletNamespace = _ref.portletNamespace,
          restoreFriendlyURLEntryLocalizationURL = _ref.restoreFriendlyURLEntryLocalizationURL;

      var _useState = (0, _react.useState)(),
          _useState2 = _slicedToArray(_useState, 2),
          languageId = _useState2[0],
          setLanguageId = _useState2[1];

      var _useState3 = (0, _react.useState)(true),
          _useState4 = _slicedToArray(_useState3, 2),
          loading = _useState4[0],
          setLoading = _useState4[1];

      var _useState5 = (0, _react.useState)({}),
          _useState6 = _slicedToArray(_useState5, 2),
          friendlyURLEntryLocalizations = _useState6[0],
          setFriendlyURLEntryLocalizations = _useState6[1];

      var _useState7 = (0, _react.useState)([]),
          _useState8 = _slicedToArray(_useState7, 2),
          availableLanguages = _useState8[0],
          setAvailableLanguages = _useState8[1];

      var isMounted = (0, _frontendJsReactWeb.useIsMounted)();
      var getFriendlyUrlLocalizations = (0, _react.useCallback)(function () {
        (0, _frontendJsWeb.fetch)(friendlyURLEntryLocalizationsURL).then(function (response) {
          return response.json();
        }).then(function (response) {
          if (isMounted()) {
            setAvailableLanguages(Object.entries(response).reduce(function (acc, _ref2) {
              var _ref3 = _slicedToArray(_ref2, 2),
                  language = _ref3[0],
                  current = _ref3[1].current;

              if (current && current.urlTitle) {
                acc.push(language);
              }

              return acc;
            }, []));
            setFriendlyURLEntryLocalizations(response);
          }
        }).catch(function (error) {
          logError(error);
          showToastError();
        });
      }, [friendlyURLEntryLocalizationsURL, isMounted]);
      (0, _react.useEffect)(function () {
        getFriendlyUrlLocalizations();
      }, [getFriendlyUrlLocalizations]);
      (0, _react.useEffect)(function () {
        if (loading) {
          var selectedLanguageId;

          if (friendlyURLEntryLocalizations[initialLanguageId] && availableLanguages.includes(initialLanguageId)) {
            selectedLanguageId = initialLanguageId;
          } else if (friendlyURLEntryLocalizations[defaultLanguageId] && availableLanguages.includes(defaultLanguageId)) {
            selectedLanguageId = defaultLanguageId;
          } else {
            selectedLanguageId = availableLanguages[0];
          }

          setLanguageId(selectedLanguageId);
        }
      }, [availableLanguages, defaultLanguageId, friendlyURLEntryLocalizations, initialLanguageId, loading]);
      (0, _react.useEffect)(function () {
        if (loading && friendlyURLEntryLocalizations && languageId && friendlyURLEntryLocalizations[languageId]) {
          setLoading(false);
        }
      }, [friendlyURLEntryLocalizations, loading, languageId]);
      var sendRequest = (0, _react.useCallback)(function (url, friendlyURLEntryId) {
        var _objectToFormData;

        return (0, _frontendJsWeb.fetch)(url, {
          body: (0, _frontendJsWeb.objectToFormData)((_objectToFormData = {}, _defineProperty(_objectToFormData, "".concat(portletNamespace, "friendlyURLEntryId"), friendlyURLEntryId), _defineProperty(_objectToFormData, "".concat(portletNamespace, "languageId"), languageId), _objectToFormData)),
          method: 'POST'
        }).then(function (response) {
          return response.json();
        }).catch(function (error) {
          logError(error);
          showToastError();
        });
      }, [languageId, portletNamespace]);
      var handleDeleteFriendlyUrl = (0, _react.useCallback)(function (deleteFriendlyURLEntryId) {
        sendRequest(deleteFriendlyURLEntryLocalizationURL, deleteFriendlyURLEntryId).then(function () {
          var _ref4 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
              success = _ref4.success;

          if (success) {
            setFriendlyURLEntryLocalizations(function (friendlyURLEntryLocalizations) {
              return _objectSpread(_objectSpread({}, friendlyURLEntryLocalizations), {}, _defineProperty({}, languageId, _objectSpread(_objectSpread({}, friendlyURLEntryLocalizations[languageId]), {}, {
                history: friendlyURLEntryLocalizations[languageId].history.filter(function (_ref5) {
                  var friendlyURLEntryId = _ref5.friendlyURLEntryId;
                  return friendlyURLEntryId != deleteFriendlyURLEntryId;
                })
              })));
            });
          } else {
            showToastError();
          }
        });
      }, [deleteFriendlyURLEntryLocalizationURL, languageId, sendRequest]);
      var handleRestoreFriendlyUrl = (0, _react.useCallback)(function (restoreFriendlyUrlEntryId, urlTitle) {
        sendRequest(restoreFriendlyURLEntryLocalizationURL, restoreFriendlyUrlEntryId).then(function () {
          var _ref6 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
              success = _ref6.success;

          if (isMounted() && success) {
            getFriendlyUrlLocalizations();
            var inputComponent = Liferay.component("".concat(portletNamespace, "friendlyURL"));

            if (inputComponent.getSelectedLanguageId() === languageId) {
              inputComponent.updateInput(urlTitle);
            } else {
              inputComponent.updateInputLanguage(urlTitle, languageId);
            }
          } else {
            showToastError();
          }
        });
      }, [getFriendlyUrlLocalizations, isMounted, languageId, portletNamespace, restoreFriendlyURLEntryLocalizationURL, sendRequest]);
      return (/*#__PURE__*/_react.default.createElement(_modal.default, {
          className: "portlet-layouts-admin-url-history-modal",
          observer: observer,
          size: "md"
        }, /*#__PURE__*/_react.default.createElement(_modal.default.Header, null, Liferay.Language.get('history')), /*#__PURE__*/_react.default.createElement(_modal.default.Body, null, loading ? /*#__PURE__*/_react.default.createElement(_loadingIndicator.default, null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
          className: "language-selector-container"
        }, /*#__PURE__*/_react.default.createElement(_LanguageSelector.default, {
          defaultLanguageId: defaultLanguageId,
          languageIds: availableLanguages,
          onChange: function onChange(value) {
            setLanguageId(value);
          },
          selectedLanguageId: languageId
        })), /*#__PURE__*/_react.default.createElement("div", {
          className: "active-url"
        }, /*#__PURE__*/_react.default.createElement("div", {
          className: "active-url-tite"
        }, Liferay.Language.get('active-url')), /*#__PURE__*/_react.default.createElement("p", {
          className: "active-url-text"
        }, friendlyURLEntryLocalizations[languageId].current.urlTitle)), /*#__PURE__*/_react.default.createElement(_list.default, {
          className: "show-quick-actions-one-line",
          showQuickActionsOnHover: true
        }, friendlyURLEntryLocalizations[languageId].history.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_list.default.Header, null, Liferay.Language.get('old-friendly-urls')), friendlyURLEntryLocalizations[languageId].history.map(function (_ref7) {
          var friendlyURLEntryId = _ref7.friendlyURLEntryId,
              urlTitle = _ref7.urlTitle;
          return (/*#__PURE__*/_react.default.createElement(_list.default.Item, {
              flex: true,
              key: friendlyURLEntryId
            }, /*#__PURE__*/_react.default.createElement(_list.default.ItemField, {
              expand: true
            }, /*#__PURE__*/_react.default.createElement(_list.default.ItemText, {
              className: "text-truncate"
            }, urlTitle)), /*#__PURE__*/_react.default.createElement(_list.default.ItemField, null, /*#__PURE__*/_react.default.createElement(_list.default.QuickActionMenu, null, /*#__PURE__*/_react.default.createElement(_list.default.QuickActionMenu.Item, {
              className: "lfr-portal-tooltip",
              "data-title": Liferay.Language.get('restore-url'),
              onClick: function onClick() {
                handleRestoreFriendlyUrl(friendlyURLEntryId, urlTitle);
              },
              symbol: "reload"
            }), /*#__PURE__*/_react.default.createElement(_list.default.QuickActionMenu.Item, {
              className: "lfr-portal-tooltip",
              "data-title": Liferay.Language.get('forget-url'),
              onClick: function onClick() {
                handleDeleteFriendlyUrl(friendlyURLEntryId);
              },
              symbol: "times-circle"
            }))))
          );
        }))))))
      );
    };

    var _default = FriendlyURLHistoryModal;
    exports.default = _default;
    //# sourceMappingURL=FriendlyURLHistoryModal.js.map
  }
});
//# sourceMappingURL=FriendlyURLHistoryModal.js.map