Liferay.Loader.define("layout-admin-web@4.0.79/js/layout/Layout", ['module', 'exports', 'require', 'frontend-js-web', 'frontend-js-react-web$react', '../breadcrumbs/Breadcrumbs', '../miller_columns/MillerColumns', './actionHandlers'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = _default;

    var _frontendJsWeb = require("frontend-js-web");

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _Breadcrumbs = _interopRequireDefault(require("../breadcrumbs/Breadcrumbs"));

    var _MillerColumns = _interopRequireDefault(require("../miller_columns/MillerColumns"));

    var _actionHandlers = _interopRequireDefault(require("./actionHandlers"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
    }

    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr)) {
        for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
          arr2[i] = arr[i];
        }return arr2;
      }
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var Layout = function Layout(_ref) {
      var getItemChildrenURL = _ref.getItemChildrenURL,
          initialBreadcrumbEntries = _ref.initialBreadcrumbEntries,
          initialLayoutColumns = _ref.initialLayoutColumns,
          languageDirection = _ref.languageDirection,
          languageId = _ref.languageId,
          moveItemURL = _ref.moveItemURL,
          namespace = _ref.namespace,
          searchContainerId = _ref.searchContainerId;
      var layoutRef = (0, _react.useRef)();
      var searchContainer = (0, _react.useRef)();

      var _useState = (0, _react.useState)(initialBreadcrumbEntries),
          _useState2 = _slicedToArray(_useState, 2),
          breadcrumbEntries = _useState2[0],
          setBreadcrumbEntries = _useState2[1];

      var _useState3 = (0, _react.useState)(initialLayoutColumns),
          _useState4 = _slicedToArray(_useState3, 2),
          layoutColumns = _useState4[0],
          setLayoutColumns = _useState4[1];

      var _useState5 = (0, _react.useState)(),
          _useState6 = _slicedToArray(_useState5, 2),
          searchContainerElement = _useState6[0],
          setSearchContainerElement = _useState6[1];

      (0, _react.useEffect)(function () {
        var A = new AUI();
        A.use('liferay-search-container', 'liferay-search-container-select', function (A) {
          var plugins = [{
            cfg: {
              rowSelector: '.miller-columns-item'
            },
            fn: A.Plugin.SearchContainerSelect
          }];

          if (searchContainer.current) {
            searchContainer.current.destroy();
          }

          searchContainer.current = new Liferay.SearchContainer({
            contentBox: layoutRef.current,
            id: "".concat(namespace).concat(searchContainerId),
            plugins: plugins
          });
          setSearchContainerElement(searchContainer.current);
        });
      }, [namespace, searchContainerId]);

      return (/*#__PURE__*/_react.default.createElement("div", {
          ref: layoutRef
        }, /*#__PURE__*/_react.default.createElement(_Breadcrumbs.default, {
          entries: breadcrumbEntries
        }), /*#__PURE__*/_react.default.createElement(_MillerColumns.default, {
          actionHandlers: _actionHandlers.default,
          initialColumns: layoutColumns,
          namespace: namespace,
          onColumnsChange: function updateBreadcrumbs(columns) {
            var newBreadcrumbEntries = [breadcrumbEntries[0]];

            for (var i = 0; i < columns.length; i++) {
              var item = columns[i].items.find(function (item) {
                return item.active;
              });

              if (item) {
                newBreadcrumbEntries.push({
                  title: item.title,
                  url: item.url
                });
              }
            }

            setBreadcrumbEntries(newBreadcrumbEntries);
          },
          onItemMove: function saveData(movedItems, parentItemId) {
            var formData = new FormData();
            var activeItems = layoutColumns.reduce(function (acc, column) {
              return [].concat(_toConsumableArray(acc), _toConsumableArray(column.filter(function (item) {
                return item.active;
              })));
            }, []);
            var activeItem = activeItems[activeItems.length - 1];
            formData.append("".concat(namespace, "plids"), JSON.stringify(movedItems));
            formData.append("".concat(namespace, "parentPlid"), parentItemId);

            if (activeItem) {
              formData.append("".concat(namespace, "selPlid"), activeItem.id);
            }

            (0, _frontendJsWeb.fetch)(moveItemURL, {
              body: formData,
              method: 'POST'
            }).then(function (response) {
              return response.json();
            }).then(function (_ref3) {
              var errorMessage = _ref3.errorMessage,
                  updatedLayoutColumns = _ref3.layoutColumns;

              if (errorMessage) {
                (0, _frontendJsWeb.openToast)({
                  message: errorMessage,
                  type: 'danger'
                });
              }

              if (updatedLayoutColumns) {
                setLayoutColumns(updatedLayoutColumns);
              }
            });
          },
          onItemStayHover: function getItemChildren(parentId) {
            var formData = new FormData();
            formData.append("".concat(namespace, "plid"), parentId);
            (0, _frontendJsWeb.fetch)(getItemChildrenURL, {
              body: formData,
              method: 'POST'
            }).then(function (response) {
              return response.json();
            }).then(function (_ref2) {
              var children = _ref2.children;
              var newLayoutColumns = [];

              for (var i = 0; i < layoutColumns.length; i++) {
                var column = layoutColumns[i];

                if (!column.some(function (item) {
                  return item.id === parentId;
                })) {
                  newLayoutColumns.push(column);
                } else {
                  var _ret = function () {
                    var newColumn = [];
                    column.forEach(function (item) {
                      if (item.active) {
                        newColumn.push(_objectSpread(_objectSpread({}, item), {}, {
                          active: false
                        }));
                      } else if (item.id === parentId) {
                        newColumn.push(_objectSpread(_objectSpread({}, item), {}, {
                          active: true
                        }));
                      } else {
                        newColumn.push(_objectSpread({}, item));
                      }
                    });
                    newLayoutColumns.push(newColumn);
                    return "break";
                  }();

                  if (_ret === "break") break;
                }
              }

              newLayoutColumns.push(children);
              setLayoutColumns(newLayoutColumns);
            }).catch();
          },
          rtl: languageDirection[languageId] === 'rtl',
          searchContainer: searchContainerElement
        }))
      );
    };

    function _default(_ref4) {
      var namespace = _ref4.context.namespace,
          _ref4$props = _ref4.props,
          breadcrumbEntries = _ref4$props.breadcrumbEntries,
          getItemChildrenURL = _ref4$props.getItemChildrenURL,
          languageDirection = _ref4$props.languageDirection,
          languageId = _ref4$props.languageId,
          layoutColumns = _ref4$props.layoutColumns,
          moveItemURL = _ref4$props.moveItemURL,
          searchContainerId = _ref4$props.searchContainerId;
      return (/*#__PURE__*/_react.default.createElement(Layout, {
          getItemChildrenURL: getItemChildrenURL,
          initialBreadcrumbEntries: breadcrumbEntries,
          initialLayoutColumns: layoutColumns,
          languageDirection: languageDirection,
          languageId: languageId,
          moveItemURL: moveItemURL,
          namespace: namespace,
          searchContainerId: searchContainerId
        })
      );
    }
    //# sourceMappingURL=Layout.js.map
  }
});
//# sourceMappingURL=Layout.js.map