Liferay.Loader.define("layout-admin-web@4.0.79/js/layout/actionHandlers", ['module', 'exports', 'require', 'frontend-js-web'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _frontendJsWeb = require("frontend-js-web");

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var actionHandlers = {
      copyLayout: function copyLayout(_ref) {
        var actionURL = _ref.actionURL,
            namespace = _ref.namespace;
        (0, _frontendJsWeb.openModal)({
          id: "".concat(namespace, "addLayoutDialog"),
          title: Liferay.Language.get('copy-page'),
          url: actionURL
        });
      },
      delete: function _delete(_ref2) {
        var actionURL = _ref2.actionURL,
            hasChildren = _ref2.hasChildren;
        var deleteMessage = Liferay.Language.get('are-you-sure-you-want-to-delete-this-page');

        if (hasChildren) {
          deleteMessage = Liferay.Util.sub(Liferay.Language.get('this-page-has-child-pages-that-will-also-be-removed-are-you-sure-you-want-to-delete-this-page'), hasChildren);
        }

        if (confirm(deleteMessage)) {
          Liferay.Util.navigate(actionURL);
        }
      },
      discardDraft: function discardDraft(_ref3) {
        var actionURL = _ref3.actionURL;
        var discardDraftMessage = Liferay.Language.get('are-you-sure-you-want-to-discard-current-draft-and-apply-latest-published-changes');

        if (confirm(discardDraftMessage)) {
          Liferay.Util.navigate(actionURL);
        }
      },
      permissions: function permissions(_ref4) {
        var actionURL = _ref4.actionURL;
        (0, _frontendJsWeb.openModal)({
          title: Liferay.Language.get('permissions'),
          url: actionURL
        });
      },
      viewCollectionItems: function viewCollectionItems(_ref5) {
        var actionURL = _ref5.actionURL,
            namespace = _ref5.namespace;
        (0, _frontendJsWeb.openModal)({
          id: "".concat(namespace, "viewCollectionItemsDialog"),
          title: Liferay.Language.get('collection-items'),
          url: actionURL
        });
      }
    };
    var _default = actionHandlers;
    exports.default = _default;
    //# sourceMappingURL=actionHandlers.js.map
  }
});
//# sourceMappingURL=actionHandlers.js.map