/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.buffer;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.messaging.proxy.ProxyModeThreadLocal;
import com.liferay.portal.kernel.messaging.proxy.ProxyModeThreadLocalCloseable;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.HashUtil;
import com.liferay.portal.search.buffer.NoAutoCommitIndexer;
import java.lang.reflect.Method;
import java.util.Objects;

public class IndexerRequest {
    private final ClassedModel _classedModel;
    private final boolean _forceSync;
    private final Indexer<?> _indexer;
    private final Method _method;
    private final String _modelClassName;
    private final Long _modelPrimaryKey;

    public IndexerRequest(Method method, ClassedModel classedModel, Indexer<?> indexer) {
        this._method = method;
        this._classedModel = classedModel;
        this._indexer = new NoAutoCommitIndexer(indexer);
        this._forceSync = ProxyModeThreadLocal.isForceSync();
        this._modelClassName = classedModel.getModelClassName();
        this._modelPrimaryKey = (Long)this._classedModel.getPrimaryKeyObj();
    }

    public IndexerRequest(Method method, Indexer<?> indexer, String modelClassName, Long modelPrimaryKey) {
        this._method = method;
        this._modelClassName = modelClassName;
        this._modelPrimaryKey = modelPrimaryKey;
        this._indexer = new NoAutoCommitIndexer(indexer);
        this._classedModel = null;
        this._forceSync = ProxyModeThreadLocal.isForceSync();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IndexerRequest)) {
            return false;
        }
        IndexerRequest indexerRequest = (IndexerRequest)object;
        return Objects.equals(this._indexer, indexerRequest._indexer) && (Objects.equals(this._method, indexerRequest._method) || Objects.equals(this._method.getName(), indexerRequest._method.getName()) && Objects.equals(this._modelPrimaryKey, indexerRequest._modelPrimaryKey)) && Objects.equals(this._modelClassName, indexerRequest._modelClassName);
    }

    public void execute() throws Exception {
        try (ProxyModeThreadLocalCloseable proxyModeThreadLocalCloseable = new ProxyModeThreadLocalCloseable();){
            ProxyModeThreadLocal.setForceSync((boolean)this._forceSync);
            Class<?>[] parameterTypes = this._method.getParameterTypes();
            if (parameterTypes.length == 1) {
                this._method.invoke(this._indexer, this._classedModel);
            } else {
                this._method.invoke(this._indexer, this._modelClassName, this._modelPrimaryKey);
            }
        }
    }

    public String getSearchEngineId() {
        return this._indexer.getSearchEngineId();
    }

    public int hashCode() {
        int hashCode = HashUtil.hash((int)0, (Object)this._method.getName());
        hashCode = HashUtil.hash((int)hashCode, (Object)this._modelClassName);
        hashCode = HashUtil.hash((int)hashCode, (Object)this._modelPrimaryKey);
        return hashCode;
    }

    public String toString() {
        StringBundler sb = new StringBundler(13);
        sb.append("{classModel=");
        sb.append((Object)this._classedModel);
        sb.append(", forceSync=");
        sb.append(this._forceSync);
        sb.append(", indexer=");
        sb.append(ClassUtil.getClassName(this._indexer));
        sb.append(", method=");
        sb.append((Object)this._method);
        sb.append(", modelClassName=");
        sb.append(this._modelClassName);
        sb.append(", modelPrimaryKey=");
        sb.append((Object)this._modelPrimaryKey);
        sb.append("}");
        return sb.toString();
    }
}

