/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.suggest;

import com.liferay.petra.nio.CharsetEncoderUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.suggest.SpellCheckIndexWriter;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.Digester;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.InputStream;
import java.net.URL;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.util.List;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseSpellCheckIndexWriter
implements SpellCheckIndexWriter {
    protected Digester digester;
    @Reference
    protected GroupLocalService groupLocalService;
    @Reference
    protected Props props;
    private static final Log _log = LogFactoryUtil.getLog(BaseSpellCheckIndexWriter.class);
    private int _querySuggestionMaxNGramLength = 50;

    public void indexKeyword(SearchContext searchContext, float weight, String keywordType) throws SearchException {
        if (!keywordType.equals("querySuggestion") && !keywordType.equals("spellChecker")) {
            throw new IllegalArgumentException("Invalid keyword type " + keywordType);
        }
        long groupId = 0L;
        long[] groupIds = searchContext.getGroupIds();
        if (groupIds != null && groupIds.length > 0) {
            groupId = groupIds[0];
        }
        String keywordFieldName = "keywordSearch";
        String typeFieldValue = "querySuggestion";
        int maxNGramLength = this._querySuggestionMaxNGramLength;
        if (keywordType.equals("spellChecker")) {
            keywordFieldName = "spellCheckWord";
            typeFieldValue = "spellChecker";
            maxNGramLength = 0;
        }
        try {
            this.indexKeyword(searchContext, groupId, searchContext.getLanguageId(), searchContext.getKeywords(), weight, keywordFieldName, typeFieldValue, maxNGramLength);
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
    }

    public void indexQuerySuggestionDictionaries(SearchContext searchContext) throws SearchException {
        try {
            for (String languageId : this.getSupportedLocales()) {
                this.indexKeywords(searchContext, languageId, "index.search.query.suggestion.dictionary", "keywordSearch", "querySuggestion", this._querySuggestionMaxNGramLength);
            }
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
    }

    public void indexQuerySuggestionDictionary(SearchContext searchContext) throws SearchException {
        try {
            this.indexKeywords(searchContext, searchContext.getLanguageId(), "index.search.query.suggestion.dictionary", "keywordSearch", "querySuggestion", this._querySuggestionMaxNGramLength);
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
    }

    public void indexSpellCheckerDictionaries(SearchContext searchContext) throws SearchException {
        try {
            for (String languageId : this.getSupportedLocales()) {
                this.indexKeywords(searchContext, languageId, "index.search.spell.checker.dictionary", "spellCheckWord", "spellChecker", 0);
            }
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
    }

    public void indexSpellCheckerDictionary(SearchContext searchContext) throws SearchException {
        try {
            this.indexKeywords(searchContext, searchContext.getLanguageId(), "index.search.spell.checker.dictionary", "spellCheckWord", "spellChecker", 0);
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
    }

    public void setQuerySuggestionMaxNGramLength(int querySuggestionMaxNGramLength) {
        this._querySuggestionMaxNGramLength = querySuggestionMaxNGramLength;
    }

    protected Digester getDigester() {
        if (this.digester != null) {
            return this.digester;
        }
        return DigesterUtil.getDigester();
    }

    protected URL getResource(String name) {
        Thread thread = Thread.currentThread();
        ClassLoader contextClassLoader = thread.getContextClassLoader();
        URL url = contextClassLoader.getResource(name);
        if (url == null) {
            ClassLoader portalClassLoader = PortalClassLoaderUtil.getClassLoader();
            url = portalClassLoader.getResource(name);
        }
        return url;
    }

    protected String[] getSupportedLocales() {
        return StringUtil.split((String)this.props.get("index.search.spell.checker.supported.locales"));
    }

    protected String getUID(long companyId, String keywordFieldName, String languageId, String word, String ... parameters) {
        StringBundler uidSB = new StringBundler(5);
        uidSB.append(String.valueOf(companyId));
        uidSB.append("_");
        uidSB.append(keywordFieldName);
        uidSB.append("_");
        int length = 5;
        if (parameters != null) {
            length += 2 * parameters.length;
        }
        try {
            Digester digester = this.getDigester();
            CharsetEncoder charsetEncoder = CharsetEncoderUtil.getCharsetEncoder((String)"UTF-8");
            StringBundler keySB = new StringBundler(length);
            keySB.append(languageId);
            keySB.append("_");
            keySB.append(word);
            keySB.append("_");
            keySB.append(StringUtil.toLowerCase((String)word));
            if (parameters != null) {
                for (String parameter : parameters) {
                    keySB.append(parameter);
                    keySB.append("_");
                }
            }
            String key = keySB.toString();
            byte[] bytes = digester.digestRaw("MD5", charsetEncoder.encode(CharBuffer.wrap(key)));
            uidSB.append(Base64.encode((byte[])bytes));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return uidSB.toString();
    }

    protected abstract void indexKeyword(SearchContext var1, long var2, String var4, String var5, float var6, String var7, String var8, int var9) throws Exception;

    protected abstract void indexKeywords(SearchContext var1, long var2, String var4, InputStream var5, String var6, String var7, int var8) throws Exception;

    protected void indexKeywords(SearchContext searchContext, long groupId, String languageId, String[] dictionaryFileNames, String keywordFieldName, String typeFieldValue, int maxNGramLength) throws Exception {
        for (String dictionaryFileName : dictionaryFileNames) {
            URL url;
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Start indexing dictionary for " + dictionaryFileName));
            }
            if ((url = this.getResource(dictionaryFileName)) == null) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to read " + dictionaryFileName));
                continue;
            }
            try (InputStream inputStream = url.openStream();){
                this.indexKeywords(searchContext, groupId, languageId, inputStream, keywordFieldName, typeFieldValue, maxNGramLength);
            }
            if (!_log.isInfoEnabled()) continue;
            _log.info((Object)("Finished indexing dictionary for " + dictionaryFileName));
        }
    }

    protected void indexKeywords(SearchContext searchContext, String languageId, String propsKey, String keywordFieldName, String typeFieldValue, int maxNGramLength) throws Exception {
        String[] dictionaryFileNames = this.props.getArray(propsKey, new Filter(languageId));
        this.indexKeywords(searchContext, 0L, languageId, dictionaryFileNames, keywordFieldName, typeFieldValue, maxNGramLength);
        List groups = this.groupLocalService.getLiveGroups();
        for (Group group : groups) {
            Object[] groupDictionaryFileNames = this.props.getArray(propsKey, new Filter(languageId, String.valueOf(group.getGroupId())));
            if (ArrayUtil.isEmpty((Object[])groupDictionaryFileNames)) continue;
            this.indexKeywords(searchContext, group.getGroupId(), languageId, (String[])groupDictionaryFileNames, keywordFieldName, typeFieldValue, maxNGramLength);
        }
    }
}

