/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap.internal;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.ldap.LDAPSettings;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.ldap.PortalLDAP;
import com.liferay.portal.security.ldap.configuration.ConfigurationProvider;
import com.liferay.portal.security.ldap.configuration.LDAPServerConfiguration;
import com.liferay.portal.security.ldap.configuration.SystemLDAPConfiguration;
import com.liferay.portal.security.ldap.internal.UserImportTransactionThreadLocal;
import com.liferay.portal.security.ldap.validator.LDAPFilterValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import javax.naming.ldap.Rdn;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(configurationPid={"com.liferay.portal.security.ldap.configuration.LDAPConfiguration"}, immediate=true, service={PortalLDAP.class})
public class DefaultPortalLDAP
implements PortalLDAP {
    private static final Log _log = LogFactoryUtil.getLog(DefaultPortalLDAP.class);
    private String _companySecurityAuthType;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile LDAPFilterValidator _ldapFilterValidator;
    private ConfigurationProvider<LDAPServerConfiguration> _ldapServerConfigurationProvider;
    private LDAPSettings _ldapSettings;
    private ConfigurationProvider<SystemLDAPConfiguration> _systemLDAPConfigurationProvider;

    @Override
    public String encodeFilterAttribute(String attribute, boolean rdnEscape) {
        String[] oldString = new String[]{"\\", "*", "(", ")", "\u0000"};
        String[] newString = new String[]{"\\5c", "\\2a", "\\28", "\\29", "\\00"};
        if (rdnEscape) {
            ArrayUtil.remove((String[])oldString, (String)"\\");
            ArrayUtil.remove((String[])newString, (String)"\\5c");
        }
        String newAttribute = StringUtil.replace((String)attribute, (String[])oldString, (String[])newString);
        if (rdnEscape) {
            newAttribute = Rdn.escapeValue(newAttribute);
        }
        return newAttribute;
    }

    @Override
    public LdapContext getContext(long ldapServerId, long companyId) throws Exception {
        LDAPServerConfiguration ldapServerConfiguration = this._ldapServerConfigurationProvider.getConfiguration(companyId, ldapServerId);
        String baseProviderURL = ldapServerConfiguration.baseProviderURL();
        String securityPrincipal = ldapServerConfiguration.securityPrincipal();
        String securityCredential = ldapServerConfiguration.securityCredential();
        return this.getContext(companyId, baseProviderURL, securityPrincipal, securityCredential);
    }

    @Override
    public LdapContext getContext(long companyId, String providerURL, String principal, String credentials) throws Exception {
        InitialLdapContext ldapContext;
        block5: {
            String[] connectionProperties;
            SystemLDAPConfiguration systemLDAPConfiguration = this._systemLDAPConfigurationProvider.getConfiguration(companyId);
            Properties environmentProperties = new Properties();
            environmentProperties.put("java.naming.factory.initial", systemLDAPConfiguration.factoryInitial());
            environmentProperties.put("java.naming.provider.url", providerURL);
            environmentProperties.put("java.naming.referral", systemLDAPConfiguration.referral());
            environmentProperties.put("java.naming.security.credentials", credentials);
            environmentProperties.put("java.naming.security.principal", principal);
            for (String connectionProperty : connectionProperties = systemLDAPConfiguration.connectionProperties()) {
                String[] connectionPropertySplit = StringUtil.split((String)connectionProperty, (char)'=');
                if (connectionPropertySplit.length != 2 && _log.isWarnEnabled()) {
                    _log.warn((Object)("Invalid LDAP connection property: " + connectionProperty));
                    continue;
                }
                environmentProperties.put(connectionPropertySplit[0], connectionPropertySplit[1]);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)MapUtil.toString((Map)environmentProperties, null, (String)"java.naming.security.credentials"));
            }
            ldapContext = null;
            try {
                ldapContext = new InitialLdapContext(environmentProperties, null);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block5;
                _log.warn((Object)"Unable to bind to the LDAP server", (Throwable)e);
            }
        }
        return ldapContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Binding getGroup(long ldapServerId, long companyId, String groupName) throws Exception {
        LDAPServerConfiguration ldapServerConfiguration = this._ldapServerConfigurationProvider.getConfiguration(companyId, ldapServerId);
        LdapContext ldapContext = this.getContext(ldapServerId, companyId);
        NamingEnumeration<SearchResult> enu = null;
        try {
            if (ldapContext == null) {
                Binding binding = null;
                return binding;
            }
            String groupsDN = ldapServerConfiguration.groupsDN();
            String groupFilter = ldapServerConfiguration.groupSearchFilter();
            this._ldapFilterValidator.validate(groupFilter, "SystemLDAPConfiguration.groupSearchFilter");
            StringBundler sb = new StringBundler(Validator.isNotNull((String)groupFilter) ? 9 : 5);
            if (Validator.isNotNull((String)groupFilter)) {
                sb.append("(");
                sb.append("&");
            }
            sb.append("(");
            Properties groupMappings = this._ldapSettings.getGroupMappings(ldapServerId, companyId);
            sb.append(groupMappings.getProperty("groupName"));
            sb.append("=");
            sb.append(this.encodeFilterAttribute(groupName, true));
            sb.append(")");
            if (Validator.isNotNull((String)groupFilter)) {
                sb.append(groupFilter);
                sb.append(")");
            }
            SearchControls searchControls = new SearchControls(2, 1L, 0, null, false, false);
            enu = ldapContext.search(groupsDN, sb.toString(), searchControls);
            if (enu.hasMoreElements()) {
                Binding binding = (Binding)enu.nextElement();
                return binding;
            }
            Binding binding = null;
            return binding;
        }
        finally {
            if (enu != null) {
                enu.close();
            }
            if (ldapContext != null) {
                ldapContext.close();
            }
        }
    }

    @Override
    public Attributes getGroupAttributes(long ldapServerId, long companyId, LdapContext ldapContext, String fullDistinguishedName) throws Exception {
        return this.getGroupAttributes(ldapServerId, companyId, ldapContext, fullDistinguishedName, false);
    }

    @Override
    public Attributes getGroupAttributes(long ldapServerId, long companyId, LdapContext ldapContext, String fullDistinguishedName, boolean includeReferenceAttributes) throws Exception {
        Properties groupMappings = this._ldapSettings.getGroupMappings(ldapServerId, companyId);
        ArrayList<String> mappedGroupAttributeIds = new ArrayList<String>();
        mappedGroupAttributeIds.add(groupMappings.getProperty("groupName"));
        mappedGroupAttributeIds.add(groupMappings.getProperty("description"));
        if (includeReferenceAttributes) {
            mappedGroupAttributeIds.add(groupMappings.getProperty("user"));
        }
        Attributes attributes = this._getAttributes(ldapContext, fullDistinguishedName, mappedGroupAttributeIds.toArray(new String[0]));
        if (_log.isDebugEnabled()) {
            if (attributes == null || attributes.size() == 0) {
                _log.debug((Object)("No LDAP group attributes found for " + fullDistinguishedName));
            } else {
                for (String attributeId : mappedGroupAttributeIds) {
                    Attribute attribute = attributes.get(attributeId);
                    if (attribute == null) continue;
                    _log.debug((Object)("LDAP group attribute " + attribute.toString()));
                }
            }
        }
        return attributes;
    }

    @Override
    public byte[] getGroups(long companyId, LdapContext ldapContext, byte[] cookie, int maxResults, String baseDN, String groupFilter, List<SearchResult> searchResults) throws Exception {
        return this.searchLDAP(companyId, ldapContext, cookie, maxResults, baseDN, groupFilter, null, searchResults);
    }

    @Override
    public byte[] getGroups(long companyId, LdapContext ldapContext, byte[] cookie, int maxResults, String baseDN, String groupFilter, String[] attributeIds, List<SearchResult> searchResults) throws Exception {
        return this.searchLDAP(companyId, ldapContext, cookie, maxResults, baseDN, groupFilter, attributeIds, searchResults);
    }

    @Override
    public byte[] getGroups(long ldapServerId, long companyId, LdapContext ldapContext, byte[] cookie, int maxResults, List<SearchResult> searchResults) throws Exception {
        LDAPServerConfiguration ldapServerConfiguration = this._ldapServerConfigurationProvider.getConfiguration(companyId, ldapServerId);
        String baseDN = ldapServerConfiguration.baseDN();
        String groupSearchFilter = ldapServerConfiguration.groupSearchFilter();
        return this.getGroups(companyId, ldapContext, cookie, maxResults, baseDN, groupSearchFilter, searchResults);
    }

    @Override
    public byte[] getGroups(long ldapServerId, long companyId, LdapContext ldapContext, byte[] cookie, int maxResults, String[] attributeIds, List<SearchResult> searchResults) throws Exception {
        LDAPServerConfiguration ldapServerConfiguration = this._ldapServerConfigurationProvider.getConfiguration(companyId, ldapServerId);
        String baseDN = ldapServerConfiguration.baseDN();
        String groupSearchFilter = ldapServerConfiguration.groupSearchFilter();
        return this.getGroups(companyId, ldapContext, cookie, maxResults, baseDN, groupSearchFilter, attributeIds, searchResults);
    }

    @Override
    public String getGroupsDN(long ldapServerId, long companyId) throws Exception {
        LDAPServerConfiguration ldapServerConfiguration = this._ldapServerConfigurationProvider.getConfiguration(companyId, ldapServerId);
        return ldapServerConfiguration.groupsDN();
    }

    @Override
    public long getLdapServerId(long companyId, String screenName, String emailAddress) throws Exception {
        long preferredLDAPServerId = this._ldapSettings.getPreferredLDAPServerId(companyId, screenName);
        if (preferredLDAPServerId >= 0L && this.hasUser(preferredLDAPServerId, companyId, screenName, emailAddress)) {
            return preferredLDAPServerId;
        }
        List<LDAPServerConfiguration> ldapServerConfigurations = this._ldapServerConfigurationProvider.getConfigurations(companyId);
        for (LDAPServerConfiguration ldapServerConfiguration : ldapServerConfigurations) {
            if (!this.hasUser(ldapServerConfiguration.ldapServerId(), companyId, screenName, emailAddress)) continue;
            return ldapServerConfiguration.ldapServerId();
        }
        if (!ListUtil.isEmpty(ldapServerConfigurations)) {
            LDAPServerConfiguration ldapServerConfiguration = ldapServerConfigurations.get(0);
            return ldapServerConfiguration.ldapServerId();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Attribute getMultivaluedAttribute(long companyId, LdapContext ldapContext, String baseDN, String filter, Attribute attribute) throws Exception {
        if (attribute.size() > 0) {
            return attribute;
        }
        SystemLDAPConfiguration systemLDAPConfiguration = this._systemLDAPConfigurationProvider.getConfiguration(companyId);
        String[] attributeIds = new String[]{this._getNextRange(systemLDAPConfiguration, attribute.getID())};
        while (true) {
            SearchResult searchResult;
            Attributes attributes;
            ArrayList<SearchResult> searchResults = new ArrayList<SearchResult>();
            this.searchLDAP(companyId, ldapContext, new byte[0], 0, baseDN, filter, attributeIds, searchResults);
            if (searchResults.size() != 1 || (attributes = (searchResult = (SearchResult)searchResults.get(0)).getAttributes()).size() != 1) break;
            try (NamingEnumeration<? extends Attribute> enu = null;){
                enu = attributes.getAll();
                if (!enu.hasMoreElements()) break;
                Attribute curAttribute = (Attribute)enu.nextElement();
                for (int i = 0; i < curAttribute.size(); ++i) {
                    attribute.add(curAttribute.get(i));
                }
                if (StringUtil.endsWith((String)curAttribute.getID(), (String)"*") || curAttribute.size() < systemLDAPConfiguration.rangeSize()) {
                    break;
                }
            }
            attributeIds[0] = this._getNextRange(systemLDAPConfiguration, attributeIds[0]);
        }
        return attribute;
    }

    @Override
    @Deprecated
    public String getNameInNamespace(long ldapServerId, long companyId, Binding binding) throws Exception {
        LDAPServerConfiguration ldapServerConfiguration = this._ldapServerConfigurationProvider.getConfiguration(companyId, ldapServerId);
        String baseDN = ldapServerConfiguration.baseDN();
        String name = binding.getName();
        if (name.startsWith("\"") && name.endsWith("\"")) {
            name = name.substring(1, name.length() - 1);
        }
        if (Validator.isNull((String)baseDN)) {
            return name;
        }
        return name.concat(",").concat(baseDN);
    }

    @Override
    public Binding getUser(long ldapServerId, long companyId, String screenName, String emailAddress) throws Exception {
        return this.getUser(ldapServerId, companyId, screenName, emailAddress, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Binding getUser(long ldapServerId, long companyId, String screenName, String emailAddress, boolean checkOriginalEmail) throws Exception {
        LdapContext ldapContext = this.getContext(ldapServerId, companyId);
        NamingEnumeration<SearchResult> enu = null;
        try {
            String originalEmailAddress;
            if (ldapContext == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((String[])new String[]{"No LDAP server configuration available for LDAP ", "server ", String.valueOf(ldapServerId), " and company ", String.valueOf(companyId)}));
                }
                Binding binding = null;
                return binding;
            }
            LDAPServerConfiguration ldapServerConfiguration = this._ldapServerConfigurationProvider.getConfiguration(companyId, ldapServerId);
            String baseDN = ldapServerConfiguration.baseDN();
            String userSearchFilter = ldapServerConfiguration.userSearchFilter();
            this._ldapFilterValidator.validate(userSearchFilter, "LDAPServerConfiguration.userSearchFilter");
            StringBundler sb = new StringBundler(Validator.isNotNull((String)userSearchFilter) ? 9 : 5);
            if (Validator.isNotNull((String)userSearchFilter)) {
                sb.append("(");
                sb.append("&");
            }
            sb.append("(");
            String loginMapping = null;
            String login = null;
            Properties userMappings = this._ldapSettings.getUserMappings(ldapServerId, companyId);
            String authType = PrefsPropsUtil.getString((long)companyId, (String)"company.security.auth.type", (String)this._companySecurityAuthType);
            if (authType.equals("screenName") && !PrefsPropsUtil.getBoolean((long)companyId, (String)"users.screen.name.always.autogenerate")) {
                loginMapping = userMappings.getProperty("screenName");
                login = screenName;
            } else {
                loginMapping = userMappings.getProperty("emailAddress");
                login = emailAddress;
            }
            sb.append(loginMapping);
            sb.append("=");
            sb.append(this.encodeFilterAttribute(login, false));
            sb.append(")");
            if (Validator.isNotNull((String)userSearchFilter)) {
                sb.append(userSearchFilter);
                sb.append(")");
            }
            SearchControls searchControls = new SearchControls(2, 1L, 0, null, false, false);
            enu = ldapContext.search(baseDN, sb.toString(), searchControls);
            if (enu.hasMoreElements()) {
                Binding binding = (Binding)enu.nextElement();
                return binding;
            }
            if (checkOriginalEmail && Validator.isNotNull((String)(originalEmailAddress = UserImportTransactionThreadLocal.getOriginalEmailAddress())) && !emailAddress.equals(originalEmailAddress)) {
                Binding binding = this.getUser(ldapServerId, companyId, screenName, originalEmailAddress, false);
                return binding;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Unable to retrieve user with LDAP server ", String.valueOf(ldapServerId), ", company ", String.valueOf(companyId), ", loginMapping ", loginMapping, ", and login ", login}));
            }
            Binding binding = null;
            return binding;
        }
        finally {
            if (enu != null) {
                enu.close();
            }
            if (ldapContext != null) {
                ldapContext.close();
            }
        }
    }

    @Override
    public Attributes getUserAttributes(long ldapServerId, long companyId, LdapContext ldapContext, String fullDistinguishedName) throws Exception {
        Properties userMappings = this._ldapSettings.getUserMappings(ldapServerId, companyId);
        Properties userExpandoMappings = this._ldapSettings.getUserExpandoMappings(ldapServerId, companyId);
        PropertiesUtil.merge((Properties)userMappings, (Properties)userExpandoMappings);
        Properties contactMappings = this._ldapSettings.getContactMappings(ldapServerId, companyId);
        Properties contactExpandoMappings = this._ldapSettings.getContactExpandoMappings(ldapServerId, companyId);
        PropertiesUtil.merge((Properties)contactMappings, (Properties)contactExpandoMappings);
        PropertiesUtil.merge((Properties)userMappings, (Properties)contactMappings);
        Collection<Object> values = userMappings.values();
        values.removeIf(object -> Validator.isNull((Object)object));
        String[] mappedUserAttributeIds = ArrayUtil.toStringArray((Object[])values.toArray(new Object[userMappings.size()]));
        Attributes attributes = this._getAttributes(ldapContext, fullDistinguishedName, mappedUserAttributeIds);
        if (_log.isDebugEnabled()) {
            if (attributes == null || attributes.size() == 0) {
                _log.debug((Object)("No LDAP user attributes found for:: " + fullDistinguishedName));
            } else {
                for (String attributeId : mappedUserAttributeIds) {
                    Attribute attribute = attributes.get(attributeId);
                    if (attribute == null) continue;
                    String attributeID = StringUtil.toLowerCase((String)attribute.getID());
                    if (attributeID.indexOf("password") > -1) {
                        Attribute clonedAttribute = (Attribute)attribute.clone();
                        clonedAttribute.clear();
                        clonedAttribute.add("********");
                        _log.debug((Object)("LDAP user attribute " + clonedAttribute.toString()));
                        continue;
                    }
                    _log.debug((Object)("LDAP user attribute " + attribute.toString()));
                }
            }
        }
        return attributes;
    }

    @Override
    public byte[] getUsers(long companyId, LdapContext ldapContext, byte[] cookie, int maxResults, String baseDN, String userFilter, List<SearchResult> searchResults) throws Exception {
        return this.searchLDAP(companyId, ldapContext, cookie, maxResults, baseDN, userFilter, null, searchResults);
    }

    @Override
    public byte[] getUsers(long companyId, LdapContext ldapContext, byte[] cookie, int maxResults, String baseDN, String userFilter, String[] attributeIds, List<SearchResult> searchResults) throws Exception {
        return this.searchLDAP(companyId, ldapContext, cookie, maxResults, baseDN, userFilter, attributeIds, searchResults);
    }

    @Override
    public byte[] getUsers(long ldapServerId, long companyId, LdapContext ldapContext, byte[] cookie, int maxResults, List<SearchResult> searchResults) throws Exception {
        LDAPServerConfiguration ldapServerConfiguration = this._ldapServerConfigurationProvider.getConfiguration(companyId, ldapServerId);
        String baseDN = ldapServerConfiguration.baseDN();
        String userSearchFilter = ldapServerConfiguration.userSearchFilter();
        return this.getUsers(companyId, ldapContext, cookie, maxResults, baseDN, userSearchFilter, searchResults);
    }

    @Override
    public byte[] getUsers(long ldapServerId, long companyId, LdapContext ldapContext, byte[] cookie, int maxResults, String[] attributeIds, List<SearchResult> searchResults) throws Exception {
        LDAPServerConfiguration ldapServerConfiguration = this._ldapServerConfigurationProvider.getConfiguration(companyId, ldapServerId);
        String baseDN = ldapServerConfiguration.baseDN();
        String userSearchFilter = ldapServerConfiguration.userSearchFilter();
        return this.getUsers(companyId, ldapContext, cookie, maxResults, baseDN, userSearchFilter, attributeIds, searchResults);
    }

    @Override
    public String getUsersDN(long ldapServerId, long companyId) throws Exception {
        LDAPServerConfiguration ldapServerConfiguration = this._ldapServerConfigurationProvider.getConfiguration(companyId, ldapServerId);
        return ldapServerConfiguration.usersDN();
    }

    @Override
    public boolean hasUser(long ldapServerId, long companyId, String screenName, String emailAddress) throws Exception {
        return this.getUser(ldapServerId, companyId, screenName, emailAddress) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isGroupMember(long ldapServerId, long companyId, String groupDN, String userDN) throws Exception {
        LdapContext ldapContext = this.getContext(ldapServerId, companyId);
        NamingEnumeration<SearchResult> enu = null;
        try {
            if (ldapContext == null) {
                boolean bl = false;
                return bl;
            }
            Properties groupMappings = this._ldapSettings.getGroupMappings(ldapServerId, companyId);
            StringBundler sb = new StringBundler(5);
            sb.append("(");
            sb.append(groupMappings.getProperty("user"));
            sb.append("=");
            sb.append(this.encodeFilterAttribute(StringUtil.replace((String)userDN, (char)'\\', (String)"\\\\"), false));
            sb.append(")");
            SearchControls searchControls = new SearchControls(2, 1L, 0, null, false, false);
            CompositeName name = new CompositeName();
            name.add(groupDN);
            enu = ldapContext.search((Name)name, sb.toString(), searchControls);
            if (enu.hasMoreElements()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (NameNotFoundException nnfe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to determine if user DN ", userDN, " is a member of group DN ", groupDN}), (Throwable)nnfe);
            }
        }
        finally {
            if (enu != null) {
                enu.close();
            }
            if (ldapContext != null) {
                ldapContext.close();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUserGroupMember(long ldapServerId, long companyId, String groupDN, String userDN) throws Exception {
        LdapContext ldapContext = this.getContext(ldapServerId, companyId);
        NamingEnumeration<SearchResult> enu = null;
        try {
            if (ldapContext == null) {
                boolean bl = false;
                return bl;
            }
            Properties userMappings = this._ldapSettings.getUserMappings(ldapServerId, companyId);
            StringBundler sb = new StringBundler(5);
            sb.append("(");
            sb.append(userMappings.getProperty("group"));
            sb.append("=");
            sb.append(this.encodeFilterAttribute(StringUtil.replace((String)groupDN, (char)'\\', (String)"\\\\"), false));
            sb.append(")");
            SearchControls searchControls = new SearchControls(2, 1L, 0, null, false, false);
            enu = ldapContext.search(userDN, sb.toString(), searchControls);
            if (enu.hasMoreElements()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (NameNotFoundException nnfe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to determine if group DN ", groupDN, " is a member of user DN ", userDN}), (Throwable)nnfe);
            }
        }
        finally {
            if (enu != null) {
                enu.close();
            }
            if (ldapContext != null) {
                ldapContext.close();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] searchLDAP(long companyId, LdapContext ldapContext, byte[] cookie, int maxResults, String baseDN, String filter, String[] attributeIds, List<SearchResult> searchResults) throws Exception {
        SearchControls searchControls = new SearchControls(2, maxResults, 0, attributeIds, false, false);
        NamingEnumeration<SearchResult> enu = null;
        try {
            if (cookie != null) {
                SystemLDAPConfiguration systemLDAPConfiguration = this._systemLDAPConfigurationProvider.getConfiguration(companyId);
                if (cookie.length == 0) {
                    ldapContext.setRequestControls(new Control[]{new PagedResultsControl(systemLDAPConfiguration.pageSize(), true)});
                } else {
                    ldapContext.setRequestControls(new Control[]{new PagedResultsControl(systemLDAPConfiguration.pageSize(), cookie, true)});
                }
                enu = ldapContext.search(baseDN, filter, searchControls);
                while (enu.hasMoreElements()) {
                    searchResults.add((SearchResult)enu.nextElement());
                }
                byte[] byArray = this._getCookie(ldapContext.getResponseControls());
                return byArray;
            }
        }
        catch (OperationNotSupportedException onse) {
            if (enu != null) {
                enu.close();
            }
            ldapContext.setRequestControls(null);
            enu = ldapContext.search(baseDN, filter, searchControls);
            while (enu.hasMoreElements()) {
                searchResults.add((SearchResult)enu.nextElement());
            }
        }
        finally {
            if (enu != null) {
                enu.close();
            }
            ldapContext.setRequestControls(null);
        }
        return null;
    }

    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.configuration.LDAPServerConfiguration)", unbind="-")
    protected void setLDAPServerConfigurationProvider(ConfigurationProvider<LDAPServerConfiguration> ldapServerConfigurationProvider) {
        this._ldapServerConfigurationProvider = ldapServerConfigurationProvider;
    }

    @Reference(unbind="-")
    protected void setLdapSettings(LDAPSettings ldapSettings) {
        this._ldapSettings = ldapSettings;
    }

    @Reference(unbind="-")
    protected void setProps(Props props) {
        this._companySecurityAuthType = GetterUtil.getString((String)props.get("company.security.auth.type"));
    }

    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.configuration.SystemLDAPConfiguration)", unbind="-")
    protected void setSystemLDAPConfigurationProvider(ConfigurationProvider<SystemLDAPConfiguration> systemLDAPConfigurationProvider) {
        this._systemLDAPConfigurationProvider = systemLDAPConfigurationProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Attributes _getAttributes(LdapContext ldapContext, String fullDistinguishedName, String[] attributeIds) throws Exception {
        Name fullDN = new CompositeName().add(fullDistinguishedName);
        Attributes attributes = null;
        String[] auditAttributeIds = new String[]{"creatorsName", "createTimestamp", "modifiersName", "modifyTimestamp"};
        if (attributeIds == null) {
            attributes = ldapContext.getAttributes(fullDN);
            try (NamingEnumeration<? extends Attribute> enu = null;){
                Attributes auditAttributes = ldapContext.getAttributes(fullDN, auditAttributeIds);
                enu = auditAttributes.getAll();
                while (enu.hasMoreElements()) {
                    attributes.put((Attribute)enu.nextElement());
                }
            }
        } else {
            int attributeCount = attributeIds.length + auditAttributeIds.length;
            String[] allAttributeIds = new String[attributeCount];
            System.arraycopy(attributeIds, 0, allAttributeIds, 0, attributeIds.length);
            System.arraycopy(auditAttributeIds, 0, allAttributeIds, attributeIds.length, auditAttributeIds.length);
            attributes = ldapContext.getAttributes(fullDN, allAttributeIds);
        }
        return attributes;
    }

    private byte[] _getCookie(Control[] controls) {
        if (controls == null) {
            return null;
        }
        for (Control control : controls) {
            if (!(control instanceof PagedResultsResponseControl)) continue;
            PagedResultsResponseControl pagedResultsResponseControl = (PagedResultsResponseControl)control;
            return pagedResultsResponseControl.getCookie();
        }
        return null;
    }

    private String _getNextRange(SystemLDAPConfiguration systemLDAPConfiguration, String attributeId) {
        String originalAttributeId = null;
        int start = 0;
        int end = 0;
        int x = attributeId.indexOf(59);
        if (x < 0) {
            originalAttributeId = attributeId;
            end = systemLDAPConfiguration.rangeSize() - 1;
        } else {
            int y = attributeId.indexOf(61, x);
            int z = attributeId.indexOf(45, y);
            originalAttributeId = attributeId.substring(0, x);
            start = GetterUtil.getInteger((String)attributeId.substring(y + 1, z));
            start += systemLDAPConfiguration.rangeSize();
            end = GetterUtil.getInteger((String)attributeId.substring(z + 1));
            end += systemLDAPConfiguration.rangeSize();
        }
        StringBundler sb = new StringBundler(6);
        sb.append(originalAttributeId);
        sb.append(";");
        sb.append("range=");
        sb.append(start);
        sb.append("-");
        sb.append(end);
        return sb.toString();
    }
}

