/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap.internal.exportimport;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.security.ldap.LDAPSettings;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.security.exportimport.UserExporter;
import com.liferay.portal.security.exportimport.UserOperation;
import com.liferay.portal.security.ldap.PortalLDAP;
import com.liferay.portal.security.ldap.authenticator.configuration.LDAPAuthConfiguration;
import com.liferay.portal.security.ldap.configuration.ConfigurationProvider;
import com.liferay.portal.security.ldap.exportimport.Modifications;
import com.liferay.portal.security.ldap.exportimport.PortalToLDAPConverter;
import com.liferay.portal.security.ldap.internal.PortalLDAPContext;
import com.liferay.portal.security.ldap.util.LDAPUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SchemaViolationException;
import javax.naming.ldap.LdapContext;
import org.apache.commons.lang.time.StopWatch;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={UserExporter.class})
public class LDAPUserExporterImpl
implements UserExporter {
    private static final Log _log = LogFactoryUtil.getLog(LDAPUserExporterImpl.class);
    private ConfigurationProvider<LDAPAuthConfiguration> _ldapAuthConfigurationProvider;
    private LDAPSettings _ldapSettings;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile PortalLDAP _portalLDAP;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile PortalToLDAPConverter _portalToLDAPConverter;
    private UserGroupLocalService _userGroupLocalService;
    private UserLocalService _userLocalService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportUser(Contact contact, Map<String, Serializable> contactExpandoAttributes) throws Exception {
        StopWatch stopWatch;
        block17: {
            Modifications modifications;
            CompositeName name;
            LdapContext ldapContext;
            block15: {
                block16: {
                    long ldapServerId;
                    User user;
                    long companyId;
                    block13: {
                        block14: {
                            companyId = contact.getCompanyId();
                            stopWatch = new StopWatch();
                            if (_log.isDebugEnabled()) {
                                stopWatch.start();
                                _log.debug((Object)("Exporting contact " + contact));
                            }
                            if (!this._ldapSettings.isExportEnabled(companyId)) {
                                return;
                            }
                            user = this._userLocalService.getUserByContactId(contact.getContactId());
                            if (user.isDefaultUser() || user.getStatus() != 0) {
                                return;
                            }
                            ldapServerId = this._portalLDAP.getLdapServerId(companyId, user.getScreenName(), user.getEmailAddress());
                            ldapContext = this._portalLDAP.getContext(ldapServerId, companyId);
                            try {
                                if (ldapContext != null) break block13;
                                if (ldapContext == null) break block14;
                            }
                            catch (Throwable throwable) {
                                if (ldapContext != null) {
                                    ldapContext.close();
                                }
                                if (_log.isDebugEnabled()) {
                                    _log.debug((Object)StringBundler.concat((String[])new String[]{"Finished exporting contact ", String.valueOf(contact), " in ", String.valueOf(stopWatch.getTime()), "ms"}));
                                }
                                throw throwable;
                            }
                            ldapContext.close();
                        }
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)StringBundler.concat((String[])new String[]{"Finished exporting contact ", String.valueOf(contact), " in ", String.valueOf(stopWatch.getTime()), "ms"}));
                        }
                        return;
                    }
                    Properties contactMappings = this._ldapSettings.getContactMappings(ldapServerId, companyId);
                    Properties contactExpandoMappings = this._ldapSettings.getContactExpandoMappings(ldapServerId, companyId);
                    Binding binding = this._portalLDAP.getUser(ldapServerId, contact.getCompanyId(), user.getScreenName(), user.getEmailAddress());
                    if (binding == null) {
                        Properties userMappings = this._ldapSettings.getUserMappings(ldapServerId, companyId);
                        binding = this.addUser(ldapServerId, ldapContext, user, userMappings);
                    }
                    name = new CompositeName();
                    name.add(binding.getNameInNamespace());
                    modifications = this._portalToLDAPConverter.getLDAPContactModifications(contact, contactExpandoAttributes, contactMappings, contactExpandoMappings);
                    if (modifications != null) break block15;
                    if (ldapContext == null) break block16;
                    ldapContext.close();
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((String[])new String[]{"Finished exporting contact ", String.valueOf(contact), " in ", String.valueOf(stopWatch.getTime()), "ms"}));
                }
                return;
            }
            ModificationItem[] modificationItems = modifications.getItems();
            ldapContext.modifyAttributes(name, modificationItems);
            if (ldapContext == null) break block17;
            ldapContext.close();
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Finished exporting contact ", String.valueOf(contact), " in ", String.valueOf(stopWatch.getTime()), "ms"}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportUser(long userId, long userGroupId, UserOperation userOperation) throws Exception {
        StopWatch stopWatch;
        User user;
        block17: {
            user = this._userLocalService.getUser(userId);
            long companyId = user.getCompanyId();
            stopWatch = new StopWatch();
            if (_log.isDebugEnabled()) {
                stopWatch.start();
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Exporting user ", String.valueOf(user), " in user group ", String.valueOf(userGroupId)}));
            }
            if (!this._ldapSettings.isExportEnabled(companyId) || !this._ldapSettings.isExportGroupEnabled(companyId)) {
                return;
            }
            long ldapServerId = this._portalLDAP.getLdapServerId(companyId, user.getScreenName(), user.getEmailAddress());
            LdapContext ldapContext = this._portalLDAP.getContext(ldapServerId, companyId);
            if (ldapContext == null) {
                return;
            }
            UserGroup userGroup = this._userGroupLocalService.getUserGroup(userGroupId);
            Properties groupMappings = this._ldapSettings.getGroupMappings(ldapServerId, companyId);
            Properties userMappings = this._ldapSettings.getUserMappings(ldapServerId, companyId);
            Binding binding = this._portalLDAP.getGroup(ldapServerId, companyId, userGroup.getName());
            if (binding == null) {
                if (userOperation == UserOperation.ADD) {
                    this.addGroup(ldapServerId, ldapContext, userGroup, user, groupMappings, userMappings);
                } else if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to get or add LDAP bindings for user group " + userGroup.getName()));
                }
                return;
            }
            try {
                CompositeName name = new CompositeName();
                name.add(binding.getNameInNamespace());
                Modifications modifications = this._portalToLDAPConverter.getLDAPGroupModifications(ldapServerId, userGroup, user, groupMappings, userMappings, userOperation);
                ModificationItem[] modificationItems = modifications.getItems();
                ldapContext.modifyAttributes(name, modificationItems);
                if (ldapContext == null) break block17;
            }
            catch (SchemaViolationException sve) {
                block18: {
                    try {
                        String fullGroupDN;
                        Attributes attributes;
                        Attribute groupMembers;
                        if (_log.isInfoEnabled()) {
                            _log.info((Object)("Unable to update LDAP bindings for user group " + userGroup.getName()), (Throwable)sve);
                        }
                        if ((groupMembers = (attributes = this._portalLDAP.getGroupAttributes(ldapServerId, companyId, ldapContext, fullGroupDN = binding.getNameInNamespace(), true)).get(groupMappings.getProperty("user"))) != null && groupMembers.size() == 1) {
                            ldapContext.unbind(fullGroupDN);
                        }
                        if (ldapContext == null) break block18;
                    }
                    catch (Throwable throwable) {
                        if (ldapContext != null) {
                            ldapContext.close();
                        }
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)StringBundler.concat((String[])new String[]{"Finished exporting user ", String.valueOf(user), " in user group ", String.valueOf(userGroupId), " in ", String.valueOf(stopWatch.getTime()), "ms"}));
                        }
                        throw throwable;
                    }
                    ldapContext.close();
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((String[])new String[]{"Finished exporting user ", String.valueOf(user), " in user group ", String.valueOf(userGroupId), " in ", String.valueOf(stopWatch.getTime()), "ms"}));
                }
            }
            ldapContext.close();
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Finished exporting user ", String.valueOf(user), " in user group ", String.valueOf(userGroupId), " in ", String.valueOf(stopWatch.getTime()), "ms"}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportUser(User user, Map<String, Serializable> userExpandoAttributes) throws Exception {
        if (user.isDefaultUser() || user.getStatus() != 0) {
            return;
        }
        long companyId = user.getCompanyId();
        if (!this._ldapSettings.isExportEnabled(companyId)) {
            return;
        }
        long ldapServerId = this._portalLDAP.getLdapServerId(companyId, user.getScreenName(), user.getEmailAddress());
        try (LdapContext ldapContext = this._portalLDAP.getContext(ldapServerId, companyId);){
            if (ldapContext == null) {
                return;
            }
            Properties userMappings = this._ldapSettings.getUserMappings(ldapServerId, companyId);
            Properties userExpandoMappings = this._ldapSettings.getUserExpandoMappings(ldapServerId, companyId);
            Binding binding = this._portalLDAP.getUser(ldapServerId, user.getCompanyId(), user.getScreenName(), user.getEmailAddress(), true);
            if (binding == null) {
                binding = this.addUser(ldapServerId, ldapContext, user, userMappings);
            } else {
                Attributes attributes = this._portalLDAP.getUserAttributes(ldapServerId, companyId, ldapContext, binding.getNameInNamespace());
                String modifyTimestamp = LDAPUtil.getAttributeString(attributes, "modifyTimestamp");
                Date modifiedDate = LDAPUtil.parseDate(modifyTimestamp);
                if (modifiedDate != null && modifiedDate.equals(user.getModifiedDate())) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Skipping user " + user.getEmailAddress() + " because he is already synchronized"));
                    }
                    return;
                }
            }
            CompositeName name = new CompositeName();
            name.add(binding.getNameInNamespace());
            Modifications modifications = this._portalToLDAPConverter.getLDAPUserModifications(user, userExpandoAttributes, userMappings, userExpandoMappings);
            if (modifications == null) {
                return;
            }
            ModificationItem[] modificationItems = modifications.getItems();
            ldapContext.modifyAttributes(name, modificationItems);
            if (!this._ldapSettings.isExportGroupEnabled(companyId)) {
                return;
            }
            List userGroups = this._userGroupLocalService.getUserUserGroups(user.getUserId());
            for (UserGroup userGroup : userGroups) {
                this.exportUser(user.getUserId(), userGroup.getUserGroupId(), UserOperation.ADD);
            }
            Modifications groupModifications = this._portalToLDAPConverter.getLDAPUserGroupModifications(ldapServerId, userGroups, user, userMappings);
            ModificationItem[] groupModificationItems = groupModifications.getItems();
            if (groupModificationItems.length > 0) {
                ldapContext.modifyAttributes(name, groupModificationItems);
            }
        }
    }

    protected Binding addGroup(long ldapServerId, LdapContext ldapContext, UserGroup userGroup, User user, Properties groupMappings, Properties userMappings) throws Exception {
        CompositeName name = new CompositeName();
        name.add(this._portalToLDAPConverter.getGroupDNName(ldapServerId, userGroup, groupMappings));
        Attributes attributes = this._portalToLDAPConverter.getLDAPGroupAttributes(ldapServerId, userGroup, user, groupMappings, userMappings);
        ldapContext.bind(name, (Object)new PortalLDAPContext(attributes));
        return this._portalLDAP.getGroup(ldapServerId, userGroup.getCompanyId(), userGroup.getName());
    }

    protected Binding addUser(long ldapServerId, LdapContext ldapContext, User user, Properties userMappings) throws Exception {
        CompositeName name = new CompositeName();
        name.add(this._portalToLDAPConverter.getUserDNName(ldapServerId, user, userMappings));
        Attributes attributes = this._portalToLDAPConverter.getLDAPUserAttributes(ldapServerId, user, userMappings);
        ldapContext.bind(name, (Object)new PortalLDAPContext(attributes));
        return this._portalLDAP.getUser(ldapServerId, user.getCompanyId(), user.getScreenName(), user.getEmailAddress());
    }

    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.authenticator.configuration.LDAPAuthConfiguration)", unbind="-")
    protected void setConfigurationProvider(ConfigurationProvider<LDAPAuthConfiguration> ldapAuthConfigurationProvider) {
        this._ldapAuthConfigurationProvider = ldapAuthConfigurationProvider;
    }

    @Reference(unbind="-")
    protected void setLdapSettings(LDAPSettings ldapSettings) {
        this._ldapSettings = ldapSettings;
    }

    @Reference(unbind="-")
    protected void setUserGroupLocalService(UserGroupLocalService userGroupLocalService) {
        this._userGroupLocalService = userGroupLocalService;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }
}

