/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap.internal.model.listener;

import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.MembershipRequest;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.ldap.LDAPSettings;
import com.liferay.portal.kernel.service.MembershipRequestLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.security.exportimport.UserExporter;
import com.liferay.portal.security.ldap.internal.UserImportTransactionThreadLocal;
import com.liferay.portal.security.ldap.internal.model.listener.BaseLDAPExportModelListener;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={ModelListener.class})
public class UserModelListener
extends BaseLDAPExportModelListener<User> {
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile LDAPSettings _ldapSettings;
    @Reference
    private MembershipRequestLocalService _membershipRequestLocalService;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile UserExporter _userExporter;
    @Reference
    private UserLocalService _userLocalService;

    public void onAfterAddAssociation(Object classPK, String associationClassName, Object associationClassPK) throws ModelListenerException {
        try {
            if (associationClassName.equals(Group.class.getName())) {
                long userId = (Long)classPK;
                long groupId = (Long)associationClassPK;
                this.updateMembershipRequestStatus(userId, groupId);
            }
        }
        catch (Exception e) {
            throw new ModelListenerException((Throwable)e);
        }
    }

    public void onAfterCreate(User user) throws ModelListenerException {
        try {
            this.exportToLDAP(user);
        }
        catch (Exception e) {
            throw new ModelListenerException("Unable to export user " + user.getUserId() + " to LDAP on after create", (Throwable)e);
        }
    }

    public void onAfterUpdate(User user) throws ModelListenerException {
        try {
            this.exportToLDAP(user);
        }
        catch (Exception e) {
            throw new ModelListenerException("Unable to export user " + user.getUserId() + " to LDAP on after update", (Throwable)e);
        }
    }

    public void onBeforeUpdate(User user) {
        UserImportTransactionThreadLocal.setOriginalEmailAddress(user.getOriginalEmailAddress());
    }

    protected void exportToLDAP(User user) throws Exception {
        this.exportToLDAP(user, this._userExporter, this._ldapSettings);
    }

    protected void updateMembershipRequestStatus(long userId, long groupId) throws Exception {
        long principalUserId = GetterUtil.getLong((String)PrincipalThreadLocal.getName());
        User user = this._userLocalService.getUser(userId);
        List membershipRequests = this._membershipRequestLocalService.getMembershipRequests(userId, groupId, 0L);
        for (MembershipRequest membershipRequest : membershipRequests) {
            this._membershipRequestLocalService.updateStatus(principalUserId, membershipRequest.getMembershipRequestId(), LanguageUtil.get((Locale)user.getLocale(), (String)"your-membership-has-been-approved"), 1L, false, new ServiceContext());
        }
    }
}

