/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.opensso.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.security.sso.OpenSSO;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.sso.opensso.configuration.OpenSSOConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={OpenSSO.class})
public class OpenSSOImpl
implements OpenSSO {
    private static final String _GET_ATTRIBUTES = "/identity/attributes";
    private static final String _GET_COOKIE_NAME = "/identity/getCookieNameForToken";
    private static final String _GET_COOKIE_NAMES = "/identity/getCookieNamesToForward";
    private static final String _VALIDATE_TOKEN_VERSION_12 = "/identity/isTokenValid";
    private static final String _VALIDATE_TOKEN_VERSION_13 = "/json/sessions/{#subjectId}?_action=validate";
    private static final Log _log = LogFactoryUtil.getLog(OpenSSOImpl.class);
    @Reference
    private ConfigurationProvider _configurationProvider;
    private final Map<String, String[]> _cookieNamesMap = new ConcurrentHashMap<String, String[]>();
    @Reference
    private Http _http;
    @Reference
    private Portal _portal;

    public Map<String, String> getAttributes(HttpServletRequest httpServletRequest, String serviceURL) {
        HashMap<String, String> nameValues;
        block8: {
            nameValues = new HashMap<String, String>();
            String url = serviceURL.concat(_GET_ATTRIBUTES);
            try {
                URL urlObj = new URL(url);
                HttpURLConnection httpURLConnection = (HttpURLConnection)urlObj.openConnection();
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setRequestMethod("POST");
                httpURLConnection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
                this.setCookieProperty(httpServletRequest, httpURLConnection, this.getCookieNames(serviceURL));
                OutputStreamWriter osw = new OutputStreamWriter(httpURLConnection.getOutputStream());
                osw.write("dummy");
                osw.flush();
                int responseCode = httpURLConnection.getResponseCode();
                if (responseCode == 200) {
                    InputStream inputStream = (InputStream)httpURLConnection.getContent();
                    UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new InputStreamReader(inputStream));
                    String line = null;
                    while ((line = unsyncBufferedReader.readLine()) != null) {
                        if (!line.startsWith("userdetails.attribute.name=")) continue;
                        String name = line.replaceFirst("userdetails.attribute.name=", "");
                        line = unsyncBufferedReader.readLine();
                        if (!line.startsWith("userdetails.attribute.value=")) continue;
                        String value = line.replaceFirst("userdetails.attribute.value=", "");
                        nameValues.put(name, value);
                    }
                } else if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Attributes response code " + responseCode));
                }
            }
            catch (MalformedURLException murle) {
                _log.error((Object)murle.getMessage());
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)murle, (Throwable)murle);
                }
            }
            catch (IOException ioe) {
                _log.error((Object)ioe.getMessage());
                if (!_log.isDebugEnabled()) break block8;
                _log.debug((Object)ioe, (Throwable)ioe);
            }
        }
        return nameValues;
    }

    public String[] getCookieNames(String serviceURL) {
        ArrayList<String> cookieNamesList;
        String[] cookieNames;
        block13: {
            cookieNames = this._cookieNamesMap.get(serviceURL);
            if (cookieNames != null) {
                return cookieNames;
            }
            cookieNamesList = new ArrayList<String>();
            try {
                String line;
                String cookieName = null;
                String url = serviceURL.concat(_GET_COOKIE_NAME);
                URL urlObj = new URL(url);
                HttpURLConnection httpURLConnection = (HttpURLConnection)urlObj.openConnection();
                InputStream inputStream = (InputStream)httpURLConnection.getContent();
                UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new InputStreamReader(inputStream));
                int responseCode = httpURLConnection.getResponseCode();
                if (responseCode != 200) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)(url + " has response code " + responseCode));
                    }
                } else {
                    line = null;
                    while ((line = unsyncBufferedReader.readLine()) != null) {
                        if (!line.startsWith("string=")) continue;
                        cookieName = line = line.replaceFirst("string=", "");
                    }
                }
                url = serviceURL.concat(_GET_COOKIE_NAMES);
                urlObj = new URL(url);
                httpURLConnection = (HttpURLConnection)urlObj.openConnection();
                inputStream = (InputStream)httpURLConnection.getContent();
                unsyncBufferedReader = new UnsyncBufferedReader((Reader)new InputStreamReader(inputStream));
                if (httpURLConnection.getResponseCode() != 200) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)(url + " has response code " + responseCode));
                    }
                } else {
                    line = null;
                    while ((line = unsyncBufferedReader.readLine()) != null) {
                        if (!line.startsWith("string=")) continue;
                        if (cookieName.equals(line = line.replaceFirst("string=", ""))) {
                            cookieNamesList.add(0, cookieName);
                            continue;
                        }
                        cookieNamesList.add(line);
                    }
                }
            }
            catch (IOException ioe) {
                if (!_log.isWarnEnabled()) break block13;
                _log.warn((Object)ioe, (Throwable)ioe);
            }
        }
        if ((cookieNames = cookieNamesList.toArray(new String[0])).length > 0) {
            this._cookieNamesMap.put(serviceURL, cookieNames);
        }
        return cookieNames;
    }

    public String getSubjectId(HttpServletRequest httpServletRequest, String serviceURL) {
        String cookieName = this.getCookieNames(serviceURL)[0];
        return CookieKeys.getCookie((HttpServletRequest)httpServletRequest, (String)cookieName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAuthenticated(HttpServletRequest httpServletRequest, String serviceURL) throws IOException {
        String version;
        String[] cookieNames;
        block9: {
            cookieNames = this.getCookieNames(serviceURL);
            if (!this._hasCookieNames(httpServletRequest, cookieNames)) {
                return false;
            }
            version = "openam-12";
            try {
                OpenSSOConfiguration openSSOConfiguration = (OpenSSOConfiguration)this._configurationProvider.getConfiguration(OpenSSOConfiguration.class, (SettingsLocator)new CompanyServiceSettingsLocator(this._portal.getCompanyId(httpServletRequest), "com.liferay.portal.security.sso.opensso"));
                version = openSSOConfiguration.version();
            }
            catch (ConfigurationException ce) {
                if (!_log.isWarnEnabled()) break block9;
                _log.warn((Object)ce, (Throwable)ce);
            }
        }
        if (version.equals("openam-13")) {
            String subjectId = this.getSubjectId(httpServletRequest, serviceURL);
            if (subjectId == null) return false;
            String url = serviceURL.concat(StringUtil.replace((String)_VALIDATE_TOKEN_VERSION_13, (String)"{#subjectId}", (String)URLCodec.encodeURL((String)subjectId)));
            String json = this._http.URLtoString(url, true);
            try {
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)json);
                String realm = jsonObject.getString("realm");
                String uid = jsonObject.getString("uid");
                boolean valid = jsonObject.getBoolean("valid");
                if (realm != null && uid != null && valid) {
                    return true;
                }
                if (!_log.isDebugEnabled()) return false;
                _log.debug((Object)("Invalid authentication: " + json));
                return false;
            }
            catch (JSONException jsone) {
                throw new IOException(jsone);
            }
        } else {
            String url = serviceURL.concat(_VALIDATE_TOKEN_VERSION_12);
            URL urlObj = new URL(url);
            HttpURLConnection httpURLConnection = (HttpURLConnection)urlObj.openConnection();
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            this.setCookieProperty(httpServletRequest, httpURLConnection, cookieNames);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(httpURLConnection.getOutputStream());
            outputStreamWriter.write("dummy");
            outputStreamWriter.flush();
            int responseCode = httpURLConnection.getResponseCode();
            if (responseCode == 200) {
                String data = StringUtil.toLowerCase((String)StringUtil.read((InputStream)httpURLConnection.getInputStream()));
                if (!data.contains("boolean=true")) return false;
                return true;
            }
            if (!_log.isDebugEnabled()) return false;
            _log.debug((Object)("Authentication response code " + responseCode));
        }
        return false;
    }

    public boolean isValidServiceUrl(String serviceURL) {
        if (Validator.isNull((String)serviceURL)) {
            return false;
        }
        String[] cookieNames = this.getCookieNames(serviceURL);
        return cookieNames.length != 0;
    }

    public boolean isValidUrl(String url) {
        if (Validator.isNull((String)url)) {
            return false;
        }
        try {
            URL urlObj = new URL(url);
            HttpURLConnection httpURLConnection = (HttpURLConnection)urlObj.openConnection();
            int responseCode = httpURLConnection.getResponseCode();
            if (responseCode != 200 && (responseCode < 300 || responseCode > 304)) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"URL ", url, " is invalid with response code ", responseCode}));
                }
                return false;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"URL ", url, " is valid with response code ", responseCode}));
            }
        }
        catch (IOException ioe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)ioe, (Throwable)ioe);
            }
            return false;
        }
        return true;
    }

    public boolean isValidUrls(String[] urls) {
        for (String url : urls) {
            if (this.isValidUrl(url)) continue;
            return false;
        }
        return true;
    }

    public void setCookieProperty(HttpServletRequest httpServletRequest, HttpURLConnection urlc, String[] cookieNames) {
        if (cookieNames.length == 0) {
            return;
        }
        StringBundler sb = new StringBundler(cookieNames.length * 6);
        for (String cookieName : cookieNames) {
            String cookieValue = CookieKeys.getCookie((HttpServletRequest)httpServletRequest, (String)cookieName);
            sb.append(cookieName);
            sb.append("=");
            sb.append("\"");
            sb.append(cookieValue);
            sb.append("\"");
            sb.append(";");
        }
        urlc.setRequestProperty("Cookie", sb.toString());
    }

    private boolean _hasCookieNames(HttpServletRequest httpServletRequest, String[] cookieNames) {
        for (String cookieName : cookieNames) {
            if (CookieKeys.getCookie((HttpServletRequest)httpServletRequest, (String)cookieName) == null) continue;
            return true;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("No OpenSSO cookies: " + StringUtil.merge((Object[])cookieNames)));
        }
        return false;
    }
}

