/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.opensso.internal;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.security.sso.SSO;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.security.sso.opensso.configuration.OpenSSOConfiguration;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={SSO.class})
public class SSOImpl
implements SSO {
    private static final Log _log = LogFactoryUtil.getLog(SSOImpl.class);
    private ConfigurationProvider _configurationProvider;

    public String getSessionExpirationRedirectUrl(long companyId) {
        OpenSSOConfiguration openSSOConfiguration = this._getOpenSSOConfiguration(companyId);
        if (this._isSessionRedirectOnExpire(openSSOConfiguration)) {
            return openSSOConfiguration.logoutURL();
        }
        return null;
    }

    public String getSignInURL(long companyId, String defaultSigninURL) {
        OpenSSOConfiguration openSSOConfiguration = this._getOpenSSOConfiguration(companyId);
        if (!openSSOConfiguration.enabled()) {
            return null;
        }
        return openSSOConfiguration.loginURL();
    }

    public boolean isLoginRedirectRequired(long companyId) {
        OpenSSOConfiguration openSSOConfiguration = this._getOpenSSOConfiguration(companyId);
        return openSSOConfiguration.enabled();
    }

    public boolean isRedirectRequired(long companyId) {
        return false;
    }

    public boolean isSessionRedirectOnExpire(long companyId) {
        OpenSSOConfiguration openSSOConfiguration = this._getOpenSSOConfiguration(companyId);
        return this._isSessionRedirectOnExpire(openSSOConfiguration);
    }

    @Reference(unbind="-")
    protected void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this._configurationProvider = configurationProvider;
    }

    private OpenSSOConfiguration _getOpenSSOConfiguration(long companyId) {
        try {
            return (OpenSSOConfiguration)this._configurationProvider.getConfiguration(OpenSSOConfiguration.class, (SettingsLocator)new CompanyServiceSettingsLocator(companyId, "com.liferay.portal.security.sso.opensso"));
        }
        catch (ConfigurationException ce) {
            _log.error((Object)"Unable to get OpenSSO configuration", (Throwable)ce);
            return null;
        }
    }

    private boolean _isSessionRedirectOnExpire(OpenSSOConfiguration openSSOConfiguration) {
        if (openSSOConfiguration.enabled()) {
            return openSSOConfiguration.logoutOnSessionExpiration();
        }
        return false;
    }
}

