/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.product.navigation.personal.menu;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.product.navigation.personal.menu.PersonalMenuEntry;
import com.liferay.product.navigation.personal.menu.util.PersonalApplicationURLUtil;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;

public abstract class BasePersonalMenuEntry
implements PersonalMenuEntry {
    @Override
    public String getLabel(Locale locale) {
        return LanguageUtil.get((ResourceBundle)this.getResourceBundle(locale), (String)("javax.portlet.title." + this.getPortletId()));
    }

    @Override
    public String getPortletURL(HttpServletRequest request) throws PortalException {
        if (Validator.isNull((String)this.getPortletId())) {
            return null;
        }
        return PersonalApplicationURLUtil.getPersonalApplicationURL(request, this.getPortletId());
    }

    @Override
    public boolean isActive(PortletRequest portletRequest, String portletId) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        String layoutFriendlyURL = layout.getFriendlyURL();
        if (!layout.isTypeControlPanel() && !layout.isSystem() || !layoutFriendlyURL.equals(PropsUtil.get((String)"control.panel.layout.friendly.url"))) {
            return false;
        }
        return portletId.equals(this.getPortletId());
    }

    protected abstract String getPortletId();

    protected ResourceBundle getResourceBundle(Locale locale) {
        return ResourceBundleUtil.getBundle((Locale)locale, this.getClass());
    }
}

