/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.product.navigation.personal.menu.util;

import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.product.navigation.personal.menu.configuration.PersonalMenuConfiguration;
import com.liferay.product.navigation.personal.menu.configuration.PersonalMenuConfigurationTracker;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public class PersonalApplicationURLUtil {
    private static final Log _log = LogFactoryUtil.getLog(PersonalApplicationURLUtil.class);
    private static final ServiceTracker<PersonalMenuConfigurationTracker, PersonalMenuConfigurationTracker> _serviceTracker;

    public static String getPersonalApplicationURL(HttpServletRequest request, String portletId) throws PortalException {
        User user = PortalUtil.getUser((HttpServletRequest)request);
        Group group = user.getGroup();
        boolean privateLayout = true;
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PersonalMenuConfiguration personalMenuConfiguration = PersonalApplicationURLUtil._getPersonalMenuConfigurationTracker().getCompanyPersonalMenuConfiguration(themeDisplay.getCompanyId());
        String personalApplicationsLookAndFeel = personalMenuConfiguration.personalApplicationsLookAndFeel();
        if (personalApplicationsLookAndFeel.equals("current-site")) {
            user = UserLocalServiceUtil.getDefaultUser((long)themeDisplay.getCompanyId());
            group = GroupLocalServiceUtil.getGroup((long)PortalUtil.getScopeGroupId((HttpServletRequest)request));
            Layout currentLayout = themeDisplay.getLayout();
            if (currentLayout.isPublicLayout()) {
                privateLayout = false;
            }
        }
        Layout layout = null;
        try {
            layout = LayoutLocalServiceUtil.getFriendlyURLLayout((long)group.getGroupId(), (boolean)privateLayout, (String)PropsValues.CONTROL_PANEL_LAYOUT_FRIENDLY_URL);
        }
        catch (NoSuchLayoutException nsle) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)nsle, (Throwable)nsle);
            }
            layout = PersonalApplicationURLUtil._addEmbeddedPersonalApplicationLayout(user.getUserId(), group.getGroupId(), privateLayout);
        }
        LiferayPortletURL liferayPortletURL = PortletURLFactoryUtil.create((HttpServletRequest)request, (String)portletId, (Layout)layout, (String)"RENDER_PHASE");
        return liferayPortletURL.toString();
    }

    private static Layout _addEmbeddedPersonalApplicationLayout(long userId, long groupId, boolean privateLayout) throws PortalException {
        String friendlyURL = FriendlyURLNormalizerUtil.normalize((String)PropsValues.CONTROL_PANEL_LAYOUT_FRIENDLY_URL);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAttribute("layout.instanceable.allowed", (Serializable)Boolean.TRUE);
        Layout layout = LayoutLocalServiceUtil.addLayout((long)userId, (long)groupId, (boolean)privateLayout, (long)0L, (String)PropsValues.CONTROL_PANEL_LAYOUT_NAME, (String)"", (String)"", (String)"portlet", (boolean)true, (boolean)true, (String)friendlyURL, (ServiceContext)serviceContext);
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        layoutTypePortlet.setLayoutTemplateId(userId, "1_column_dynamic", false);
        return LayoutLocalServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layout.getTypeSettings());
    }

    private static PersonalMenuConfigurationTracker _getPersonalMenuConfigurationTracker() {
        return (PersonalMenuConfigurationTracker)_serviceTracker.getService();
    }

    static {
        Bundle bundle = FrameworkUtil.getBundle(PersonalMenuConfigurationTracker.class);
        ServiceTracker serviceTracker = new ServiceTracker(bundle.getBundleContext(), PersonalMenuConfigurationTracker.class, null);
        serviceTracker.open();
        _serviceTracker = serviceTracker;
    }
}

