/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portlet.asset.model.impl;

import aQute.bnd.annotation.ProviderType;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetEntryModel;
import com.liferay.asset.kernel.model.AssetEntrySoap;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.Validator;

import java.io.Serializable;

import java.sql.Types;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/**
 * The base model implementation for the AssetEntry service. Represents a row in the &quot;AssetEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link AssetEntryModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link AssetEntryImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see AssetEntryImpl
 * @see AssetEntry
 * @see AssetEntryModel
 * @generated
 */
@JSON(strict = true)
@ProviderType
public class AssetEntryModelImpl extends BaseModelImpl<AssetEntry>
	implements AssetEntryModel {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a asset entry model instance should use the {@link AssetEntry} interface instead.
	 */
	public static final String TABLE_NAME = "AssetEntry";
	public static final Object[][] TABLE_COLUMNS = {
			{ "entryId", Types.BIGINT },
			{ "groupId", Types.BIGINT },
			{ "companyId", Types.BIGINT },
			{ "userId", Types.BIGINT },
			{ "userName", Types.VARCHAR },
			{ "createDate", Types.TIMESTAMP },
			{ "modifiedDate", Types.TIMESTAMP },
			{ "classNameId", Types.BIGINT },
			{ "classPK", Types.BIGINT },
			{ "classUuid", Types.VARCHAR },
			{ "classTypeId", Types.BIGINT },
			{ "listable", Types.BOOLEAN },
			{ "visible", Types.BOOLEAN },
			{ "startDate", Types.TIMESTAMP },
			{ "endDate", Types.TIMESTAMP },
			{ "publishDate", Types.TIMESTAMP },
			{ "expirationDate", Types.TIMESTAMP },
			{ "mimeType", Types.VARCHAR },
			{ "title", Types.VARCHAR },
			{ "description", Types.CLOB },
			{ "summary", Types.CLOB },
			{ "url", Types.VARCHAR },
			{ "layoutUuid", Types.VARCHAR },
			{ "height", Types.INTEGER },
			{ "width", Types.INTEGER },
			{ "priority", Types.DOUBLE },
			{ "viewCount", Types.INTEGER }
		};
	public static final Map<String, Integer> TABLE_COLUMNS_MAP = new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("entryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("classNameId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("classPK", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("classUuid", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("classTypeId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("listable", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("visible", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("startDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("endDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("publishDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("expirationDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("mimeType", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("title", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("description", Types.CLOB);
		TABLE_COLUMNS_MAP.put("summary", Types.CLOB);
		TABLE_COLUMNS_MAP.put("url", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("layoutUuid", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("height", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("width", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("priority", Types.DOUBLE);
		TABLE_COLUMNS_MAP.put("viewCount", Types.INTEGER);
	}

	public static final String TABLE_SQL_CREATE = "create table AssetEntry (entryId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,classNameId LONG,classPK LONG,classUuid VARCHAR(75) null,classTypeId LONG,listable BOOLEAN,visible BOOLEAN,startDate DATE null,endDate DATE null,publishDate DATE null,expirationDate DATE null,mimeType VARCHAR(75) null,title STRING null,description TEXT null,summary TEXT null,url STRING null,layoutUuid VARCHAR(75) null,height INTEGER,width INTEGER,priority DOUBLE,viewCount INTEGER)";
	public static final String TABLE_SQL_DROP = "drop table AssetEntry";
	public static final String ORDER_BY_JPQL = " ORDER BY assetEntry.entryId ASC";
	public static final String ORDER_BY_SQL = " ORDER BY AssetEntry.entryId ASC";
	public static final String DATA_SOURCE = "liferayDataSource";
	public static final String SESSION_FACTORY = "liferaySessionFactory";
	public static final String TX_MANAGER = "liferayTransactionManager";
	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.portal.util.PropsUtil.get(
				"value.object.entity.cache.enabled.com.liferay.asset.kernel.model.AssetEntry"),
			true);
	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.portal.util.PropsUtil.get(
				"value.object.finder.cache.enabled.com.liferay.asset.kernel.model.AssetEntry"),
			true);
	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.portal.util.PropsUtil.get(
				"value.object.column.bitmask.enabled.com.liferay.asset.kernel.model.AssetEntry"),
			true);
	public static final long CLASSNAMEID_COLUMN_BITMASK = 1L;
	public static final long CLASSPK_COLUMN_BITMASK = 2L;
	public static final long CLASSUUID_COLUMN_BITMASK = 4L;
	public static final long COMPANYID_COLUMN_BITMASK = 8L;
	public static final long EXPIRATIONDATE_COLUMN_BITMASK = 16L;
	public static final long GROUPID_COLUMN_BITMASK = 32L;
	public static final long LAYOUTUUID_COLUMN_BITMASK = 64L;
	public static final long PUBLISHDATE_COLUMN_BITMASK = 128L;
	public static final long VISIBLE_COLUMN_BITMASK = 256L;
	public static final long ENTRYID_COLUMN_BITMASK = 512L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 */
	public static AssetEntry toModel(AssetEntrySoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		AssetEntry model = new AssetEntryImpl();

		model.setEntryId(soapModel.getEntryId());
		model.setGroupId(soapModel.getGroupId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setClassNameId(soapModel.getClassNameId());
		model.setClassPK(soapModel.getClassPK());
		model.setClassUuid(soapModel.getClassUuid());
		model.setClassTypeId(soapModel.getClassTypeId());
		model.setListable(soapModel.getListable());
		model.setVisible(soapModel.getVisible());
		model.setStartDate(soapModel.getStartDate());
		model.setEndDate(soapModel.getEndDate());
		model.setPublishDate(soapModel.getPublishDate());
		model.setExpirationDate(soapModel.getExpirationDate());
		model.setMimeType(soapModel.getMimeType());
		model.setTitle(soapModel.getTitle());
		model.setDescription(soapModel.getDescription());
		model.setSummary(soapModel.getSummary());
		model.setUrl(soapModel.getUrl());
		model.setLayoutUuid(soapModel.getLayoutUuid());
		model.setHeight(soapModel.getHeight());
		model.setWidth(soapModel.getWidth());
		model.setPriority(soapModel.getPriority());
		model.setViewCount(soapModel.getViewCount());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 */
	public static List<AssetEntry> toModels(AssetEntrySoap[] soapModels) {
		if (soapModels == null) {
			return null;
		}

		List<AssetEntry> models = new ArrayList<AssetEntry>(soapModels.length);

		for (AssetEntrySoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final String MAPPING_TABLE_ASSETENTRIES_ASSETCATEGORIES_NAME = "AssetEntries_AssetCategories";
	public static final Object[][] MAPPING_TABLE_ASSETENTRIES_ASSETCATEGORIES_COLUMNS =
		{
			{ "companyId", Types.BIGINT },
			{ "categoryId", Types.BIGINT },
			{ "entryId", Types.BIGINT }
		};
	public static final String MAPPING_TABLE_ASSETENTRIES_ASSETCATEGORIES_SQL_CREATE =
		"create table AssetEntries_AssetCategories (companyId LONG not null,categoryId LONG not null,entryId LONG not null,primary key (categoryId, entryId))";
	public static final boolean FINDER_CACHE_ENABLED_ASSETENTRIES_ASSETCATEGORIES =
		GetterUtil.getBoolean(com.liferay.portal.util.PropsUtil.get(
				"value.object.finder.cache.enabled.AssetEntries_AssetCategories"),
			true);
	public static final String MAPPING_TABLE_ASSETENTRIES_ASSETTAGS_NAME = "AssetEntries_AssetTags";
	public static final Object[][] MAPPING_TABLE_ASSETENTRIES_ASSETTAGS_COLUMNS = {
			{ "companyId", Types.BIGINT },
			{ "entryId", Types.BIGINT },
			{ "tagId", Types.BIGINT }
		};
	public static final String MAPPING_TABLE_ASSETENTRIES_ASSETTAGS_SQL_CREATE = "create table AssetEntries_AssetTags (companyId LONG not null,entryId LONG not null,tagId LONG not null,primary key (entryId, tagId))";
	public static final boolean FINDER_CACHE_ENABLED_ASSETENTRIES_ASSETTAGS = GetterUtil.getBoolean(com.liferay.portal.util.PropsUtil.get(
				"value.object.finder.cache.enabled.AssetEntries_AssetTags"),
			true);
	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.portal.util.PropsUtil.get(
				"lock.expiration.time.com.liferay.asset.kernel.model.AssetEntry"));

	public AssetEntryModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _entryId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setEntryId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _entryId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return AssetEntry.class;
	}

	@Override
	public String getModelClassName() {
		return AssetEntry.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		attributes.put("entryId", getEntryId());
		attributes.put("groupId", getGroupId());
		attributes.put("companyId", getCompanyId());
		attributes.put("userId", getUserId());
		attributes.put("userName", getUserName());
		attributes.put("createDate", getCreateDate());
		attributes.put("modifiedDate", getModifiedDate());
		attributes.put("classNameId", getClassNameId());
		attributes.put("classPK", getClassPK());
		attributes.put("classUuid", getClassUuid());
		attributes.put("classTypeId", getClassTypeId());
		attributes.put("listable", getListable());
		attributes.put("visible", getVisible());
		attributes.put("startDate", getStartDate());
		attributes.put("endDate", getEndDate());
		attributes.put("publishDate", getPublishDate());
		attributes.put("expirationDate", getExpirationDate());
		attributes.put("mimeType", getMimeType());
		attributes.put("title", getTitle());
		attributes.put("description", getDescription());
		attributes.put("summary", getSummary());
		attributes.put("url", getUrl());
		attributes.put("layoutUuid", getLayoutUuid());
		attributes.put("height", getHeight());
		attributes.put("width", getWidth());
		attributes.put("priority", getPriority());
		attributes.put("viewCount", getViewCount());

		attributes.put("entityCacheEnabled", isEntityCacheEnabled());
		attributes.put("finderCacheEnabled", isFinderCacheEnabled());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Long entryId = (Long)attributes.get("entryId");

		if (entryId != null) {
			setEntryId(entryId);
		}

		Long groupId = (Long)attributes.get("groupId");

		if (groupId != null) {
			setGroupId(groupId);
		}

		Long companyId = (Long)attributes.get("companyId");

		if (companyId != null) {
			setCompanyId(companyId);
		}

		Long userId = (Long)attributes.get("userId");

		if (userId != null) {
			setUserId(userId);
		}

		String userName = (String)attributes.get("userName");

		if (userName != null) {
			setUserName(userName);
		}

		Date createDate = (Date)attributes.get("createDate");

		if (createDate != null) {
			setCreateDate(createDate);
		}

		Date modifiedDate = (Date)attributes.get("modifiedDate");

		if (modifiedDate != null) {
			setModifiedDate(modifiedDate);
		}

		Long classNameId = (Long)attributes.get("classNameId");

		if (classNameId != null) {
			setClassNameId(classNameId);
		}

		Long classPK = (Long)attributes.get("classPK");

		if (classPK != null) {
			setClassPK(classPK);
		}

		String classUuid = (String)attributes.get("classUuid");

		if (classUuid != null) {
			setClassUuid(classUuid);
		}

		Long classTypeId = (Long)attributes.get("classTypeId");

		if (classTypeId != null) {
			setClassTypeId(classTypeId);
		}

		Boolean listable = (Boolean)attributes.get("listable");

		if (listable != null) {
			setListable(listable);
		}

		Boolean visible = (Boolean)attributes.get("visible");

		if (visible != null) {
			setVisible(visible);
		}

		Date startDate = (Date)attributes.get("startDate");

		if (startDate != null) {
			setStartDate(startDate);
		}

		Date endDate = (Date)attributes.get("endDate");

		if (endDate != null) {
			setEndDate(endDate);
		}

		Date publishDate = (Date)attributes.get("publishDate");

		if (publishDate != null) {
			setPublishDate(publishDate);
		}

		Date expirationDate = (Date)attributes.get("expirationDate");

		if (expirationDate != null) {
			setExpirationDate(expirationDate);
		}

		String mimeType = (String)attributes.get("mimeType");

		if (mimeType != null) {
			setMimeType(mimeType);
		}

		String title = (String)attributes.get("title");

		if (title != null) {
			setTitle(title);
		}

		String description = (String)attributes.get("description");

		if (description != null) {
			setDescription(description);
		}

		String summary = (String)attributes.get("summary");

		if (summary != null) {
			setSummary(summary);
		}

		String url = (String)attributes.get("url");

		if (url != null) {
			setUrl(url);
		}

		String layoutUuid = (String)attributes.get("layoutUuid");

		if (layoutUuid != null) {
			setLayoutUuid(layoutUuid);
		}

		Integer height = (Integer)attributes.get("height");

		if (height != null) {
			setHeight(height);
		}

		Integer width = (Integer)attributes.get("width");

		if (width != null) {
			setWidth(width);
		}

		Double priority = (Double)attributes.get("priority");

		if (priority != null) {
			setPriority(priority);
		}

		Integer viewCount = (Integer)attributes.get("viewCount");

		if (viewCount != null) {
			setViewCount(viewCount);
		}
	}

	@JSON
	@Override
	public long getEntryId() {
		return _entryId;
	}

	@Override
	public void setEntryId(long entryId) {
		_entryId = entryId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		_columnBitmask |= GROUPID_COLUMN_BITMASK;

		if (!_setOriginalGroupId) {
			_setOriginalGroupId = true;

			_originalGroupId = _groupId;
		}

		_groupId = groupId;
	}

	public long getOriginalGroupId() {
		return _originalGroupId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_columnBitmask |= COMPANYID_COLUMN_BITMASK;

		if (!_setOriginalCompanyId) {
			_setOriginalCompanyId = true;

			_originalCompanyId = _companyId;
		}

		_companyId = companyId;
	}

	public long getOriginalCompanyId() {
		return _originalCompanyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException pe) {
			return StringPool.BLANK;
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return StringPool.BLANK;
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		_modifiedDate = modifiedDate;
	}

	@Override
	public String getClassName() {
		if (getClassNameId() <= 0) {
			return StringPool.BLANK;
		}

		return PortalUtil.getClassName(getClassNameId());
	}

	@Override
	public void setClassName(String className) {
		long classNameId = 0;

		if (Validator.isNotNull(className)) {
			classNameId = PortalUtil.getClassNameId(className);
		}

		setClassNameId(classNameId);
	}

	@JSON
	@Override
	public long getClassNameId() {
		return _classNameId;
	}

	@Override
	public void setClassNameId(long classNameId) {
		_columnBitmask |= CLASSNAMEID_COLUMN_BITMASK;

		if (!_setOriginalClassNameId) {
			_setOriginalClassNameId = true;

			_originalClassNameId = _classNameId;
		}

		_classNameId = classNameId;
	}

	public long getOriginalClassNameId() {
		return _originalClassNameId;
	}

	@JSON
	@Override
	public long getClassPK() {
		return _classPK;
	}

	@Override
	public void setClassPK(long classPK) {
		_columnBitmask |= CLASSPK_COLUMN_BITMASK;

		if (!_setOriginalClassPK) {
			_setOriginalClassPK = true;

			_originalClassPK = _classPK;
		}

		_classPK = classPK;
	}

	public long getOriginalClassPK() {
		return _originalClassPK;
	}

	@JSON
	@Override
	public String getClassUuid() {
		if (_classUuid == null) {
			return StringPool.BLANK;
		}
		else {
			return _classUuid;
		}
	}

	@Override
	public void setClassUuid(String classUuid) {
		_columnBitmask |= CLASSUUID_COLUMN_BITMASK;

		if (_originalClassUuid == null) {
			_originalClassUuid = _classUuid;
		}

		_classUuid = classUuid;
	}

	public String getOriginalClassUuid() {
		return GetterUtil.getString(_originalClassUuid);
	}

	@JSON
	@Override
	public long getClassTypeId() {
		return _classTypeId;
	}

	@Override
	public void setClassTypeId(long classTypeId) {
		_classTypeId = classTypeId;
	}

	@JSON
	@Override
	public boolean getListable() {
		return _listable;
	}

	@JSON
	@Override
	public boolean isListable() {
		return _listable;
	}

	@Override
	public void setListable(boolean listable) {
		_listable = listable;
	}

	@JSON
	@Override
	public boolean getVisible() {
		return _visible;
	}

	@JSON
	@Override
	public boolean isVisible() {
		return _visible;
	}

	@Override
	public void setVisible(boolean visible) {
		_columnBitmask |= VISIBLE_COLUMN_BITMASK;

		if (!_setOriginalVisible) {
			_setOriginalVisible = true;

			_originalVisible = _visible;
		}

		_visible = visible;
	}

	public boolean getOriginalVisible() {
		return _originalVisible;
	}

	@JSON
	@Override
	public Date getStartDate() {
		return _startDate;
	}

	@Override
	public void setStartDate(Date startDate) {
		_startDate = startDate;
	}

	@JSON
	@Override
	public Date getEndDate() {
		return _endDate;
	}

	@Override
	public void setEndDate(Date endDate) {
		_endDate = endDate;
	}

	@JSON
	@Override
	public Date getPublishDate() {
		return _publishDate;
	}

	@Override
	public void setPublishDate(Date publishDate) {
		_columnBitmask |= PUBLISHDATE_COLUMN_BITMASK;

		if (_originalPublishDate == null) {
			_originalPublishDate = _publishDate;
		}

		_publishDate = publishDate;
	}

	public Date getOriginalPublishDate() {
		return _originalPublishDate;
	}

	@JSON
	@Override
	public Date getExpirationDate() {
		return _expirationDate;
	}

	@Override
	public void setExpirationDate(Date expirationDate) {
		_columnBitmask |= EXPIRATIONDATE_COLUMN_BITMASK;

		if (_originalExpirationDate == null) {
			_originalExpirationDate = _expirationDate;
		}

		_expirationDate = expirationDate;
	}

	public Date getOriginalExpirationDate() {
		return _originalExpirationDate;
	}

	@JSON
	@Override
	public String getMimeType() {
		if (_mimeType == null) {
			return StringPool.BLANK;
		}
		else {
			return _mimeType;
		}
	}

	@Override
	public void setMimeType(String mimeType) {
		_mimeType = mimeType;
	}

	@JSON
	@Override
	public String getTitle() {
		if (_title == null) {
			return StringPool.BLANK;
		}
		else {
			return _title;
		}
	}

	@Override
	public String getTitle(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getTitle(languageId);
	}

	@Override
	public String getTitle(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getTitle(languageId, useDefault);
	}

	@Override
	public String getTitle(String languageId) {
		return LocalizationUtil.getLocalization(getTitle(), languageId);
	}

	@Override
	public String getTitle(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(getTitle(), languageId,
			useDefault);
	}

	@Override
	public String getTitleCurrentLanguageId() {
		return _titleCurrentLanguageId;
	}

	@JSON
	@Override
	public String getTitleCurrentValue() {
		Locale locale = getLocale(_titleCurrentLanguageId);

		return getTitle(locale);
	}

	@Override
	public Map<Locale, String> getTitleMap() {
		return LocalizationUtil.getLocalizationMap(getTitle());
	}

	@Override
	public void setTitle(String title) {
		_title = title;
	}

	@Override
	public void setTitle(String title, Locale locale) {
		setTitle(title, locale, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setTitle(String title, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(title)) {
			setTitle(LocalizationUtil.updateLocalization(getTitle(), "Title",
					title, languageId, defaultLanguageId));
		}
		else {
			setTitle(LocalizationUtil.removeLocalization(getTitle(), "Title",
					languageId));
		}
	}

	@Override
	public void setTitleCurrentLanguageId(String languageId) {
		_titleCurrentLanguageId = languageId;
	}

	@Override
	public void setTitleMap(Map<Locale, String> titleMap) {
		setTitleMap(titleMap, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setTitleMap(Map<Locale, String> titleMap, Locale defaultLocale) {
		if (titleMap == null) {
			return;
		}

		setTitle(LocalizationUtil.updateLocalization(titleMap, getTitle(),
				"Title", LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getDescription() {
		if (_description == null) {
			return StringPool.BLANK;
		}
		else {
			return _description;
		}
	}

	@Override
	public String getDescription(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getDescription(languageId);
	}

	@Override
	public String getDescription(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getDescription(languageId, useDefault);
	}

	@Override
	public String getDescription(String languageId) {
		return LocalizationUtil.getLocalization(getDescription(), languageId);
	}

	@Override
	public String getDescription(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(getDescription(), languageId,
			useDefault);
	}

	@Override
	public String getDescriptionCurrentLanguageId() {
		return _descriptionCurrentLanguageId;
	}

	@JSON
	@Override
	public String getDescriptionCurrentValue() {
		Locale locale = getLocale(_descriptionCurrentLanguageId);

		return getDescription(locale);
	}

	@Override
	public Map<Locale, String> getDescriptionMap() {
		return LocalizationUtil.getLocalizationMap(getDescription());
	}

	@Override
	public void setDescription(String description) {
		_description = description;
	}

	@Override
	public void setDescription(String description, Locale locale) {
		setDescription(description, locale, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setDescription(String description, Locale locale,
		Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(description)) {
			setDescription(LocalizationUtil.updateLocalization(
					getDescription(), "Description", description, languageId,
					defaultLanguageId));
		}
		else {
			setDescription(LocalizationUtil.removeLocalization(
					getDescription(), "Description", languageId));
		}
	}

	@Override
	public void setDescriptionCurrentLanguageId(String languageId) {
		_descriptionCurrentLanguageId = languageId;
	}

	@Override
	public void setDescriptionMap(Map<Locale, String> descriptionMap) {
		setDescriptionMap(descriptionMap, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setDescriptionMap(Map<Locale, String> descriptionMap,
		Locale defaultLocale) {
		if (descriptionMap == null) {
			return;
		}

		setDescription(LocalizationUtil.updateLocalization(descriptionMap,
				getDescription(), "Description",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getSummary() {
		if (_summary == null) {
			return StringPool.BLANK;
		}
		else {
			return _summary;
		}
	}

	@Override
	public String getSummary(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getSummary(languageId);
	}

	@Override
	public String getSummary(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getSummary(languageId, useDefault);
	}

	@Override
	public String getSummary(String languageId) {
		return LocalizationUtil.getLocalization(getSummary(), languageId);
	}

	@Override
	public String getSummary(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(getSummary(), languageId,
			useDefault);
	}

	@Override
	public String getSummaryCurrentLanguageId() {
		return _summaryCurrentLanguageId;
	}

	@JSON
	@Override
	public String getSummaryCurrentValue() {
		Locale locale = getLocale(_summaryCurrentLanguageId);

		return getSummary(locale);
	}

	@Override
	public Map<Locale, String> getSummaryMap() {
		return LocalizationUtil.getLocalizationMap(getSummary());
	}

	@Override
	public void setSummary(String summary) {
		_summary = summary;
	}

	@Override
	public void setSummary(String summary, Locale locale) {
		setSummary(summary, locale, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setSummary(String summary, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(summary)) {
			setSummary(LocalizationUtil.updateLocalization(getSummary(),
					"Summary", summary, languageId, defaultLanguageId));
		}
		else {
			setSummary(LocalizationUtil.removeLocalization(getSummary(),
					"Summary", languageId));
		}
	}

	@Override
	public void setSummaryCurrentLanguageId(String languageId) {
		_summaryCurrentLanguageId = languageId;
	}

	@Override
	public void setSummaryMap(Map<Locale, String> summaryMap) {
		setSummaryMap(summaryMap, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setSummaryMap(Map<Locale, String> summaryMap,
		Locale defaultLocale) {
		if (summaryMap == null) {
			return;
		}

		setSummary(LocalizationUtil.updateLocalization(summaryMap,
				getSummary(), "Summary", LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getUrl() {
		if (_url == null) {
			return StringPool.BLANK;
		}
		else {
			return _url;
		}
	}

	@Override
	public void setUrl(String url) {
		_url = url;
	}

	@JSON
	@Override
	public String getLayoutUuid() {
		if (_layoutUuid == null) {
			return StringPool.BLANK;
		}
		else {
			return _layoutUuid;
		}
	}

	@Override
	public void setLayoutUuid(String layoutUuid) {
		_columnBitmask |= LAYOUTUUID_COLUMN_BITMASK;

		if (_originalLayoutUuid == null) {
			_originalLayoutUuid = _layoutUuid;
		}

		_layoutUuid = layoutUuid;
	}

	public String getOriginalLayoutUuid() {
		return GetterUtil.getString(_originalLayoutUuid);
	}

	@JSON
	@Override
	public int getHeight() {
		return _height;
	}

	@Override
	public void setHeight(int height) {
		_height = height;
	}

	@JSON
	@Override
	public int getWidth() {
		return _width;
	}

	@Override
	public void setWidth(int width) {
		_width = width;
	}

	@JSON
	@Override
	public double getPriority() {
		return _priority;
	}

	@Override
	public void setPriority(double priority) {
		_priority = priority;
	}

	@JSON
	@Override
	public int getViewCount() {
		return _viewCount;
	}

	@Override
	public void setViewCount(int viewCount) {
		_viewCount = viewCount;
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(getCompanyId(),
			AssetEntry.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public String[] getAvailableLanguageIds() {
		Set<String> availableLanguageIds = new TreeSet<String>();

		Map<Locale, String> titleMap = getTitleMap();

		for (Map.Entry<Locale, String> entry : titleMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		Map<Locale, String> descriptionMap = getDescriptionMap();

		for (Map.Entry<Locale, String> entry : descriptionMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		Map<Locale, String> summaryMap = getSummaryMap();

		for (Map.Entry<Locale, String> entry : summaryMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		return availableLanguageIds.toArray(new String[availableLanguageIds.size()]);
	}

	@Override
	public String getDefaultLanguageId() {
		String xml = getTitle();

		if (xml == null) {
			return StringPool.BLANK;
		}

		Locale defaultLocale = LocaleUtil.getSiteDefault();

		return LocalizationUtil.getDefaultLanguageId(xml, defaultLocale);
	}

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException {
		Locale defaultLocale = LocaleUtil.fromLanguageId(getDefaultLanguageId());

		Locale[] availableLocales = LocaleUtil.fromLanguageIds(getAvailableLanguageIds());

		Locale defaultImportLocale = LocalizationUtil.getDefaultImportLocale(AssetEntry.class.getName(),
				getPrimaryKey(), defaultLocale, availableLocales);

		prepareLocalizedFieldsForImport(defaultImportLocale);
	}

	@Override
	@SuppressWarnings("unused")
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException {
		Locale defaultLocale = LocaleUtil.getSiteDefault();

		String modelDefaultLanguageId = getDefaultLanguageId();

		String title = getTitle(defaultLocale);

		if (Validator.isNull(title)) {
			setTitle(getTitle(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setTitle(getTitle(defaultLocale), defaultLocale, defaultLocale);
		}

		String description = getDescription(defaultLocale);

		if (Validator.isNull(description)) {
			setDescription(getDescription(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setDescription(getDescription(defaultLocale), defaultLocale,
				defaultLocale);
		}

		String summary = getSummary(defaultLocale);

		if (Validator.isNull(summary)) {
			setSummary(getSummary(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setSummary(getSummary(defaultLocale), defaultLocale, defaultLocale);
		}
	}

	@Override
	public AssetEntry toEscapedModel() {
		if (_escapedModel == null) {
			_escapedModel = (AssetEntry)ProxyUtil.newProxyInstance(_classLoader,
					_escapedModelInterfaces, new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		AssetEntryImpl assetEntryImpl = new AssetEntryImpl();

		assetEntryImpl.setEntryId(getEntryId());
		assetEntryImpl.setGroupId(getGroupId());
		assetEntryImpl.setCompanyId(getCompanyId());
		assetEntryImpl.setUserId(getUserId());
		assetEntryImpl.setUserName(getUserName());
		assetEntryImpl.setCreateDate(getCreateDate());
		assetEntryImpl.setModifiedDate(getModifiedDate());
		assetEntryImpl.setClassNameId(getClassNameId());
		assetEntryImpl.setClassPK(getClassPK());
		assetEntryImpl.setClassUuid(getClassUuid());
		assetEntryImpl.setClassTypeId(getClassTypeId());
		assetEntryImpl.setListable(getListable());
		assetEntryImpl.setVisible(getVisible());
		assetEntryImpl.setStartDate(getStartDate());
		assetEntryImpl.setEndDate(getEndDate());
		assetEntryImpl.setPublishDate(getPublishDate());
		assetEntryImpl.setExpirationDate(getExpirationDate());
		assetEntryImpl.setMimeType(getMimeType());
		assetEntryImpl.setTitle(getTitle());
		assetEntryImpl.setDescription(getDescription());
		assetEntryImpl.setSummary(getSummary());
		assetEntryImpl.setUrl(getUrl());
		assetEntryImpl.setLayoutUuid(getLayoutUuid());
		assetEntryImpl.setHeight(getHeight());
		assetEntryImpl.setWidth(getWidth());
		assetEntryImpl.setPriority(getPriority());
		assetEntryImpl.setViewCount(getViewCount());

		assetEntryImpl.resetOriginalValues();

		return assetEntryImpl;
	}

	@Override
	public int compareTo(AssetEntry assetEntry) {
		long primaryKey = assetEntry.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof AssetEntry)) {
			return false;
		}

		AssetEntry assetEntry = (AssetEntry)obj;

		long primaryKey = assetEntry.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		AssetEntryModelImpl assetEntryModelImpl = this;

		assetEntryModelImpl._originalGroupId = assetEntryModelImpl._groupId;

		assetEntryModelImpl._setOriginalGroupId = false;

		assetEntryModelImpl._originalCompanyId = assetEntryModelImpl._companyId;

		assetEntryModelImpl._setOriginalCompanyId = false;

		assetEntryModelImpl._setModifiedDate = false;

		assetEntryModelImpl._originalClassNameId = assetEntryModelImpl._classNameId;

		assetEntryModelImpl._setOriginalClassNameId = false;

		assetEntryModelImpl._originalClassPK = assetEntryModelImpl._classPK;

		assetEntryModelImpl._setOriginalClassPK = false;

		assetEntryModelImpl._originalClassUuid = assetEntryModelImpl._classUuid;

		assetEntryModelImpl._originalVisible = assetEntryModelImpl._visible;

		assetEntryModelImpl._setOriginalVisible = false;

		assetEntryModelImpl._originalPublishDate = assetEntryModelImpl._publishDate;

		assetEntryModelImpl._originalExpirationDate = assetEntryModelImpl._expirationDate;

		assetEntryModelImpl._originalLayoutUuid = assetEntryModelImpl._layoutUuid;

		assetEntryModelImpl._columnBitmask = 0;
	}

	@Override
	public CacheModel<AssetEntry> toCacheModel() {
		AssetEntryCacheModel assetEntryCacheModel = new AssetEntryCacheModel();

		assetEntryCacheModel.entryId = getEntryId();

		assetEntryCacheModel.groupId = getGroupId();

		assetEntryCacheModel.companyId = getCompanyId();

		assetEntryCacheModel.userId = getUserId();

		assetEntryCacheModel.userName = getUserName();

		String userName = assetEntryCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			assetEntryCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			assetEntryCacheModel.createDate = createDate.getTime();
		}
		else {
			assetEntryCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			assetEntryCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			assetEntryCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		assetEntryCacheModel.classNameId = getClassNameId();

		assetEntryCacheModel.classPK = getClassPK();

		assetEntryCacheModel.classUuid = getClassUuid();

		String classUuid = assetEntryCacheModel.classUuid;

		if ((classUuid != null) && (classUuid.length() == 0)) {
			assetEntryCacheModel.classUuid = null;
		}

		assetEntryCacheModel.classTypeId = getClassTypeId();

		assetEntryCacheModel.listable = getListable();

		assetEntryCacheModel.visible = getVisible();

		Date startDate = getStartDate();

		if (startDate != null) {
			assetEntryCacheModel.startDate = startDate.getTime();
		}
		else {
			assetEntryCacheModel.startDate = Long.MIN_VALUE;
		}

		Date endDate = getEndDate();

		if (endDate != null) {
			assetEntryCacheModel.endDate = endDate.getTime();
		}
		else {
			assetEntryCacheModel.endDate = Long.MIN_VALUE;
		}

		Date publishDate = getPublishDate();

		if (publishDate != null) {
			assetEntryCacheModel.publishDate = publishDate.getTime();
		}
		else {
			assetEntryCacheModel.publishDate = Long.MIN_VALUE;
		}

		Date expirationDate = getExpirationDate();

		if (expirationDate != null) {
			assetEntryCacheModel.expirationDate = expirationDate.getTime();
		}
		else {
			assetEntryCacheModel.expirationDate = Long.MIN_VALUE;
		}

		assetEntryCacheModel.mimeType = getMimeType();

		String mimeType = assetEntryCacheModel.mimeType;

		if ((mimeType != null) && (mimeType.length() == 0)) {
			assetEntryCacheModel.mimeType = null;
		}

		assetEntryCacheModel.title = getTitle();

		String title = assetEntryCacheModel.title;

		if ((title != null) && (title.length() == 0)) {
			assetEntryCacheModel.title = null;
		}

		assetEntryCacheModel.description = getDescription();

		String description = assetEntryCacheModel.description;

		if ((description != null) && (description.length() == 0)) {
			assetEntryCacheModel.description = null;
		}

		assetEntryCacheModel.summary = getSummary();

		String summary = assetEntryCacheModel.summary;

		if ((summary != null) && (summary.length() == 0)) {
			assetEntryCacheModel.summary = null;
		}

		assetEntryCacheModel.url = getUrl();

		String url = assetEntryCacheModel.url;

		if ((url != null) && (url.length() == 0)) {
			assetEntryCacheModel.url = null;
		}

		assetEntryCacheModel.layoutUuid = getLayoutUuid();

		String layoutUuid = assetEntryCacheModel.layoutUuid;

		if ((layoutUuid != null) && (layoutUuid.length() == 0)) {
			assetEntryCacheModel.layoutUuid = null;
		}

		assetEntryCacheModel.height = getHeight();

		assetEntryCacheModel.width = getWidth();

		assetEntryCacheModel.priority = getPriority();

		assetEntryCacheModel.viewCount = getViewCount();

		return assetEntryCacheModel;
	}

	@Override
	public String toString() {
		StringBundler sb = new StringBundler(55);

		sb.append("{entryId=");
		sb.append(getEntryId());
		sb.append(", groupId=");
		sb.append(getGroupId());
		sb.append(", companyId=");
		sb.append(getCompanyId());
		sb.append(", userId=");
		sb.append(getUserId());
		sb.append(", userName=");
		sb.append(getUserName());
		sb.append(", createDate=");
		sb.append(getCreateDate());
		sb.append(", modifiedDate=");
		sb.append(getModifiedDate());
		sb.append(", classNameId=");
		sb.append(getClassNameId());
		sb.append(", classPK=");
		sb.append(getClassPK());
		sb.append(", classUuid=");
		sb.append(getClassUuid());
		sb.append(", classTypeId=");
		sb.append(getClassTypeId());
		sb.append(", listable=");
		sb.append(getListable());
		sb.append(", visible=");
		sb.append(getVisible());
		sb.append(", startDate=");
		sb.append(getStartDate());
		sb.append(", endDate=");
		sb.append(getEndDate());
		sb.append(", publishDate=");
		sb.append(getPublishDate());
		sb.append(", expirationDate=");
		sb.append(getExpirationDate());
		sb.append(", mimeType=");
		sb.append(getMimeType());
		sb.append(", title=");
		sb.append(getTitle());
		sb.append(", description=");
		sb.append(getDescription());
		sb.append(", summary=");
		sb.append(getSummary());
		sb.append(", url=");
		sb.append(getUrl());
		sb.append(", layoutUuid=");
		sb.append(getLayoutUuid());
		sb.append(", height=");
		sb.append(getHeight());
		sb.append(", width=");
		sb.append(getWidth());
		sb.append(", priority=");
		sb.append(getPriority());
		sb.append(", viewCount=");
		sb.append(getViewCount());
		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		StringBundler sb = new StringBundler(85);

		sb.append("<model><model-name>");
		sb.append("com.liferay.asset.kernel.model.AssetEntry");
		sb.append("</model-name>");

		sb.append(
			"<column><column-name>entryId</column-name><column-value><![CDATA[");
		sb.append(getEntryId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>groupId</column-name><column-value><![CDATA[");
		sb.append(getGroupId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>companyId</column-name><column-value><![CDATA[");
		sb.append(getCompanyId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userId</column-name><column-value><![CDATA[");
		sb.append(getUserId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userName</column-name><column-value><![CDATA[");
		sb.append(getUserName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>createDate</column-name><column-value><![CDATA[");
		sb.append(getCreateDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>modifiedDate</column-name><column-value><![CDATA[");
		sb.append(getModifiedDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>classNameId</column-name><column-value><![CDATA[");
		sb.append(getClassNameId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>classPK</column-name><column-value><![CDATA[");
		sb.append(getClassPK());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>classUuid</column-name><column-value><![CDATA[");
		sb.append(getClassUuid());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>classTypeId</column-name><column-value><![CDATA[");
		sb.append(getClassTypeId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>listable</column-name><column-value><![CDATA[");
		sb.append(getListable());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>visible</column-name><column-value><![CDATA[");
		sb.append(getVisible());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>startDate</column-name><column-value><![CDATA[");
		sb.append(getStartDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>endDate</column-name><column-value><![CDATA[");
		sb.append(getEndDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>publishDate</column-name><column-value><![CDATA[");
		sb.append(getPublishDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>expirationDate</column-name><column-value><![CDATA[");
		sb.append(getExpirationDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>mimeType</column-name><column-value><![CDATA[");
		sb.append(getMimeType());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>title</column-name><column-value><![CDATA[");
		sb.append(getTitle());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>description</column-name><column-value><![CDATA[");
		sb.append(getDescription());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>summary</column-name><column-value><![CDATA[");
		sb.append(getSummary());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>url</column-name><column-value><![CDATA[");
		sb.append(getUrl());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>layoutUuid</column-name><column-value><![CDATA[");
		sb.append(getLayoutUuid());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>height</column-name><column-value><![CDATA[");
		sb.append(getHeight());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>width</column-name><column-value><![CDATA[");
		sb.append(getWidth());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>priority</column-name><column-value><![CDATA[");
		sb.append(getPriority());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>viewCount</column-name><column-value><![CDATA[");
		sb.append(getViewCount());
		sb.append("]]></column-value></column>");

		sb.append("</model>");

		return sb.toString();
	}

	private static final ClassLoader _classLoader = AssetEntry.class.getClassLoader();
	private static final Class<?>[] _escapedModelInterfaces = new Class[] {
			AssetEntry.class
		};
	private long _entryId;
	private long _groupId;
	private long _originalGroupId;
	private boolean _setOriginalGroupId;
	private long _companyId;
	private long _originalCompanyId;
	private boolean _setOriginalCompanyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _classNameId;
	private long _originalClassNameId;
	private boolean _setOriginalClassNameId;
	private long _classPK;
	private long _originalClassPK;
	private boolean _setOriginalClassPK;
	private String _classUuid;
	private String _originalClassUuid;
	private long _classTypeId;
	private boolean _listable;
	private boolean _visible;
	private boolean _originalVisible;
	private boolean _setOriginalVisible;
	private Date _startDate;
	private Date _endDate;
	private Date _publishDate;
	private Date _originalPublishDate;
	private Date _expirationDate;
	private Date _originalExpirationDate;
	private String _mimeType;
	private String _title;
	private String _titleCurrentLanguageId;
	private String _description;
	private String _descriptionCurrentLanguageId;
	private String _summary;
	private String _summaryCurrentLanguageId;
	private String _url;
	private String _layoutUuid;
	private String _originalLayoutUuid;
	private int _height;
	private int _width;
	private double _priority;
	private int _viewCount;
	private long _columnBitmask;
	private AssetEntry _escapedModel;
}