/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.jdbc.util;

import com.liferay.portal.dao.jdbc.util.DataSourceWrapper;
import com.liferay.portal.util.PropsValues;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class RetryDataSourceWrapper
extends DataSourceWrapper {
    public RetryDataSourceWrapper(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    public Connection getConnection() throws SQLException {
        int retries = PropsValues.RETRY_DATA_SOURCE_MAX_RETRIES;
        SQLException sqlException = null;
        while (retries-- >= 0) {
            try {
                return super.getConnection();
            }
            catch (SQLException sqle) {
                if (sqlException != null) continue;
                sqlException = sqle;
            }
        }
        throw sqlException;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        int retries = PropsValues.RETRY_DATA_SOURCE_MAX_RETRIES;
        SQLException sqlException = null;
        while (retries-- >= 0) {
            try {
                return super.getConnection(username, password);
            }
            catch (SQLException sqle) {
                if (sqlException != null) continue;
                sqlException = sqle;
            }
        }
        throw sqlException;
    }
}

